/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.incremental;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.spoofax.interpreter.terms.ISimpleTerm;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.jsglr.client.ParseException;
import org.spoofax.jsglr.client.SGLR;
import org.spoofax.jsglr.client.imploder.AbstractTokenizer;
import org.spoofax.jsglr.client.imploder.ITreeFactory;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.jsglr.client.imploder.TermTreeFactory;
import org.spoofax.jsglr.client.incremental.CommentDamageExpander;
import org.spoofax.jsglr.client.incremental.DamageRegionAnalyzer;
import org.spoofax.jsglr.client.incremental.IncrementalInputBuilder;
import org.spoofax.jsglr.client.incremental.IncrementalSGLRException;
import org.spoofax.jsglr.client.incremental.IncrementalSortSet;
import org.spoofax.jsglr.client.incremental.IncrementalTreeBuilder;
import org.spoofax.jsglr.client.incremental.NeighborDamageExpander;
import org.spoofax.jsglr.shared.BadTokenException;
import org.spoofax.jsglr.shared.SGLRException;
import org.spoofax.jsglr.shared.TokenExpectedException;
import org.spoofax.terms.attachments.ParentAttachment;
import org.spoofax.terms.attachments.ParentTermFactory;
import org.spoofax.terms.util.NotImplementedException;

public class IncrementalSGLR<TNode extends ISimpleTerm> {
    public static boolean DEBUG = false;
    final SGLR parser;
    final ITreeFactory<TNode> factory;
    IncrementalSortSet incrementalSorts;
    private final CommentDamageExpander comments;
    private TNode lastAst;
    private List<TNode> lastReconstructedNodes = Collections.emptyList();

    public IncrementalSGLR(SGLR parser, CommentDamageExpander comments, ITreeFactory<TNode> factory, IncrementalSortSet incrementalSorts) {
        this.parser = parser;
        this.comments = comments == null ? CommentDamageExpander.ONLY_LINE_COMMENTS : comments;
        this.factory = factory;
        this.incrementalSorts = incrementalSorts;
        if (factory instanceof TermTreeFactory) {
            if (!ParentTermFactory.isParentTermFactory(((TermTreeFactory)factory).getOriginalTermFactory())) {
                throw new IllegalArgumentException("Requires a ParentTermFactory-based term factory");
            }
        } else {
            throw new NotImplementedException("Can't check for parent capability of ITreeFactory");
        }
    }

    public TNode parseIncremental(String newInput, String filename, String startSymbol) throws TokenExpectedException, BadTokenException, ParseException, SGLRException, IncrementalSGLRException, InterruptedException {
        this.lastReconstructedNodes = Collections.emptyList();
        if (this.lastAst == null || this.incrementalSorts.isEmpty()) {
            this.lastAst = (ISimpleTerm)this.parser.parse((String)newInput, (String)filename, (String)startSymbol).output;
            return this.lastAst;
        }
        String oldInput = ImploderAttachment.getLeftToken(this.lastAst).getTokenizer().getInput();
        int damageStart = this.getDamageStart(newInput, oldInput);
        int damageSizeChange = newInput.length() - oldInput.length();
        int damageEnd = this.getDamageEnd(newInput, oldInput, damageStart, damageSizeChange);
        this.sanityCheckDiff(oldInput, newInput, damageStart, damageEnd, damageSizeChange);
        if (damageSizeChange == 0 && damageEnd == damageStart - 1) {
            assert (newInput.equals(oldInput));
            return this.lastAst;
        }
        damageStart = this.comments.getExpandedDamageStart(newInput, damageStart, damageEnd, damageSizeChange);
        damageEnd = this.comments.getExpandedDamageEnd(newInput, damageStart, damageEnd, damageSizeChange);
        DamageRegionAnalyzer neighborAnalyzer = new DamageRegionAnalyzer(this, damageStart, damageEnd, damageSizeChange);
        List<ISimpleTerm> neighborDamageNodes = neighborAnalyzer.getDamageNodes((ISimpleTerm)this.lastAst);
        if (DEBUG) {
            System.out.println("Damaged excluding neighbours: " + neighborDamageNodes);
        }
        this.sanityCheckDamageNodes(neighborDamageNodes);
        NeighborDamageExpander neighbors = new NeighborDamageExpander(neighborAnalyzer, neighborDamageNodes, (ISimpleTerm)this.lastAst);
        List<ISimpleTerm> damageNodes = neighbors.getExpandedDamageNodes();
        damageStart = neighbors.getExpandedDamageStart();
        damageEnd = neighbors.getExpandedDamageEnd();
        if (DEBUG) {
            System.out.println("Damaged including neighbours: " + damageNodes);
        }
        this.sanityCheckDiff(oldInput, newInput, damageStart, damageEnd, damageSizeChange);
        this.sanityCheckOldTree((ISimpleTerm)this.lastAst);
        this.sanityCheckDamageNodes(damageNodes);
        Set<ISimpleTerm> damageNodesSet = IncrementalSGLR.toIdentitySet(damageNodes);
        DamageRegionAnalyzer damageAnalyzer = new DamageRegionAnalyzer(this, damageStart, damageEnd, damageSizeChange);
        IncrementalInputBuilder inputBuilder = new IncrementalInputBuilder(damageAnalyzer, damageNodesSet, newInput, oldInput);
        String partialInput = inputBuilder.buildPartialInput((ISimpleTerm)this.lastAst);
        int skippedChars = inputBuilder.getLastSkippedCharsBeforeDamage();
        ISimpleTerm partialTree = (ISimpleTerm)((Object)this.parser.parse(partialInput, filename, startSymbol));
        List<ISimpleTerm> repairedNodes = damageAnalyzer.getDamageNodesForPartialTree(partialTree, skippedChars);
        this.sanityCheckRepairedTree(repairedNodes);
        IncrementalTreeBuilder treeBuilder = new IncrementalTreeBuilder(this, damageAnalyzer, newInput, filename, damageNodesSet, repairedNodes, skippedChars);
        Object result = treeBuilder.buildOutput((ISimpleTerm)this.lastAst);
        this.lastReconstructedNodes = treeBuilder.getLastReconstructedNodes();
        this.lastAst = result;
        return result;
    }

    public List<TNode> getLastReconstructedNodes() {
        return this.lastReconstructedNodes;
    }

    public final TNode getLastAst() {
        return this.lastAst;
    }

    public void setLastAst(TNode ast) {
        this.lastReconstructedNodes = Collections.emptyList();
        this.lastAst = ast;
    }

    public final SGLR getParser() {
        return this.parser;
    }

    public final IncrementalSortSet getIncrementalSorts() {
        return this.incrementalSorts;
    }

    public void setIncrementalSorts(IncrementalSortSet incrementalSorts) {
        this.incrementalSorts = incrementalSorts;
    }

    private static <T> Set<T> toIdentitySet(List<T> list) {
        IdentityHashMap resultMap = new IdentityHashMap(list.size());
        for (T item : list) {
            resultMap.put(item, null);
        }
        return resultMap.keySet();
    }

    private void sanityCheckDiff(String oldInput, String newInput, int damageStart, int damageEnd, int damageSizeChange) throws IncrementalSGLRException {
        if (damageStart > damageEnd + 1 || damageStart > damageEnd + damageSizeChange + 1) {
            throw new IncrementalSGLRException("Precondition failed: unable to determine valid diff");
        }
        assert ((String.valueOf(oldInput.substring(0, damageStart)) + newInput.substring(damageStart, damageEnd + damageSizeChange + 1) + oldInput.substring(damageEnd + 1)).equals(newInput));
    }

    private void sanityCheckOldTree(ISimpleTerm oldTree) throws IncrementalSGLRException {
        if (IncrementalSGLR.isAmbiguous(oldTree)) {
            throw new IncrementalSGLRException("Postcondition failed: old tree is ambiguous");
        }
    }

    private void sanityCheckDamageNodes(List<ISimpleTerm> damageNodes) throws IncrementalSGLRException {
        for (ISimpleTerm node : damageNodes) {
            if (this.incrementalSorts.isIncrementalNode(node)) continue;
            throw new IncrementalSGLRException("Precondition failed: unsafe change to tree node of type " + ImploderAttachment.getSort(node) + " at line " + ImploderAttachment.getLeftToken(node).getLine());
        }
        if (!IncrementalSGLR.isSameParent(damageNodes)) {
            throw new IncrementalSGLRException("Precondition failed: unable to reconcile changes at multiple levels in the tree");
        }
    }

    private void sanityCheckRepairedTree(List<ISimpleTerm> repairedTreeNodes) throws IncrementalSGLRException {
        if (DEBUG) {
            System.out.println("\nRepaired: " + repairedTreeNodes);
        }
        for (ISimpleTerm node : repairedTreeNodes) {
            if (!this.incrementalSorts.isIncrementalNode(node)) {
                throw new IncrementalSGLRException("Postcondition failed: unsafe tree parsed of type " + ImploderAttachment.getSort(node) + " at line " + ImploderAttachment.getLeftToken(node).getLine());
            }
            if (!IncrementalSGLR.isAmbiguous(node)) continue;
            throw new IncrementalSGLRException("Postcondition failed: updated tree is ambiguous");
        }
        if (!IncrementalSGLR.isSameParent(repairedTreeNodes)) {
            throw new IncrementalSGLRException("Postcondition failed: unable to reconcile changes at multiple levels in the tree");
        }
    }

    private static boolean isSameParent(List<ISimpleTerm> nodes) {
        if (nodes.size() == 0) {
            return true;
        }
        IStrategoTerm parent = ParentAttachment.getParent(nodes.get(0));
        if (parent == null) {
            throw new IllegalStateException("Could not determine parent of tree node");
        }
        int i = 1;
        int max2 = nodes.size();
        while (i < max2) {
            if (ParentAttachment.getParent(nodes.get(i)) != parent) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isAmbiguous(ISimpleTerm tree) {
        return ((AbstractTokenizer)ImploderAttachment.getLeftToken(tree).getTokenizer()).isAmbiguous();
    }

    protected static boolean isRangeOverlap(int start1, int end1, int start2, int end2) {
        return start1 <= end2 && start2 <= end1;
    }

    private int getDamageStart(String input, String oldInput) {
        int limit = Math.min(input.length(), oldInput.length());
        int i = 0;
        while (i < limit) {
            if (input.charAt(i) != oldInput.charAt(i)) {
                return i;
            }
            ++i;
        }
        return limit - 1;
    }

    private int getDamageEnd(String input, String oldInput, int damageStart, int damageSizeChange) {
        int limit = Math.max(damageStart, damageStart - damageSizeChange) - 1;
        int i = oldInput.length() - 1;
        while (i > limit) {
            if (oldInput.charAt(i) != input.charAt(i + damageSizeChange)) {
                return i;
            }
            --i;
        }
        return limit;
    }
}

