/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import org.spoofax.jsglr.client.BottomupTreeBuilder;
import org.spoofax.jsglr.client.imploder.TopdownTreeBuilder;

public abstract class AbstractParseNode {
    public static final int PARSE_PRODUCTION_NODE = 1;
    public static final int PARSENODE = 2;
    public static final int AMBIGUITY = 3;
    public static final int PREFER = 4;
    public static final int AVOID = 5;
    public static final int REJECT = 6;
    public static final int CYCLE = 7;
    private final int line;
    private final int column;
    private boolean proposal = false;
    private boolean nestedProposal = false;
    private boolean singlePlaceholderInsertion = false;
    private boolean containsProposal = false;
    private Map<String, Object> properties;
    protected static final int NO_HASH_CODE = 0;
    public static final int NEWLINE_LAYOUT = 2;
    public static final int NONEWLINE_LAYOUT = 1;
    public static final int OTHER_LAYOUT = 0;

    public AbstractParseNode(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public final boolean isAmbNode() {
        return this.getNodeType() == 3;
    }

    public final boolean isParseNode() {
        switch (this.getNodeType()) {
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public final boolean isParseRejectNode() {
        return this.getNodeType() == 6;
    }

    public final boolean isParseProductionNode() {
        return this.getNodeType() == 1;
    }

    public final boolean isCycle() {
        return this.getNodeType() == 7;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLine() {
        return this.line;
    }

    public abstract void reject();

    public abstract int getLabel();

    public abstract int getNodeType();

    public abstract AbstractParseNode[] getChildren();

    public abstract Object toTreeBottomup(BottomupTreeBuilder var1);

    public abstract Object toTreeTopdown(TopdownTreeBuilder var1);

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractParseNode)) {
            return false;
        }
        return ((AbstractParseNode)obj).line == this.line && ((AbstractParseNode)obj).column == this.column;
    }

    public int hashCode() {
        return this.line * 9197 + this.column;
    }

    public abstract String toStringShallow();

    public abstract String toString();

    public abstract boolean isParseProductionChain();

    public abstract boolean isEmpty();

    public abstract AbstractParseNode getLeft();

    public abstract boolean isLayout();

    public abstract boolean isIgnoreLayout();

    public int getAmbiguityCount() {
        Stack<AbstractParseNode> nodes = new Stack<AbstractParseNode>();
        nodes.push(this);
        int amb = 0;
        while (!nodes.isEmpty()) {
            AbstractParseNode next = (AbstractParseNode)nodes.pop();
            if (next.isAmbNode()) {
                ++amb;
            }
            nodes.addAll(Arrays.asList(next.getChildren()));
        }
        return amb;
    }

    public int getLayoutStatus() {
        if (this.isLayout() && this.hasNewline()) {
            return 2;
        }
        if (this.isLayout()) {
            return 1;
        }
        LinkedList<AbstractParseNode> nodes = new LinkedList<AbstractParseNode>();
        nodes.addFirst(this);
        while (!nodes.isEmpty()) {
            AbstractParseNode node = (AbstractParseNode)nodes.pollFirst();
            if (node.isLayout()) {
                if (!node.hasNewline()) continue;
                return 2;
            }
            if (node.isParseProductionNode()) {
                return 0;
            }
            int i = 0;
            while (i < node.getChildren().length) {
                nodes.addFirst(node.getChildren()[i]);
                ++i;
            }
        }
        return 1;
    }

    private boolean hasNewline() {
        LinkedList<AbstractParseNode> nodes = new LinkedList<AbstractParseNode>();
        nodes.add(this);
        while (!nodes.isEmpty()) {
            AbstractParseNode node = (AbstractParseNode)nodes.poll();
            if (node.isParseProductionNode() && node.getLabel() == 10 || node.getLabel() == 13) {
                return true;
            }
            AbstractParseNode[] abstractParseNodeArray = node.getChildren();
            int n = abstractParseNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractParseNode kid = abstractParseNodeArray[n2];
                nodes.add(kid);
                ++n2;
            }
        }
        return false;
    }

    public AbstractParseNode getLast() {
        AbstractParseNode n = this;
        while (n.getChildren().length > 0) {
            AbstractParseNode newN = null;
            int i = n.getChildren().length - 1;
            while (i >= 0) {
                AbstractParseNode kid = n.getChildren()[i];
                if (!kid.isEmpty() && !kid.isLayout()) {
                    newN = kid;
                    break;
                }
                --i;
            }
            if (newN == null) break;
            n = newN;
        }
        return n;
    }

    public AbstractParseNode getRight() {
        AbstractParseNode last = this.getLast();
        AbstractParseNode right = null;
        int i = this.getChildren().length - 1;
        while (i >= 0) {
            AbstractParseNode kid = this.getChildren()[i];
            AbstractParseNode kidLast = kid.getLast();
            if (!(kid.isLayout() || kid.isEmpty() || kid.isIgnoreLayout())) {
                AbstractParseNode kidRight;
                if (kidLast.getLine() < last.getLine() && (right == null || kidLast.getColumn() > right.getColumn())) {
                    right = kidLast;
                }
                if ((kidRight = kid.getRight()) != null && kidRight.getLine() < last.getLine() && (right == null || kidRight.getColumn() > right.getColumn())) {
                    right = kidRight;
                }
            }
            --i;
        }
        return right;
    }

    public void setProperty(String key, Object val) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(key, val);
    }

    public Object getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public abstract boolean isPlaceholderInsertionNode();

    public abstract boolean isLiteralCompletionNode();

    public boolean isProposal() {
        return this.proposal;
    }

    public void setProposal(boolean proposal) {
        this.proposal = proposal;
    }

    public boolean containsProposal() {
        return this.containsProposal;
    }

    public void setContaintsProposal(boolean containsProposal) {
        this.containsProposal = containsProposal;
    }

    public boolean isNestedProposal() {
        return this.nestedProposal;
    }

    public void setNestedProposal(boolean nestedProposal) {
        this.nestedProposal = nestedProposal;
    }

    public boolean isSinglePlaceholderInsertion() {
        return this.singlePlaceholderInsertion;
    }

    public void setSinglePlaceholderInsertion(boolean singlePlaceholderInsertion) {
        this.singlePlaceholderInsertion = singlePlaceholderInsertion;
    }
}

