/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.jsglr.treediff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.library.jsglr.treediff.AbstractTreeMatcher;
import org.spoofax.interpreter.library.jsglr.treediff.HelperFunctions;
import org.spoofax.interpreter.library.jsglr.treediff.LCS;
import org.spoofax.interpreter.library.jsglr.treediff.LCSCommand;
import org.spoofax.interpreter.library.jsglr.treediff.TermMatchAttachment;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.jsglr.client.imploder.TermTreeFactory;
import org.spoofax.terms.StrategoAppl;
import org.spoofax.terms.TermFactory;
import org.spoofax.terms.attachments.ParentAttachment;

public class TreeEditDistance {
    private TermTreeFactory termFactory = new TermTreeFactory(new TermFactory());
    private ArrayList<IStrategoTerm> deletions = new ArrayList();
    private ArrayList<IStrategoTerm> insertions = new ArrayList();
    private ArrayList<IStrategoTerm> labelChanges = new ArrayList();
    private ArrayList<IStrategoTerm> valueChanges = new ArrayList();
    private ArrayList<IStrategoTerm> movings = new ArrayList();

    public int getDeletionCount() {
        return this.deletions.size();
    }

    public int getInsertionCount() {
        return this.insertions.size();
    }

    public int getRelabeledCount() {
        return this.labelChanges.size();
    }

    public int getValueChangeCount() {
        return this.valueChanges.size();
    }

    public int getMovedCount() {
        return this.movings.size();
    }

    private void clear() {
        this.deletions.clear();
        this.insertions.clear();
        this.labelChanges.clear();
        this.valueChanges.clear();
        this.movings.clear();
    }

    public void detectTreeEditActions(IStrategoTerm root1, IStrategoTerm root2, AbstractTreeMatcher treeMatcher) {
        this.clear();
        treeMatcher.constructMatching(root1, root2);
        this.insertions = this.collectUnmatchedTerms(root2);
        this.deletions = this.collectUnmatchedTerms(root1);
        this.labelChanges = this.collectRelabeledTerms(root1);
        this.valueChanges = this.collectValueChanges(root1);
        this.movings = this.collectMovedTerms(root1);
        this.printResult(this.insertions, "insertions");
        this.printResult(this.deletions, "deletions");
        this.printResult(this.labelChanges, "labelChanges");
        this.printResult(this.valueChanges, "valueChanges");
        this.printResult(this.movings, "movings");
        System.out.println("--------------------------------");
        assert (this.labelChanges.size() == this.collectRelabeledTerms(root1).size());
        assert (this.valueChanges.size() == this.collectValueChanges(root2).size());
        assert (this.movings.size() == this.collectMovedTerms(root2).size()) : String.valueOf(this.movings.size()) + " moved terms in root1 NOT EQUAL TO " + this.collectMovedTerms(root2).size() + " in root2";
        for (IStrategoTerm trm : this.insertions) {
            assert (ParentAttachment.getRoot(trm).equals(root2));
        }
        for (IStrategoTerm trm : this.deletions) {
            assert (ParentAttachment.getRoot(trm) == root1);
        }
        for (IStrategoTerm trm : this.labelChanges) {
            assert (ParentAttachment.getRoot(trm) == root1);
        }
        for (IStrategoTerm trm : this.valueChanges) {
            assert (ParentAttachment.getRoot(trm) == root1);
        }
        for (IStrategoTerm trm : this.movings) {
            assert (ParentAttachment.getRoot(trm) == root1);
        }
    }

    private void printResult(ArrayList<IStrategoTerm> editActions, String actionString) {
        int i = 0;
        while (i < editActions.size()) {
            IStrategoTerm m = editActions.get(i);
            assert (m != null) : actionString;
            String txt = ImploderAttachment.getTokenizer(m).toString(ImploderAttachment.getLeftToken(m), ImploderAttachment.getRightToken(m));
            System.out.println(String.valueOf(actionString) + ": " + txt + " => " + m);
            ++i;
        }
    }

    private ArrayList<IStrategoTerm> collectMovedTerms(IStrategoTerm trm) {
        int i;
        ArrayList<IStrategoTerm> movedTerms = new ArrayList<IStrategoTerm>();
        IStrategoTerm partnerOfTrm = TermMatchAttachment.getMatchedTerm(trm);
        if (partnerOfTrm != null) {
            movedTerms.addAll(this.movedSubterms(trm, partnerOfTrm));
        } else {
            i = 0;
            while (i < trm.getSubtermCount()) {
                if (TermMatchAttachment.hasMatchedTerm(trm.getSubterm(i))) {
                    movedTerms.add(trm.getSubterm(i));
                }
                ++i;
            }
        }
        i = 0;
        while (i < trm.getSubtermCount()) {
            movedTerms.addAll(this.collectMovedTerms(trm.getSubterm(i)));
            ++i;
        }
        return movedTerms;
    }

    private ArrayList<IStrategoTerm> movedSubterms(IStrategoTerm trm, IStrategoTerm partnerOfTrm) {
        List<IStrategoTerm> subterms = Arrays.asList(trm.getAllSubterms());
        List<IStrategoTerm> subtermsOfPartner = Arrays.asList(partnerOfTrm.getAllSubterms());
        if (Tools.isTermAppl(trm) && Tools.isTermAppl(partnerOfTrm) && HelperFunctions.haveSameSignature(trm, partnerOfTrm)) {
            return this.movedApplElements(subterms, subtermsOfPartner);
        }
        return this.movedListElements(subterms, subtermsOfPartner);
    }

    private ArrayList<IStrategoTerm> movedApplElements(List<IStrategoTerm> subterms, List<IStrategoTerm> subtermsOfPartner) {
        assert (subterms.size() == subtermsOfPartner.size());
        ArrayList<IStrategoTerm> moved = new ArrayList<IStrategoTerm>();
        int i = 0;
        while (i < subterms.size()) {
            IStrategoTerm partner_i = TermMatchAttachment.getMatchedTerm(subterms.get(i));
            if (partner_i != null && partner_i != subtermsOfPartner.get(i)) {
                moved.add(subterms.get(i));
            }
            ++i;
        }
        return moved;
    }

    private ArrayList<IStrategoTerm> movedListElements(List<IStrategoTerm> subterms, List<IStrategoTerm> subtermsOfPartner) {
        ArrayList<IStrategoTerm> moved = new ArrayList<IStrategoTerm>();
        LCS<IStrategoTerm> lcs = new LCS<IStrategoTerm>(new LCSCommand<IStrategoTerm>(){

            @Override
            public boolean isMatch(IStrategoTerm t1, IStrategoTerm t2) {
                return TermMatchAttachment.getMatchedTerm(t2) == t1;
            }
        });
        lcs.createLCSResults(subterms, subtermsOfPartner);
        ArrayList<IStrategoTerm> unmatched1 = lcs.getResultUnmatched1();
        for (IStrategoTerm u1 : unmatched1) {
            if (!TermMatchAttachment.hasMatchedTerm(u1)) continue;
            moved.add(u1);
        }
        return moved;
    }

    private ArrayList<IStrategoTerm> collectValueChanges(IStrategoTerm trm) {
        ArrayList<IStrategoTerm> leafnodes = HelperFunctions.collectLeafnodes(trm);
        ArrayList<IStrategoTerm> valueChanges = new ArrayList<IStrategoTerm>();
        for (IStrategoTerm ln : leafnodes) {
            IStrategoTerm lnPartner;
            if (!HelperFunctions.isPrimitiveWithDifferentValues(ln, lnPartner = TermMatchAttachment.getMatchedTerm(ln))) continue;
            valueChanges.add(ln);
        }
        return valueChanges;
    }

    private ArrayList<IStrategoTerm> collectRelabeledTerms(IStrategoTerm trm) {
        IStrategoTerm partnerOfTrm;
        ArrayList<IStrategoTerm> relabeledTerms = new ArrayList<IStrategoTerm>();
        if ((Tools.isTermAppl(trm) || Tools.isTermList(trm) || Tools.isTermTuple(trm)) && (partnerOfTrm = TermMatchAttachment.getMatchedTerm(trm)) != null && !HelperFunctions.haveSameSignature(trm, partnerOfTrm) && Tools.isTermAppl(trm) && Tools.isTermAppl(partnerOfTrm)) {
            ArrayList<IStrategoTerm> tupleElems = new ArrayList<IStrategoTerm>();
            tupleElems.add(trm);
            tupleElems.add(((StrategoAppl)partnerOfTrm).getConstructor());
            Object relabeling = this.termFactory.createTuple((String)null, (IToken)null, (IToken)null, tupleElems);
            relabeledTerms.add(trm);
            System.err.println(trm);
            System.err.println(partnerOfTrm);
        }
        int i = 0;
        while (i < trm.getSubtermCount()) {
            relabeledTerms.addAll(this.collectRelabeledTerms(trm.getSubterm(i)));
            ++i;
        }
        return relabeledTerms;
    }

    private ArrayList<IStrategoTerm> collectUnmatchedTerms(IStrategoTerm trm) {
        ArrayList<IStrategoTerm> unmatchedTerms = new ArrayList<IStrategoTerm>();
        if (TermMatchAttachment.getMatchedTerm(trm) == null) {
            unmatchedTerms.add(trm);
        }
        int i = 0;
        while (i < trm.getSubtermCount()) {
            unmatchedTerms.addAll(this.collectUnmatchedTerms(trm.getSubterm(i)));
            ++i;
        }
        return unmatchedTerms;
    }
}

