/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.syntax;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.core.config.JSGLR2Logging;
import org.metaborg.core.config.JSGLRVersion;
import org.metaborg.core.config.Sdf2tableVersion;
import org.metaborg.core.language.ILanguageCache;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.syntax.IInputUnit;
import org.metaborg.core.syntax.ParseException;
import org.metaborg.spoofax.core.stratego.IStrategoRuntimeService;
import org.metaborg.spoofax.core.syntax.IParseTableProvider;
import org.metaborg.spoofax.core.syntax.IParserConfig;
import org.metaborg.spoofax.core.syntax.ISpoofaxParser;
import org.metaborg.spoofax.core.syntax.ImploderImplementation;
import org.metaborg.spoofax.core.syntax.JSGLR1FileParseTableProvider;
import org.metaborg.spoofax.core.syntax.JSGLR1I;
import org.metaborg.spoofax.core.syntax.JSGLR1IncrementalParseTableProvider;
import org.metaborg.spoofax.core.syntax.JSGLR2FileParseTableProvider;
import org.metaborg.spoofax.core.syntax.JSGLR2I;
import org.metaborg.spoofax.core.syntax.JSGLRI;
import org.metaborg.spoofax.core.syntax.JSGLRParserConfiguration;
import org.metaborg.spoofax.core.syntax.LanguageImplementationWithParserOverride;
import org.metaborg.spoofax.core.syntax.ParserConfig;
import org.metaborg.spoofax.core.syntax.SyntaxFacet;
import org.metaborg.spoofax.core.unit.ISpoofaxInputUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxParseUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxUnitService;
import org.metaborg.spoofax.core.unit.ParseContrib;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.resource.ResourceUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.jsglr.client.ParseTable;
import org.strategoxt.lang.Context;

public class JSGLRParseService
implements ISpoofaxParser,
ILanguageCache,
AutoCloseable {
    public static final String name = "jsglr";
    private static final ILogger logger = LoggerUtils.logger(JSGLRParseService.class);
    private final ISpoofaxUnitService unitService;
    private final ITermFactory termFactory;
    private final IStrategoRuntimeService strategoRuntimeService;
    private final JSGLRParserConfiguration defaultParserConfig;
    private final Map<ILanguageImpl, IParserConfig> parserConfigs = Maps.newHashMap();
    private final Map<ILanguageImpl, IParserConfig> completionParserConfigs = Maps.newHashMap();
    private final Map<ILanguageImpl, org.metaborg.sdf2table.parsetable.ParseTable> referenceParseTables = Maps.newHashMap();
    private final Map<ILanguageImpl, org.metaborg.sdf2table.parsetable.ParseTable> referenceCompletionParseTables = Maps.newHashMap();
    private final Map<ILanguageImpl, JSGLRI<?>> parsers = Maps.newHashMap();
    private final Map<ILanguageImpl, JSGLRI<?>> completionParsers = Maps.newHashMap();

    @Inject
    public JSGLRParseService(ISpoofaxUnitService unitService, ITermFactory termFactory, IStrategoRuntimeService strategoRuntimeService, JSGLRParserConfiguration defaultParserConfig) {
        this.unitService = unitService;
        this.termFactory = termFactory;
        this.strategoRuntimeService = strategoRuntimeService;
        this.defaultParserConfig = defaultParserConfig;
    }

    @Override
    public ISpoofaxParseUnit parse(ISpoofaxInputUnit input, IProgress progress, ICancel cancel) throws ParseException {
        return this.parse(input, progress, cancel, null, null);
    }

    @Override
    public ISpoofaxParseUnit parse(ISpoofaxInputUnit input, IProgress progress, ICancel cancel, @Nullable JSGLRVersion overrideJSGLRVersion, @Nullable ImploderImplementation overrideImploder) throws ParseException {
        FileObject source = input.source();
        String text = input.text();
        JSGLRParserConfiguration parserConfig = input.config() == null ? this.defaultParserConfig : input.config();
        try {
            logger.trace("Parsing {}", source);
            JSGLRI<?> parser = this.getParser(input, parserConfig, overrideJSGLRVersion, overrideImploder);
            ParseContrib contrib = parser.parse(parserConfig, source, text);
            return this.unitService.parseUnit(input, contrib);
        }
        catch (IOException e) {
            throw new ParseException((IInputUnit)input, (Throwable)e);
        }
    }

    @Override
    public Collection<ISpoofaxParseUnit> parseAll(Iterable<ISpoofaxInputUnit> inputs, IProgress progress, ICancel cancel) throws ParseException {
        ArrayList parseUnits = Lists.newArrayList();
        for (ISpoofaxInputUnit input : inputs) {
            parseUnits.add(this.parse(input, progress, cancel));
        }
        return parseUnits;
    }

    @Override
    public void invalidateCache(ILanguageImpl impl) {
        if (this.hasIncrementalPTGen(impl)) {
            logger.debug("Storing reference parse table for {}", impl);
            this.updateReferenceParseTables(impl, false, this.parserConfigs, this.referenceParseTables);
            this.updateReferenceParseTables(impl, true, this.completionParserConfigs, this.referenceCompletionParseTables);
        }
        logger.debug("Removing cached parse table for {}", impl);
        this.parserConfigs.remove(impl);
        this.completionParserConfigs.remove(impl);
        this.parsers.remove(impl);
        this.completionParsers.remove(impl);
        LanguageImplementationWithParserOverride implWithOverrideMatcher = LanguageImplementationWithParserOverride.matcher(impl);
        while (this.parserConfigs.remove(implWithOverrideMatcher) != null) {
        }
        while (this.completionParserConfigs.remove(implWithOverrideMatcher) != null) {
        }
        while (this.parsers.remove(implWithOverrideMatcher) != null) {
        }
        while (this.completionParsers.remove(implWithOverrideMatcher) != null) {
        }
    }

    @Override
    public void invalidateCache(ILanguageComponent component) {
    }

    @Override
    public void close() {
        this.parserConfigs.clear();
        this.completionParserConfigs.clear();
        this.referenceParseTables.clear();
        this.referenceCompletionParseTables.clear();
        this.parsers.clear();
        this.completionParsers.clear();
    }

    private JSGLRI<?> getParser(ISpoofaxInputUnit input, JSGLRParserConfiguration parserConfig, @Nullable JSGLRVersion overrideJSGLRVersion, @Nullable ImploderImplementation overrideImploder) throws IOException, ParseException {
        Map<ILanguageImpl, JSGLRI<?>> parserMap;
        ILanguageImpl base;
        ILanguageImpl langImpl;
        if (input.dialect() != null) {
            langImpl = input.dialect();
            base = input.langImpl();
        } else {
            langImpl = input.langImpl();
            base = null;
        }
        if (overrideImploder != null || overrideJSGLRVersion != null) {
            langImpl = new LanguageImplementationWithParserOverride(langImpl, overrideImploder, overrideJSGLRVersion);
        }
        Map<ILanguageImpl, JSGLRI<?>> map = parserMap = parserConfig.completion ? this.completionParsers : this.parsers;
        if (!parserMap.containsKey(langImpl)) {
            JSGLRI parser;
            IParserConfig config = this.getParserConfig(langImpl, input, parserConfig.completion, overrideJSGLRVersion, overrideImploder);
            JSGLRVersion version = this.jsglrVersion(input, overrideJSGLRVersion);
            if (version == JSGLRVersion.v1) {
                Context context = this.strategoRuntimeService.genericRuntime().getCompiledContext();
                parser = base != null ? new JSGLR1I(config, this.termFactory, context, base, langImpl) : new JSGLR1I(config, this.termFactory, context, langImpl, null);
            } else {
                JSGLR2Logging jsglr2Logging = this.jsglr2Logging(input);
                parser = new JSGLR2I(config, this.termFactory, langImpl, null, version, jsglr2Logging);
            }
            parserMap.put(langImpl, parser);
        }
        return parserMap.get(langImpl);
    }

    private IParserConfig getParserConfig(ILanguageImpl lang, ISpoofaxInputUnit input, boolean completion, @Nullable JSGLRVersion overrideJSGLRVersion, @Nullable ImploderImplementation overrideImploder) throws ParseException {
        Map<ILanguageImpl, IParserConfig> parserConfigMap = completion ? this.completionParserConfigs : this.parserConfigs;
        IParserConfig parserConfig = parserConfigMap.get(lang);
        if (parserConfig == null) {
            org.metaborg.sdf2table.parsetable.ParseTable referenceParseTable;
            FileObject parseTableFile;
            String errorMultiple;
            String errorNotFound;
            SyntaxFacet facet = lang.facet(SyntaxFacet.class);
            if (facet == null) {
                logger.error("Cannot find SyntaxFacet for this language.");
                throw new ParseException((IInputUnit)input, (Throwable)new NullPointerException("SyntaxFacet lookup failed"));
            }
            if (completion) {
                errorNotFound = "Completion parse table not found or sdf is not enabled for this language.";
                errorMultiple = "Different components are specifying multiple completion parse tables.";
                parseTableFile = facet.completionParseTable;
            } else {
                errorNotFound = "Parse table not found or sdf is not enabled for this language.";
                errorMultiple = "Different components are specifying multiple parse tables.";
                parseTableFile = facet.parseTable;
            }
            FileObject parseTable = null;
            if (parseTableFile == null) {
                try {
                    boolean multipleTables = false;
                    for (ILanguageComponent component : lang.components()) {
                        String parseTableLocation;
                        if (!component.config().sdfEnabled().booleanValue() || (parseTableLocation = completion ? component.config().completionsParseTable() : component.config().parseTable()) == null) continue;
                        if (multipleTables) {
                            logger.error(errorMultiple);
                            throw new ParseException(input);
                        }
                        parseTable = ResourceUtils.resolveFile(component.location(), parseTableLocation);
                        multipleTables = true;
                    }
                }
                catch (FileSystemException e) {
                    logger.error(errorNotFound);
                    throw new ParseException((IInputUnit)input, (Throwable)e);
                }
            } else {
                parseTable = parseTableFile;
            }
            try {
                if (parseTable == null || !parseTable.exists()) {
                    logger.error(errorNotFound);
                    throw new ParseException(input);
                }
            }
            catch (FileSystemException e) {
                logger.error(errorNotFound);
                throw new ParseException((IInputUnit)input, (Throwable)e);
            }
            JSGLRVersion version = this.jsglrVersion(input, overrideJSGLRVersion);
            IParseTableProvider provider = version == JSGLRVersion.v1 ? ((referenceParseTable = this.referenceParseTables.get(lang)) != null && this.hasIncrementalPTGen(lang) ? new JSGLR1IncrementalParseTableProvider(parseTable, this.termFactory, referenceParseTable) : new JSGLR1FileParseTableProvider(parseTable, this.termFactory)) : new JSGLR2FileParseTableProvider(parseTable, this.termFactory);
            parserConfig = overrideImploder != null ? new ParserConfig(facet.startSymbols != null ? (String)Iterables.get(facet.startSymbols, (int)0) : null, provider, overrideImploder) : new ParserConfig(facet.startSymbols != null ? (String)Iterables.get(facet.startSymbols, (int)0) : null, provider, facet.imploder);
            parserConfigMap.put(lang, parserConfig);
        }
        return parserConfig;
    }

    private JSGLRVersion jsglrVersion(ISpoofaxInputUnit input, @Nullable JSGLRVersion overrideJSGLRVersion) {
        if (overrideJSGLRVersion != null) {
            return overrideJSGLRVersion;
        }
        ILanguageComponent langComp = (ILanguageComponent)Iterables.getFirst(input.langImpl().components(), null);
        if (langComp == null) {
            return JSGLRVersion.v1;
        }
        return langComp.config().jsglrVersion();
    }

    private JSGLR2Logging jsglr2Logging(ISpoofaxInputUnit input) {
        ILanguageComponent langComp = (ILanguageComponent)Iterables.getFirst(input.langImpl().components(), null);
        if (langComp == null) {
            return JSGLR2Logging.none;
        }
        return langComp.config().jsglr2Logging();
    }

    private boolean hasIncrementalPTGen(ILanguageImpl impl) {
        for (ILanguageComponent component : impl.components()) {
            if (!component.config().sdfEnabled().booleanValue() || component.config().sdf2tableVersion() != Sdf2tableVersion.incremental) continue;
            return true;
        }
        return false;
    }

    private void updateReferenceParseTables(ILanguageImpl impl, boolean completion, Map<ILanguageImpl, IParserConfig> parserConfigs, Map<ILanguageImpl, org.metaborg.sdf2table.parsetable.ParseTable> referenceParseTables) {
        if (parserConfigs.get(impl) != null) {
            try {
                ParseTable pt = (ParseTable)parserConfigs.get(impl).getParseTableProvider().parseTable();
                if (pt != null && pt.getPTgenerator() != null && pt.getPTgenerator().getParseTable() != null) {
                    referenceParseTables.put(impl, (org.metaborg.sdf2table.parsetable.ParseTable)pt.getPTgenerator().getParseTable());
                }
            }
            catch (IOException e) {
                String c = completion ? "completion " : "";
                logger.error("Could not save reference " + c + "parse table for incremental parse table generation.");
            }
        }
    }
}

