/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.stratego.primitive;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.build.paths.ILanguagePathService;
import org.metaborg.core.context.IContext;
import org.metaborg.core.project.IProject;
import org.metaborg.core.project.IProjectService;
import org.metaborg.spoofax.core.stratego.primitive.generic.ASpoofaxContextPrimitive;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.util.TermUtils;

public class LanguageIncludeDirectoriesPrimitive
extends ASpoofaxContextPrimitive {
    private final ILanguagePathService languagePathService;
    private final IProjectService projectService;

    @Inject
    public LanguageIncludeDirectoriesPrimitive(ILanguagePathService languagePathService, IProjectService projectService) {
        super("language_include_directories", 0, 1);
        this.languagePathService = languagePathService;
        this.projectService = projectService;
    }

    @Override
    protected IStrategoTerm call(IStrategoTerm current, Strategy[] svars, IStrategoTerm[] tvars, ITermFactory factory, IContext context) throws MetaborgException, IOException {
        if (!TermUtils.isString(tvars[0])) {
            return null;
        }
        IProject project = this.projectService.get(context.location());
        if (project == null) {
            return factory.makeList();
        }
        String languageName = TermUtils.toJavaString(tvars[0]);
        Iterable<FileObject> includeLocations = this.languagePathService.includePaths(project, languageName);
        ArrayList terms = Lists.newArrayList();
        for (FileObject includeLocation : includeLocations) {
            terms.add(factory.makeString(includeLocation.getName().getURI()));
        }
        return factory.makeList(terms);
    }
}

