/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.stratego.primitive;

import com.google.inject.Inject;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.build.dependency.IDependencyService;
import org.metaborg.core.context.IContext;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.spoofax.core.stratego.primitive.generic.ASpoofaxContextPrimitive;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.util.TermUtils;

public class IsLanguageActivePrimitive
extends ASpoofaxContextPrimitive {
    private final IDependencyService dependencyService;

    @Inject
    public IsLanguageActivePrimitive(IDependencyService dependencyService) {
        super("is_language_active", 0, 0);
        this.dependencyService = dependencyService;
    }

    @Override
    protected IStrategoTerm call(IStrategoTerm current, Strategy[] svars, IStrategoTerm[] tvars, ITermFactory factory, IContext currentContext) throws MetaborgException {
        String languageName = TermUtils.toJavaString(current);
        for (ILanguageComponent component : this.dependencyService.compileDeps(currentContext.project())) {
            for (ILanguageImpl iLanguageImpl : component.contributesTo()) {
                if (iLanguageImpl == null || !iLanguageImpl.belongsTo().name().equals(languageName)) continue;
                return current;
            }
        }
        return null;
    }
}

