/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.esv;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.util.TermUtils;

public class ESVReader {
    public static IStrategoAppl findTerm(IStrategoTerm term, String constructor) {
        if (TermUtils.isAppl(term) && ESVReader.cons(term).equals(constructor)) {
            return (IStrategoAppl)term;
        }
        IStrategoTerm[] subterms = term.getAllSubterms();
        int i = subterms.length - 1;
        while (i >= 0) {
            IStrategoAppl result = ESVReader.findTerm(subterms[i], constructor);
            if (result != null) {
                return result;
            }
            --i;
        }
        return null;
    }

    public static ArrayList<IStrategoAppl> collectTerms(IStrategoAppl term, String ... constructors) {
        ArrayList<IStrategoAppl> results = new ArrayList<IStrategoAppl>();
        String[] stringArray = constructors;
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            String constructor = stringArray[n2];
            ESVReader.collectTerms((IStrategoTerm)term, constructor, results);
            ++n2;
        }
        return results;
    }

    private static void collectTerms(IStrategoTerm term, String constructor, ArrayList<IStrategoAppl> results) {
        if (TermUtils.isAppl(term) && ESVReader.cons(term).equals(constructor)) {
            results.add((IStrategoAppl)term);
        }
        int i = 0;
        while (i < term.getSubtermCount()) {
            ESVReader.collectTerms(term.getSubterm(i), constructor, results);
            ++i;
        }
    }

    @Nullable
    public static String termContents(IStrategoTerm t) {
        String result;
        if (t == null) {
            return null;
        }
        if (TermUtils.isString(t)) {
            result = TermUtils.toJavaString(t);
        } else {
            if (TermUtils.isAppl(t, "Values", 1)) {
                return ESVReader.concatTermStrings(TermUtils.toListAt(t, 0));
            }
            if (TermUtils.isAppl(t, null, 1) && TermUtils.isStringAt(t, 0)) {
                result = TermUtils.toJavaStringAt(t, 0);
            } else {
                if (TermUtils.isAppl(t, null, 1)) {
                    return ESVReader.termContents(t.getSubterm(0));
                }
                return null;
            }
        }
        if (result.startsWith("\"") && result.endsWith("\"") && result.length() > 1) {
            result = result.substring(1, result.length() - 1).replace("\\\\", "\"");
        }
        return result;
    }

    @Nullable
    public static List<String> termListContents(IStrategoTerm t) {
        if (t == null) {
            return null;
        }
        ArrayList results = Lists.newArrayList();
        if (TermUtils.isAppl(t, "Values", 1)) {
            IStrategoList values = TermUtils.toListAt(t, 0);
            int i = 0;
            while (i < values.getSubtermCount()) {
                results.add(ESVReader.termContents(values.getSubterm(i)));
                ++i;
            }
        } else {
            return null;
        }
        return results;
    }

    public static String getProperty(IStrategoAppl document, String name) {
        return ESVReader.getProperty(document, name, null);
    }

    public static String getProperty(IStrategoAppl document, String name, String defaultValue) {
        IStrategoAppl result = ESVReader.findTerm(document, name);
        if (result == null) {
            return defaultValue;
        }
        return ESVReader.termContents(result);
    }

    public static String concatTermStrings(IStrategoList values) {
        StringBuilder results = new StringBuilder();
        if (values.getSubtermCount() > 0) {
            results.append(ESVReader.termContents(values.getSubterm(0)));
        }
        int i = 1;
        while (i < values.getSubtermCount()) {
            results.append(',');
            results.append(ESVReader.termContents(values.getSubterm(i)));
            ++i;
        }
        return results.toString();
    }

    public static String cons(IStrategoTerm t) {
        if (!TermUtils.isAppl(t)) {
            return null;
        }
        return ((IStrategoAppl)t).getConstructor().getName();
    }
}

