/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class Graph<T> {
    private int labelCount = 0;
    private BiMap<T, Integer> labels = HashBiMap.create();
    private List<Integer>[] adjacencyList;

    public BiMap<T, Integer> getLabels() {
        return this.labels;
    }

    public void setLabels(BiMap<T, Integer> labels) {
        this.labels = labels;
    }

    public Graph(int v) {
        this.adjacencyList = new LinkedList[v];
        int i = 0;
        while (i < v) {
            int j = 0;
            while (j < v) {
                this.adjacencyList[i] = Lists.newLinkedList();
                ++j;
            }
            ++i;
        }
    }

    public Graph(Collection<T> orig_labels) {
        this.adjacencyList = new LinkedList[orig_labels.size()];
        this.addVertices(orig_labels);
        int i = 0;
        while (i < orig_labels.size()) {
            int j = 0;
            while (j < orig_labels.size()) {
                this.adjacencyList[i] = Lists.newLinkedList();
                ++j;
            }
            ++i;
        }
    }

    public void addVertices(Collection<T> orig_labels) {
        for (T orig_label : orig_labels) {
            this.labels.put(orig_label, (Object)this.labelCount++);
        }
    }

    public void addEdge(T orig, T dest) {
        this.adjacencyList[(Integer)this.labels.get(orig)].add((Integer)this.labels.get(dest));
    }

    public String toString() {
        String result = "               ";
        int i = 0;
        while (i < this.labelCount) {
            result = String.valueOf(result) + String.format("%15s", this.labels.inverse().get((Object)i));
            ++i;
        }
        result = String.valueOf(result) + "\n";
        i = 0;
        while (i < this.labelCount) {
            result = String.valueOf(result) + String.format("%15s", this.labels.inverse().get((Object)i));
            int j = 0;
            while (j < this.labelCount) {
                result = this.adjacencyList[i].contains(j) ? String.valueOf(result) + String.format("%15d", 1) : String.valueOf(result) + String.format("%15s", "");
                ++j;
            }
            result = String.valueOf(result) + "\n";
            ++i;
        }
        result = String.valueOf(result) + "\n";
        return result;
    }

    public int totalV() {
        return this.labelCount;
    }

    public Graph<T> getTranspose() {
        Graph<Object> transpose = new Graph<Object>(this.labels.keySet());
        int i = 0;
        while (i < this.labelCount) {
            int j = 0;
            while (j < this.labelCount) {
                if (this.adjacencyList[i].contains(j)) {
                    transpose.addEdge(this.labels.inverse().get((Object)j), this.labels.inverse().get((Object)i));
                }
                ++j;
            }
            ++i;
        }
        return transpose;
    }

    public List<Integer>[] getAdjacencyList() {
        return this.adjacencyList;
    }
}

