/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.grammar;

import java.io.Serializable;
import java.util.BitSet;
import org.metaborg.parsetable.characterclasses.ICharacterClass;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public class CharacterClass
implements ICharacterClass,
Serializable {
    private static final long serialVersionUID = 418963364528944597L;
    private final BitSet chars;
    private final boolean containsEOF;

    public CharacterClass(BitSet chars, boolean eof) {
        this.chars = chars;
        this.containsEOF = eof;
    }

    @Override
    public boolean contains(int character) {
        return character == -1 ? this.containsEOF : this.chars.get(character);
    }

    @Override
    public int min() {
        if (this.containsEOF) {
            return this.chars.isEmpty() ? -1 : Math.min(this.chars.nextSetBit(0), -1);
        }
        return this.chars.nextSetBit(0);
    }

    @Override
    public int max() {
        if (this.containsEOF) {
            return this.chars.isEmpty() ? -1 : Math.max(this.chars.previousSetBit(0x10FFFF), -1);
        }
        return this.chars.previousSetBit(0x10FFFF);
    }

    @Override
    public boolean isEmpty() {
        return this.chars.isEmpty();
    }

    @Override
    public int[] getRanges() {
        throw new IllegalStateException("Cannot get ranges from SDF2Table Character Class");
    }

    @Override
    public ICharacterClass setEOF(boolean eof) {
        return eof == this.containsEOF ? this : new CharacterClass((BitSet)this.chars.clone(), eof);
    }

    @Override
    public ICharacterClass union(ICharacterClass other) {
        if (other instanceof CharacterClass) {
            BitSet result = (BitSet)this.chars.clone();
            result.or(((CharacterClass)other).chars);
            return new CharacterClass(result, this.containsEOF || ((CharacterClass)other).containsEOF);
        }
        throw new IllegalStateException("Cannot perform operation on different character class.");
    }

    @Override
    public ICharacterClass intersection(ICharacterClass other) {
        if (other instanceof CharacterClass) {
            BitSet result = (BitSet)this.chars.clone();
            result.and(((CharacterClass)other).chars);
            return new CharacterClass(result, this.containsEOF && ((CharacterClass)other).containsEOF);
        }
        throw new IllegalStateException("Cannot perform operation on different character class.");
    }

    @Override
    public ICharacterClass difference(ICharacterClass other) {
        if (other instanceof CharacterClass) {
            BitSet result = (BitSet)this.chars.clone();
            BitSet otherComplement = (BitSet)((CharacterClass)other).chars.clone();
            otherComplement.flip(0, 0x110000);
            result.and(otherComplement);
            return new CharacterClass(result, this.containsEOF && !((CharacterClass)other).containsEOF);
        }
        throw new IllegalStateException("Cannot perform operation on different character class.");
    }

    @Override
    public IStrategoTerm toAtermList(ITermFactory tf) {
        IStrategoList.Builder terms = tf.arrayListBuilder();
        int lowerBound = this.chars.nextSetBit(0);
        while (lowerBound != -1 && lowerBound < 0x10FFFF) {
            int upperBound = this.chars.nextClearBit(lowerBound) - 1;
            if (lowerBound == upperBound) {
                terms.add(tf.makeInt(lowerBound));
            } else {
                terms.add(tf.makeAppl(tf.makeConstructor("range", 2), tf.makeInt(lowerBound), tf.makeInt(upperBound)));
            }
            lowerBound = this.chars.nextSetBit(upperBound + 1);
        }
        if (this.containsEOF) {
            terms.add(tf.makeAppl(tf.makeConstructor("eof", 0), new IStrategoTerm[0]));
        }
        return tf.makeList(terms);
    }
}

