/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.deepconflicts;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.metaborg.sdf2table.deepconflicts.Context;
import org.metaborg.sdf2table.deepconflicts.ContextPosition;
import org.metaborg.sdf2table.deepconflicts.ContextType;
import org.metaborg.sdf2table.deepconflicts.ContextualProduction;
import org.metaborg.sdf2table.grammar.ContextFreeSymbol;
import org.metaborg.sdf2table.grammar.GrammarFactory;
import org.metaborg.sdf2table.grammar.IAttribute;
import org.metaborg.sdf2table.grammar.IProduction;
import org.metaborg.sdf2table.grammar.ISymbol;
import org.metaborg.sdf2table.grammar.IterStarSepSymbol;
import org.metaborg.sdf2table.grammar.IterStarSymbol;
import org.metaborg.sdf2table.grammar.LexicalSymbol;
import org.metaborg.sdf2table.grammar.Priority;
import org.metaborg.sdf2table.grammar.Production;
import org.metaborg.sdf2table.grammar.Symbol;
import org.metaborg.sdf2table.grammar.UniqueProduction;
import org.metaborg.sdf2table.parsetable.ParseTable;

public class DeepConflictsAnalyzer {
    private final ParseTable pt;
    private final boolean isContextMappingStable;
    private final Map<Integer, Integer> leftmostContextsMapping;
    private final Map<Integer, Integer> rightmostContextsMapping;
    private final Map<UniqueProduction, Production> uniqueProductionMapping;
    private final BiMap<Production, ContextualProduction> prodContextualProdMapping;
    private final BiMap<IProduction, Integer> productionLabels;
    private final SetMultimap<ISymbol, IProduction> symbolProductionsMapping;
    private final SetMultimap<IProduction, IAttribute> productionAttributesMapping;
    private final SetMultimap<Priority, Integer> priorities;

    public static DeepConflictsAnalyzer fromParseTable(ParseTable pt) {
        DeepConflictsAnalyzer phase1 = new DeepConflictsAnalyzer(pt);
        phase1.deepConflictAnalysis();
        HashSet newLabels = new HashSet(phase1.productionLabels.inverse().keySet());
        HashSet oldLabels = new HashSet(pt.productionLabels().inverse().keySet());
        HashSet diffLabels = new HashSet(newLabels);
        diffLabels.removeAll(oldLabels);
        diffLabels.forEach(pt.getProdLabelFactory()::releaseLabel);
        DeepConflictsAnalyzer phase2 = new DeepConflictsAnalyzer(pt, phase1.leftmostContextsMapping, phase1.rightmostContextsMapping);
        phase2.deepConflictAnalysis();
        return phase2;
    }

    private DeepConflictsAnalyzer(ParseTable pt) {
        this.pt = pt;
        this.isContextMappingStable = false;
        this.leftmostContextsMapping = Maps.newLinkedHashMap();
        this.rightmostContextsMapping = Maps.newLinkedHashMap();
        this.uniqueProductionMapping = Maps.newLinkedHashMap(pt.normalizedGrammar().getUniqueProductionMapping());
        this.prodContextualProdMapping = HashBiMap.create(pt.normalizedGrammar().getProdContextualProdMapping());
        this.productionLabels = HashBiMap.create(pt.productionLabels());
        this.symbolProductionsMapping = HashMultimap.create(pt.normalizedGrammar().getSymbolProductionsMapping());
        this.productionAttributesMapping = HashMultimap.create(pt.normalizedGrammar().getProductionAttributesMapping());
        this.priorities = HashMultimap.create(pt.normalizedGrammar().priorities());
    }

    private DeepConflictsAnalyzer(ParseTable pt, Map<Integer, Integer> leftmostContextsMapping, Map<Integer, Integer> rightmostContextsMapping) {
        this.pt = pt;
        this.isContextMappingStable = true;
        this.leftmostContextsMapping = ImmutableMap.copyOf(leftmostContextsMapping);
        this.rightmostContextsMapping = ImmutableMap.copyOf(rightmostContextsMapping);
        this.uniqueProductionMapping = Maps.newHashMap(pt.normalizedGrammar().getUniqueProductionMapping());
        this.prodContextualProdMapping = HashBiMap.create(pt.normalizedGrammar().getProdContextualProdMapping());
        this.productionLabels = HashBiMap.create(pt.productionLabels());
        this.symbolProductionsMapping = HashMultimap.create(pt.normalizedGrammar().getSymbolProductionsMapping());
        this.productionAttributesMapping = HashMultimap.create(pt.normalizedGrammar().getProductionAttributesMapping());
        this.priorities = HashMultimap.create(pt.normalizedGrammar().priorities());
    }

    public void patchParseTable() {
        this.pt.normalizedGrammar().getUniqueProductionMapping().putAll(this.uniqueProductionMapping);
        this.pt.normalizedGrammar().getSymbolProductionsMapping().putAll(this.symbolProductionsMapping);
        this.pt.productionLabels().putAll(this.productionLabels);
        this.pt.normalizedGrammar().getProductionAttributesMapping().putAll(this.productionAttributesMapping);
        this.pt.normalizedGrammar().getProdContextualProdMapping().putAll(this.prodContextualProdMapping);
        this.pt.normalizedGrammar().priorities().putAll(this.priorities);
        this.pt.getLeftmostContextsMapping().putAll(this.leftmostContextsMapping);
        this.pt.getRightmostContextsMapping().putAll(this.rightmostContextsMapping);
    }

    public void deepConflictAnalysis() {
        this.deepConflictAnalysis(this.pt, true, true, true);
    }

    public void deepConflictAnalysis(ParseTable pt, boolean operatorStyle, boolean danglingPrefixOrSuffix, boolean longestMatch) {
        this.fixNullableRecursive();
        for (Priority prio : pt.normalizedGrammar().priorities().keySet()) {
            Production higher = prio.higher();
            Production lower = prio.lower();
            if (operatorStyle) {
                if (higher.leftRecursivePosition() != -1 && lower.leftRecursivePosition() == -1 && lower.rightRecursivePosition() != -1 && this.mutuallyRecursive(pt, prio) && pt.normalizedGrammar().priorities().containsEntry((Object)prio, (Object)0)) {
                    this.handleInfixPrefixConflict(pt, prio, higher, lower);
                } else if (higher.rightRecursivePosition() != -1 && lower.leftRecursivePosition() != -1 && lower.rightRecursivePosition() == -1 && this.mutuallyRecursive(pt, prio) && pt.normalizedGrammar().priorities().containsEntry((Object)prio, (Object)(higher.getRhs().size() - 1))) {
                    this.handleInfixPostFixConflict(pt, prio, higher, lower);
                }
                this.handleIndirectRecursionConflict(pt, prio, higher);
            }
            if (!danglingPrefixOrSuffix) continue;
            if (!higher.equals(lower) && pt.getDanglingSuffix().contains(higher) && pt.getDanglingSuffix().contains(lower)) {
                this.handleDanglingSuffixConflict(pt, prio, higher, lower);
            }
            if (higher.equals(lower) || !pt.getDanglingPrefix().contains(higher) || !pt.getDanglingPrefix().contains(lower)) continue;
            this.handleDanglingPrefixConflict(pt, prio, higher, lower);
        }
        if (longestMatch) {
            for (Symbol s : pt.normalizedGrammar().getLongestMatchProdsFront().keySet()) {
                this.handleLongestMatchConflictFront(pt, s);
            }
            for (Symbol s : pt.normalizedGrammar().getLongestMatchProdsBack().keySet()) {
                this.handleLongestMatchConflictBack(pt, s);
            }
        }
    }

    private void fixNullableRecursive() {
    }

    private boolean mutuallyRecursive(ParseTable pt, Priority p) {
        return pt.normalizedGrammar().getLeftRecursiveSymbolsMapping().get((Object)p.higher().leftHand()).contains(p.lower().leftHand()) || pt.normalizedGrammar().getRightRecursiveSymbolsMapping().get((Object)p.higher().leftHand()).contains(p.lower().leftHand());
    }

    private Context deepContextFrom(int productionId, ContextPosition position) {
        if (this.isContextMappingStable) {
            return this.pt.getContextualFactory().createContext(productionId, ContextType.DEEP, position, this.leftmostContextsMapping, this.rightmostContextsMapping);
        }
        return this.pt.getContextualFactory().createContext(productionId, ContextType.DEEP, position, Collections.emptyMap(), Collections.emptyMap());
    }

    private Context danglingContextFrom(int productionId, ContextPosition position) {
        if (this.isContextMappingStable) {
            return this.pt.getContextualFactory().createContext(productionId, ContextType.DANGLING, position, this.leftmostContextsMapping, this.rightmostContextsMapping);
        }
        return this.pt.getContextualFactory().createContext(productionId, ContextType.DANGLING, position, Collections.emptyMap(), Collections.emptyMap());
    }

    private void handleInfixPrefixConflict(ParseTable pt, Priority prio, Production higher, Production lower) {
        Priority inverse = pt.normalizedGrammar().getGrammarFactory().createPriority(lower, higher, false);
        if (pt.normalizedGrammar().priorities().get((Object)inverse).contains(lower.rightRecursivePosition())) {
            return;
        }
        int conflict_pos = higher.leftRecursivePosition();
        HashSet contexts = Sets.newHashSet();
        int labelLower = (Integer)this.productionLabels.get((Object)prio.lower());
        if (!this.isContextMappingStable && !this.rightmostContextsMapping.containsKey(labelLower)) {
            this.rightmostContextsMapping.put(labelLower, this.rightmostContextsMapping.size());
        }
        Context new_context = this.deepContextFrom(labelLower, ContextPosition.RIGHTMOST);
        contexts.add(new_context);
        HashSet conflicting_args = Sets.newHashSet();
        conflicting_args.add(conflict_pos);
        ContextualProduction p = pt.getContextualFactory().createContextualProduction(prio.higher(), contexts, conflicting_args, (int)((Integer)this.productionLabels.get((Object)prio.higher())), pt.getContextualFactory());
        if (!this.prodContextualProdMapping.containsKey((Object)prio.higher())) {
            this.prodContextualProdMapping.put((Object)prio.higher(), (Object)p);
        } else {
            ContextualProduction existing_prod = (ContextualProduction)this.prodContextualProdMapping.get((Object)prio.higher());
            this.prodContextualProdMapping.replace((Object)prio.higher(), (Object)existing_prod.addContext(new_context, conflicting_args));
        }
    }

    private void handleInfixPostFixConflict(ParseTable pt, Priority prio, Production higher, Production lower) {
        Priority inverse = pt.normalizedGrammar().getGrammarFactory().createPriority(lower, higher, false);
        if (pt.normalizedGrammar().priorities().get((Object)inverse).contains(0)) {
            return;
        }
        int conflict_pos = higher.rightRecursivePosition();
        HashSet contexts = Sets.newHashSet();
        int labelLower = (Integer)this.productionLabels.get((Object)prio.lower());
        if (!this.isContextMappingStable && !this.leftmostContextsMapping.containsKey(labelLower)) {
            this.leftmostContextsMapping.put(labelLower, this.leftmostContextsMapping.size());
        }
        Context new_context = this.deepContextFrom(labelLower, ContextPosition.LEFTMOST);
        contexts.add(new_context);
        HashSet conflicting_args = Sets.newHashSet();
        conflicting_args.add(conflict_pos);
        ContextualProduction p = pt.getContextualFactory().createContextualProduction(prio.higher(), contexts, conflicting_args, (int)((Integer)this.productionLabels.get((Object)prio.higher())), pt.getContextualFactory());
        if (!this.prodContextualProdMapping.containsKey((Object)prio.higher())) {
            this.prodContextualProdMapping.put((Object)prio.higher(), (Object)p);
        } else {
            ContextualProduction existing_prod = (ContextualProduction)this.prodContextualProdMapping.get((Object)prio.higher());
            this.prodContextualProdMapping.replace((Object)prio.higher(), (Object)existing_prod.addContext(new_context, conflicting_args));
        }
    }

    private void handleDanglingSuffixConflict(ParseTable pt, Priority prio, Production higher, Production lower) {
        Iterator iterator = pt.normalizedGrammar().priorities().get((Object)prio).iterator();
        while (iterator.hasNext()) {
            int conflict = (Integer)iterator.next();
            if (conflict < 0) continue;
            HashSet contexts = Sets.newHashSet();
            int labelLower = (Integer)this.productionLabels.get((Object)prio.lower());
            if (!this.isContextMappingStable && !this.rightmostContextsMapping.containsKey(labelLower)) {
                this.rightmostContextsMapping.put(labelLower, this.rightmostContextsMapping.size());
            }
            Context new_context_right = this.danglingContextFrom(labelLower, ContextPosition.RIGHTMOST);
            Context new_context_left = this.danglingContextFrom(labelLower, ContextPosition.LEFTMOST);
            contexts.add(new_context_right);
            contexts.add(new_context_left);
            HashSet conflicting_args = Sets.newHashSet();
            conflicting_args.add(conflict);
            ContextualProduction p = pt.getContextualFactory().createContextualProduction(prio.higher(), contexts, conflicting_args, (int)((Integer)this.productionLabels.get((Object)prio.higher())), pt.getContextualFactory());
            if (!this.prodContextualProdMapping.containsKey((Object)prio.higher())) {
                this.prodContextualProdMapping.put((Object)prio.higher(), (Object)p);
                continue;
            }
            ContextualProduction existing_prod = (ContextualProduction)this.prodContextualProdMapping.get((Object)prio.higher());
            existing_prod = existing_prod.addContext(new_context_right, conflicting_args);
            this.prodContextualProdMapping.replace((Object)prio.higher(), (Object)existing_prod.addContext(new_context_left, conflicting_args));
        }
    }

    private void handleDanglingPrefixConflict(ParseTable pt, Priority prio, Production higher, Production lower) {
        Iterator iterator = pt.normalizedGrammar().priorities().get((Object)prio).iterator();
        while (iterator.hasNext()) {
            int conflict = (Integer)iterator.next();
            if (conflict < 0 || lower.getRhs().size() < higher.getRhs().size() - conflict) continue;
            HashSet contexts = Sets.newHashSet();
            int labelLower = (Integer)this.productionLabels.get((Object)prio.lower());
            if (!this.isContextMappingStable && !this.leftmostContextsMapping.containsKey(labelLower)) {
                this.leftmostContextsMapping.put(labelLower, this.leftmostContextsMapping.size());
            }
            Context new_context_right = this.danglingContextFrom(labelLower, ContextPosition.RIGHTMOST);
            Context new_context_left = this.danglingContextFrom(labelLower, ContextPosition.LEFTMOST);
            contexts.add(new_context_right);
            contexts.add(new_context_left);
            HashSet conflicting_args = Sets.newHashSet();
            conflicting_args.add(conflict);
            ContextualProduction p = pt.getContextualFactory().createContextualProduction(prio.higher(), contexts, conflicting_args, (int)((Integer)this.productionLabels.get((Object)prio.higher())), pt.getContextualFactory());
            if (!this.prodContextualProdMapping.containsKey((Object)prio.higher())) {
                this.prodContextualProdMapping.put((Object)prio.higher(), (Object)p);
                continue;
            }
            ContextualProduction existing_prod = (ContextualProduction)this.prodContextualProdMapping.get((Object)prio.higher());
            existing_prod = existing_prod.addContext(new_context_right, conflicting_args);
            this.prodContextualProdMapping.replace((Object)prio.higher(), (Object)existing_prod.addContext(new_context_left, conflicting_args));
        }
    }

    private void handleIndirectRecursionConflict(ParseTable pt, Priority prio, Production higher) {
        for (Integer arg : pt.normalizedGrammar().priorities().get((Object)prio)) {
            ContextualProduction existing_prod;
            ContextualProduction p;
            Context new_context;
            int labelLower;
            HashSet contexts;
            HashSet conflicting_args;
            if (arg < 0 || arg >= higher.getRhs().size()) continue;
            if (arg.intValue() == higher.leftRecursivePosition() && pt.normalizedGrammar().getLeftRecursiveSymbolsMapping().get((Object)higher.leftHand()).contains(higher.getRhs().get(arg)) && !higher.getRhs().get(arg).equals(prio.lower().leftHand())) {
                conflicting_args = Sets.newHashSet();
                conflicting_args.add(arg);
                contexts = Sets.newHashSet();
                labelLower = (Integer)this.productionLabels.get((Object)prio.lower());
                new_context = this.deepContextFrom(labelLower, ContextPosition.RIGHTMOST);
                contexts.add(new_context);
                p = pt.getContextualFactory().createContextualProduction(prio.higher(), contexts, conflicting_args, (int)((Integer)this.productionLabels.get((Object)prio.higher())), pt.getContextualFactory());
                if (!this.prodContextualProdMapping.containsKey((Object)prio.higher())) {
                    this.prodContextualProdMapping.put((Object)prio.higher(), (Object)p);
                } else {
                    existing_prod = (ContextualProduction)this.prodContextualProdMapping.get((Object)prio.higher());
                    this.prodContextualProdMapping.replace((Object)prio.higher(), (Object)existing_prod.addContext(new_context, conflicting_args));
                }
            }
            if (arg.intValue() != higher.rightRecursivePosition() || !pt.normalizedGrammar().getRightRecursiveSymbolsMapping().get((Object)higher.leftHand()).contains(higher.getRhs().get(arg)) || higher.getRhs().get(arg).equals(prio.lower().leftHand())) continue;
            conflicting_args = Sets.newHashSet();
            conflicting_args.add(arg);
            contexts = Sets.newHashSet();
            labelLower = (Integer)this.productionLabels.get((Object)prio.lower());
            if (!this.isContextMappingStable && !this.leftmostContextsMapping.containsKey(labelLower)) {
                this.leftmostContextsMapping.put(labelLower, this.leftmostContextsMapping.size());
            }
            new_context = this.deepContextFrom(labelLower, ContextPosition.LEFTMOST);
            contexts.add(new_context);
            p = pt.getContextualFactory().createContextualProduction(prio.higher(), contexts, conflicting_args, (int)((Integer)this.productionLabels.get((Object)prio.higher())), pt.getContextualFactory());
            if (!this.prodContextualProdMapping.containsKey((Object)prio.higher())) {
                this.prodContextualProdMapping.put((Object)prio.higher(), (Object)p);
                continue;
            }
            existing_prod = (ContextualProduction)this.prodContextualProdMapping.get((Object)prio.higher());
            this.prodContextualProdMapping.replace((Object)prio.higher(), (Object)existing_prod.addContext(new_context, conflicting_args));
        }
    }

    private void handleLongestMatchConflictFront(ParseTable pt2, Symbol s) {
        HashSet contexts = Sets.newHashSet();
        GrammarFactory gf = this.pt.normalizedGrammar().getGrammarFactory();
        Set longestMatchProds = this.pt.normalizedGrammar().getLongestMatchProdsFront().get((Object)s);
        for (Production p : longestMatchProds) {
            int labelP = (Integer)this.productionLabels.get((Object)p);
            if (!this.isContextMappingStable && !this.leftmostContextsMapping.containsKey(labelP)) {
                this.leftmostContextsMapping.put(labelP, this.leftmostContextsMapping.size());
            }
            Context new_context = this.deepContextFrom(labelP, ContextPosition.LEFTMOST);
            contexts.add(new_context);
        }
        Symbol iterList = s;
        if (s instanceof LexicalSymbol) {
            Symbol list = ((LexicalSymbol)s).getSymbol();
            if (list instanceof IterStarSymbol) {
                iterList = gf.createLexicalSymbol(gf.createIterSymbol(((IterStarSymbol)list).getSymbol()));
            } else if (list instanceof IterStarSepSymbol) {
                iterList = gf.createLexicalSymbol(gf.createIterSepSymbol(((IterStarSepSymbol)list).getSymbol(), ((IterStarSepSymbol)list).getSeparator()));
            }
        }
        for (IProduction p : this.symbolProductionsMapping.get((Object)iterList)) {
            if (p.arity() <= 1) continue;
            ContextualProduction ctx_p = this.pt.getContextualFactory().createContextualProduction((Production)p, contexts, Sets.newHashSet((Object[])new Integer[]{2}), (int)((Integer)this.productionLabels.get((Object)p)), this.pt.getContextualFactory());
            if (!this.prodContextualProdMapping.containsKey((Object)p)) {
                this.prodContextualProdMapping.put((Object)((Production)p), (Object)ctx_p);
                continue;
            }
            ContextualProduction existing_prod = (ContextualProduction)this.prodContextualProdMapping.get((Object)p);
            this.prodContextualProdMapping.replace((Object)((Production)p), (Object)existing_prod.addContexts(contexts, Sets.newHashSet((Object[])new Integer[]{2})));
        }
    }

    private void handleLongestMatchConflictBack(ParseTable pt, Symbol s) {
        Set<Object> contexts = Sets.newHashSet();
        GrammarFactory gf = this.pt.normalizedGrammar().getGrammarFactory();
        Set longestMatchProds = pt.normalizedGrammar().getLongestMatchProdsBack().get((Object)s);
        for (Production p : longestMatchProds) {
            int labelP = (Integer)this.productionLabels.get((Object)p);
            if (!this.isContextMappingStable && !this.rightmostContextsMapping.containsKey(labelP)) {
                this.rightmostContextsMapping.put(labelP, this.rightmostContextsMapping.size());
            }
            Context new_context = this.deepContextFrom(labelP, ContextPosition.RIGHTMOST);
            contexts.add(new_context);
        }
        Symbol iterList = s;
        LinkedHashMap newProductions = Maps.newLinkedHashMap();
        if (s instanceof ContextFreeSymbol) {
            Symbol list = ((ContextFreeSymbol)s).getSymbol();
            if (list instanceof IterStarSymbol) {
                int pos;
                iterList = gf.createContextFreeSymbol(gf.createIterSymbol(((IterStarSymbol)list).getSymbol()));
                for (Production p : pt.normalizedGrammar().getLongestMatchProdsBack().get((Object)s)) {
                    if (p.getRhs().size() < 0) continue;
                    pos = p.getRhs().size() - 3;
                    ISymbol spos = p.getRhs().get(pos);
                    if (!pt.normalizedGrammar().getRightRecursiveSymbolsMapping().get((Object)spos).contains(p.leftHand())) continue;
                    IProduction nullableListProd = null;
                    IProduction nonNullableListProd = null;
                    for (IProduction list_p : this.symbolProductionsMapping.get((Object)s)) {
                        if (list_p.arity() == 1) {
                            nonNullableListProd = list_p;
                            continue;
                        }
                        nullableListProd = list_p;
                    }
                    if (nullableListProd == null || nonNullableListProd == null) continue;
                    if (nonNullableListProd instanceof Production) {
                        this.priorities.put((Object)gf.createPriority(p, (Production)nonNullableListProd, false), (Object)(p.arity() - 1));
                    } else {
                        this.priorities.put((Object)gf.createPriority(p, ((ContextualProduction)nonNullableListProd).getOrigProduction(), false), (Object)(p.arity() - 1));
                    }
                    ArrayList new_rhs = Lists.newArrayList();
                    int i = 0;
                    while (i < p.arity() - 1) {
                        new_rhs.add(p.getRhs().get(i));
                        ++i;
                    }
                    new_rhs.add(iterList);
                    Production newProd = gf.createProduction(p.getLhs(), new_rhs, p.leftRecursivePosition(), p.rightRecursivePosition());
                    UniqueProduction uniqueProd = gf.createUniqueProduction(p.getLhs(), new_rhs);
                    this.uniqueProductionMapping.put(uniqueProd, newProd);
                    this.productionAttributesMapping.putAll((Object)newProd, (Iterable)this.productionAttributesMapping.get((Object)p));
                    this.symbolProductionsMapping.put((Object)p.leftHand(), (Object)newProd);
                    this.productionLabels.put((Object)newProd, (Object)pt.getProdLabelFactory().getNextLabel());
                    int labelNewProd = (Integer)this.productionLabels.get((Object)newProd);
                    if (!this.isContextMappingStable && !this.rightmostContextsMapping.containsKey(labelNewProd)) {
                        this.rightmostContextsMapping.put(labelNewProd, this.rightmostContextsMapping.size());
                    }
                    Context new_context = this.deepContextFrom(labelNewProd, ContextPosition.RIGHTMOST);
                    contexts.add(new_context);
                    newProductions.put(newProd, p);
                }
                for (Production newProd : newProductions.keySet()) {
                    pos = ((Production)newProductions.get(newProd)).arity() - 3;
                    if (!this.prodContextualProdMapping.containsKey((Object)newProd)) {
                        ContextualProduction ctx_p2 = pt.getContextualFactory().createContextualProduction(newProd, (Set<Context>)contexts, Sets.newHashSet((Object[])new Integer[]{pos}), (int)((Integer)this.productionLabels.get((Object)newProd)), pt.getContextualFactory());
                        contexts = Collections.unmodifiableSet(contexts);
                        this.prodContextualProdMapping.put((Object)newProd, (Object)ctx_p2);
                        continue;
                    }
                    ContextualProduction existing_prod = (ContextualProduction)this.prodContextualProdMapping.get(newProductions.get(newProd));
                    this.prodContextualProdMapping.replace((Object)newProd, (Object)existing_prod.addContexts((Set<Context>)contexts, Sets.newHashSet((Object[])new Integer[]{pos})));
                }
            } else if (list instanceof IterStarSepSymbol) {
                iterList = gf.createContextFreeSymbol(gf.createIterSepSymbol(((IterStarSepSymbol)list).getSymbol(), ((IterStarSepSymbol)list).getSeparator()));
            }
        }
        if (s instanceof LexicalSymbol) {
            Symbol list = ((LexicalSymbol)s).getSymbol();
            if (list instanceof IterStarSymbol) {
                iterList = gf.createLexicalSymbol(gf.createIterSymbol(((IterStarSymbol)list).getSymbol()));
            } else if (list instanceof IterStarSepSymbol) {
                iterList = gf.createLexicalSymbol(gf.createIterSepSymbol(((IterStarSepSymbol)list).getSymbol(), ((IterStarSepSymbol)list).getSeparator()));
            }
        }
        for (IProduction p : this.symbolProductionsMapping.get((Object)iterList)) {
            if (p.arity() <= 1) continue;
            ContextualProduction ctx_p = pt.getContextualFactory().createContextualProduction((Production)p, (Set<Context>)contexts, Sets.newHashSet((Object[])new Integer[]{0}), (int)((Integer)this.productionLabels.get((Object)p)), pt.getContextualFactory());
            if (!this.prodContextualProdMapping.containsKey((Object)p)) {
                this.prodContextualProdMapping.put((Object)((Production)p), (Object)ctx_p);
                continue;
            }
            ContextualProduction existing_prod = (ContextualProduction)this.prodContextualProdMapping.get((Object)p);
            this.prodContextualProdMapping.replace((Object)((Production)p), (Object)existing_prod.addContexts((Set<Context>)contexts, Sets.newHashSet((Object[])new Integer[]{0})));
        }
    }
}

