/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.parsetable.characterclasses;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public interface ICharacterClass {
    public static final int EOF_INT = -1;
    public static final int MAX_CHAR = 0x10FFFF;
    public static final int CHARACTERS = 0x110000;

    public boolean contains(int var1);

    public int min();

    public int max();

    public boolean isEmpty();

    public int[] getRanges();

    public ICharacterClass setEOF(boolean var1);

    public ICharacterClass union(ICharacterClass var1);

    public ICharacterClass intersection(ICharacterClass var1);

    public ICharacterClass difference(ICharacterClass var1);

    public static Comparator<ICharacterClass> comparator() {
        return Comparator.comparingInt(ICharacterClass::min);
    }

    public static boolean disjointSortable(List<ICharacterClass> original) {
        ArrayList<ICharacterClass> sorted = new ArrayList<ICharacterClass>(original);
        Collections.sort(sorted, ICharacterClass.comparator());
        return ICharacterClass.disjointSorted(sorted);
    }

    public static boolean disjointSorted(List<ICharacterClass> characterClasses) {
        int i = 0;
        while (i < characterClasses.size() - 1) {
            if (characterClasses.get(i).max() >= characterClasses.get(i + 1).min()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    default public IStrategoTerm toAterm(ITermFactory tf) {
        return tf.makeAppl(tf.makeConstructor("char-class", 1), this.toAtermList(tf));
    }

    public IStrategoTerm toAtermList(ITermFactory var1);

    public boolean equals(Object var1);

    public int hashCode();
}

