/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.project;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.config.ConfigRequest;
import org.metaborg.core.config.IProjectConfig;
import org.metaborg.core.config.IProjectConfigService;
import org.metaborg.core.messages.StreamMessagePrinter;
import org.metaborg.core.project.IProject;
import org.metaborg.core.project.ISimpleProjectService;
import org.metaborg.core.project.Project;
import org.metaborg.core.source.ISourceTextService;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class SimpleProjectService
implements ISimpleProjectService {
    private static final ILogger logger = LoggerUtils.logger(SimpleProjectService.class);
    private final ISourceTextService sourceTextService;
    private final IProjectConfigService projectConfigService;
    private final ConcurrentMap<FileName, IProject> projects = Maps.newConcurrentMap();

    @Inject
    public SimpleProjectService(ISourceTextService sourceTextService, IProjectConfigService projectConfigService) {
        this.sourceTextService = sourceTextService;
        this.projectConfigService = projectConfigService;
    }

    @Override
    @Nullable
    public IProject get(FileObject resource) {
        FileName name = resource.getName();
        for (Map.Entry entry : this.projects.entrySet()) {
            FileName projectName = (FileName)entry.getKey();
            if (!name.equals(projectName) && !name.isAncestor(projectName)) continue;
            return (IProject)entry.getValue();
        }
        return null;
    }

    @Override
    public IProject create(FileObject location) throws MetaborgException {
        IProjectConfig config;
        FileName name = location.getName();
        for (FileName projectName : this.projects.keySet()) {
            if (!name.equals(projectName) && !name.isAncestor(projectName)) continue;
            String message = String.format("Location %s is equal to or nested in project %s", name, projectName);
            throw new MetaborgException(message);
        }
        ConfigRequest<? extends IProjectConfig> configRequest = this.projectConfigService.get(location);
        if (!configRequest.valid()) {
            logger.error("Errors occurred when retrieving project configuration from project directory {}", location);
            configRequest.reportErrors(new StreamMessagePrinter(this.sourceTextService, false, false, logger));
        }
        if (configRequest.config() != null) {
            config = configRequest.config();
        } else {
            logger.debug("Using default configuration for project at {}", location);
            config = this.projectConfigService.defaultConfig(location);
        }
        Project project = new Project(location, config);
        if (this.projects.putIfAbsent(name, project) != null) {
            String message = String.format("Project with location %s already exists", name);
            throw new MetaborgException(message);
        }
        return project;
    }

    @Override
    public void remove(IProject project) throws MetaborgException {
        FileName name = project.location().getName();
        if (this.projects.remove(name) == null) {
            String message = String.format("Project with location %s does not exists", name);
            throw new MetaborgException(message);
        }
    }
}

