/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.processing.analyze;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgRuntimeException;
import org.metaborg.core.analysis.AnalysisException;
import org.metaborg.core.analysis.IAnalysisService;
import org.metaborg.core.analysis.IAnalyzeResult;
import org.metaborg.core.analysis.IAnalyzeUnit;
import org.metaborg.core.analysis.IAnalyzeUnitUpdate;
import org.metaborg.core.build.UpdateKind;
import org.metaborg.core.context.IContext;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.processing.analyze.AnalysisChange;
import org.metaborg.core.processing.analyze.IAnalysisResultProcessor;
import org.metaborg.core.processing.parse.IParseResultRequester;
import org.metaborg.core.syntax.IInputUnit;
import org.metaborg.core.syntax.IParseUnit;
import org.metaborg.util.concurrent.IClosableLock;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class AnalysisResultProcessor<I extends IInputUnit, P extends IParseUnit, A extends IAnalyzeUnit, AU extends IAnalyzeUnitUpdate>
implements IAnalysisResultProcessor<I, P, A>,
AutoCloseable {
    private static final ILogger logger = LoggerUtils.logger(AnalysisResultProcessor.class);
    private final IAnalysisService<P, A, AU> analysisService;
    private final IParseResultRequester<I, P> parseResultRequester;
    private final ConcurrentMap<FileName, BehaviorSubject<AnalysisChange<A>>> updatesPerResource = Maps.newConcurrentMap();

    @Inject
    public AnalysisResultProcessor(IAnalysisService<P, A, AU> analysisService, IParseResultRequester<I, P> parseResultRequester) {
        this.analysisService = analysisService;
        this.parseResultRequester = parseResultRequester;
    }

    @Override
    public void close() {
        for (BehaviorSubject updates : this.updatesPerResource.values()) {
            updates.onComplete();
        }
        this.updatesPerResource.clear();
    }

    @Override
    public Observable<A> request(I input, IContext context) {
        if (input.detached()) {
            throw new MetaborgRuntimeException("Cannot request updates for detached (no source) units");
        }
        FileObject resource = input.source();
        return Observable.create(observer -> {
            if (observer.isDisposed()) {
                logger.trace("Unsubscribed from analysis result request for {}", resource);
                return;
            }
            BehaviorSubject<AnalysisChange<A>> updates = this.getUpdates(input, context);
            AnalysisChange update = updates.blockingStream().filter(updateToFilter -> {
                UpdateKind kind = updateToFilter.kind;
                return kind != UpdateKind.Invalidate;
            }).findFirst().orElse(null);
            if (update == null) {
                return;
            }
            if (observer.isDisposed()) {
                logger.trace("Unsubscribed from analysis result request for {}", resource);
                return;
            }
            switch (update.kind) {
                case Update: {
                    logger.trace("Returning cached analysis result for {}", resource);
                    observer.onNext(update.result);
                    observer.onComplete();
                    break;
                }
                case Error: {
                    logger.trace("Returning analysis error for {}", resource);
                    observer.onError((Throwable)update.exception);
                    break;
                }
                case Remove: {
                    String message = String.format("Analysis result for %s was removed unexpectedly", resource);
                    logger.error(message);
                    observer.onError((Throwable)new AnalysisException(context, message));
                    break;
                }
                default: {
                    String message = String.format("Unexpected analysis update kind %s for %s", new Object[]{update.kind, resource});
                    logger.error(message);
                    observer.onError((Throwable)new MetaborgRuntimeException(message));
                }
            }
        });
    }

    @Override
    public Observable<AnalysisChange<A>> updates(FileObject resource) {
        return this.getUpdates(resource.getName());
    }

    @Override
    @Nullable
    public A get(FileObject resource) {
        BehaviorSubject subject = (BehaviorSubject)this.updatesPerResource.get(resource.getName());
        if (subject == null) {
            return null;
        }
        AnalysisChange change = subject.blockingStream().findFirst().orElse(null);
        if (change == null) {
            return null;
        }
        return change.result;
    }

    @Override
    public void invalidate(FileObject resource) {
        logger.trace("Invalidating analysis result for {}", resource);
        BehaviorSubject<AnalysisChange<A>> updates = this.getUpdates(resource.getName());
        updates.onNext(AnalysisChange.invalidate(resource));
    }

    @Override
    public void invalidate(Iterable<P> results) {
        for (IParseUnit parseResult : results) {
            if (parseResult.detached()) {
                throw new MetaborgRuntimeException("Cannot invalidate results for detached (no source) units");
            }
            this.invalidate(parseResult.source());
        }
    }

    @Override
    public void invalidate(ILanguageImpl impl) {
        for (BehaviorSubject changes : this.updatesPerResource.values()) {
            AnalysisChange change = changes.blockingStream().findFirst().orElse(null);
            if (change == null || change.result == null || !impl.equals(change.result.context().language())) continue;
            changes.onNext(AnalysisChange.invalidate(change.resource));
        }
    }

    @Override
    public void update(A result, Set<FileName> removedResources) {
        if (result.detached()) {
            throw new MetaborgRuntimeException("Cannot process updates for detached (no source) units");
        }
        FileObject resource = result.source();
        FileName name = resource.getName();
        if (removedResources.contains(name)) {
            this.remove(resource);
        } else {
            logger.trace("Pushing analysis result for {}", name);
            BehaviorSubject<AnalysisChange<A>> updates = this.getUpdates(name);
            updates.onNext(AnalysisChange.update(resource, result));
        }
    }

    @Override
    public void error(FileObject resource, AnalysisException exception) {
        logger.trace("Pushing analysis error for {}", resource);
        BehaviorSubject<AnalysisChange<A>> updates = this.getUpdates(resource.getName());
        updates.onNext(AnalysisChange.error(resource, exception));
    }

    @Override
    public void error(Iterable<P> results, AnalysisException exception) {
        for (IParseUnit parseResult : results) {
            FileObject resource = parseResult.source();
            if (parseResult.detached()) {
                throw new MetaborgRuntimeException("Cannot process analysis errors for detached (no source) units");
            }
            BehaviorSubject<AnalysisChange<A>> updates = this.getUpdates(resource.getName());
            updates.onNext(AnalysisChange.error(resource, exception));
        }
    }

    @Override
    public void remove(FileObject resource) {
        logger.trace("Removing analysis result for {}", resource);
        BehaviorSubject<AnalysisChange<A>> updates = this.getUpdates(resource.getName());
        updates.onNext(AnalysisChange.remove(resource));
    }

    private BehaviorSubject<AnalysisChange<A>> getUpdates(FileName file) {
        BehaviorSubject newUpdates = BehaviorSubject.create();
        BehaviorSubject prevUpdates = this.updatesPerResource.putIfAbsent(file, newUpdates);
        return prevUpdates == null ? newUpdates : prevUpdates;
    }

    private BehaviorSubject<AnalysisChange<A>> getUpdates(I input, IContext context) {
        if (input.detached()) {
            throw new MetaborgRuntimeException("Cannot get updates for detached (no source) units");
        }
        FileObject source = input.source();
        FileName name = source.getName();
        BehaviorSubject updates = (BehaviorSubject)this.updatesPerResource.get(name);
        if (updates == null) {
            updates = BehaviorSubject.create();
            this.updatesPerResource.put(name, updates);
            try {
                IAnalyzeResult<A, AU> result;
                logger.trace("Requesting parse result for {}", source);
                IParseUnit parseResult = (IParseUnit)this.parseResultRequester.request(input).blockingSingle();
                if (!parseResult.valid()) {
                    updates.onNext(AnalysisChange.error(source, new AnalysisException(context, "Parsing failed")));
                    return updates;
                }
                logger.trace("Analysing for {}", source);
                Throwable throwable = null;
                Object var9_11 = null;
                try (IClosableLock lock = context.write();){
                    result = this.analysisService.analyze(parseResult, context);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                updates.onNext(AnalysisChange.update(source, result.result()));
            }
            catch (AnalysisException e) {
                String message = logger.format("Analysis for {} failed", name);
                logger.error(message, e);
                updates.onNext(AnalysisChange.error(source, e));
            }
            catch (Exception e) {
                String message = logger.format("Analysis for {} failed", name);
                logger.error(message, e);
                updates.onNext(AnalysisChange.error(source, new AnalysisException(context, message, e)));
            }
        }
        return updates;
    }
}

