/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.language;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import org.metaborg.core.language.ILanguage;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.ILanguageImplInternal;
import org.metaborg.core.language.ILanguageInternal;
import org.metaborg.core.language.LanguageUtils;

public class Language
implements ILanguage,
ILanguageInternal {
    private final String name;
    private final Set<ILanguageImplInternal> impls;

    public Language(String name) {
        this.name = name;
        this.impls = Sets.newHashSet();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Iterable<? extends ILanguageImpl> impls() {
        return this.impls;
    }

    @Override
    @Nullable
    public ILanguageImpl activeImpl() {
        return LanguageUtils.active(this.impls);
    }

    @Override
    public void add(ILanguageImplInternal implementation) {
        this.impls.add(implementation);
    }

    @Override
    public void remove(ILanguageImplInternal implementation) {
        this.impls.remove(implementation);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Language other = (Language)obj;
        return this.name.equals(other.name);
    }

    public String toString() {
        return "language " + this.name;
    }
}

