/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spoofax;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.statix.solver.ITermProperty;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.spoofax.StatixPrimitive;

public abstract class StatixPropertyPrimitive
extends StatixPrimitive {
    protected static final String PROP_OP = "Prop";
    protected static final String PROPERTIES_OP = "Properties";
    protected static final String STX_PROP_OP = "StxProp";
    protected static final ITerm PROP_TYPE = TermBuild.B.newAppl("Type", new ITerm[0]);
    protected static final ITerm PROP_REF = TermBuild.B.newAppl("Ref", new ITerm[0]);
    protected static final ITerm MULT_SINGLETON = TermBuild.B.newAppl("Singleton", new ITerm[0]);
    protected static final ITerm MULT_BAG = TermBuild.B.newAppl("Bag", new ITerm[0]);

    public StatixPropertyPrimitive(String name) {
        super(name);
    }

    public StatixPropertyPrimitive(String name, int tvars) {
        super(name, tvars);
    }

    protected ITerm explicate(ITermProperty.Multiplicity multiplicity) {
        return multiplicity == ITermProperty.Multiplicity.SINGLETON ? MULT_SINGLETON : MULT_BAG;
    }

    protected ITerm instantiateValue(ITermProperty property, SolverResult analysis) {
        switch (property.multiplicity()) {
            case BAG: {
                return TermBuild.B.newList((Iterable)Streams.stream(property.values()).map(analysis.state().unifier()::findRecursive).collect(ImmutableList.toImmutableList()));
            }
            case SINGLETON: {
                return analysis.state().unifier().findRecursive(property.value());
            }
        }
        throw new IllegalStateException("Unknown multiplicity " + (Object)((Object)property.multiplicity()));
    }
}

