/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spoofax;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.IBlobTerm;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.statix.solver.IConstraint;
import mb.statix.solver.log.IDebugContext;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.spec.Spec;
import mb.statix.spoofax.StatixPrimitive;
import mb.statix.spoofax.StatixTerms;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;

public abstract class StatixConstraintPrimitive
extends StatixPrimitive {
    protected static final ILogger logger = LoggerUtils.logger(StatixConstraintPrimitive.class);

    @Inject
    public StatixConstraintPrimitive(String name) {
        super(name, 4);
    }

    @Override
    protected Optional<? extends ITerm> call(IContext env, ITerm term, List<ITerm> terms) throws InterpreterException {
        ITerm specTerm = terms.get(0);
        Spec spec = StatixTerms.spec().match(specTerm).orElseThrow(() -> new InterpreterException("Expected spec, got " + specTerm));
        this.reportOverlappingRules(spec);
        IDebugContext debug = this.getDebugContext(terms.get(1));
        IProgress progress = this.getProgress(terms.get(2));
        ICancel cancel = this.getCancel(terms.get(3));
        Function1<IConstraint, ITerm> solveConstraint = constraint -> this.solveConstraint(spec, (IConstraint)constraint, debug, progress, cancel);
        TermMatch.IMatcher[] iMatcherArray = new TermMatch.IMatcher[2];
        iMatcherArray[0] = StatixTerms.constraint().map(solveConstraint::apply);
        iMatcherArray[1] = TermMatch.M.listElems(StatixTerms.constraint()).map(vars_constraints -> TermBuild.B.newList((Iterable)((Stream)vars_constraints.stream().parallel()).map(solveConstraint::apply).collect(ImmutableList.toImmutableList())));
        return TermMatch.M.cases(iMatcherArray).match(term);
    }

    private ITerm solveConstraint(Spec spec, IConstraint constraint, IDebugContext debug, IProgress progress, ICancel cancel) {
        SolverResult resultConfig;
        try {
            resultConfig = this.solve(spec, constraint, debug, progress, cancel);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        IUniDisunifier.Immutable unifier = resultConfig.state().unifier();
        ArrayList substEntries = Lists.newArrayList();
        for (Map.Entry e : resultConfig.existentials().entrySet()) {
            ITerm v = StatixTerms.explode((ITermVar)e.getKey());
            ITerm t = StatixTerms.explicateVars(unifier.findRecursive((ITerm)e.getValue()));
            substEntries.add(TermBuild.B.newTuple(v, t));
        }
        IListTerm substTerm = TermBuild.B.newList(substEntries);
        IBlobTerm solverTerm = TermBuild.B.newBlob(resultConfig);
        IApplTerm resultTerm = TermBuild.B.newAppl("Solution", substTerm, solverTerm);
        return resultTerm;
    }

    protected abstract SolverResult solve(Spec var1, IConstraint var2, IDebugContext var3, IProgress var4, ICancel var5) throws InterruptedException, ExecutionException;

    @Override
    protected ILogger getLogger() {
        return logger;
    }
}

