/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.query;

import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.scopegraph.regexp.IRegExp;
import mb.scopegraph.regexp.IRegExpMatcher;
import mb.scopegraph.regexp.RegExpMatcher;
import mb.statix.spec.Rule;
import mb.statix.spec.RuleUtil;

public class QueryFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final IRegExpMatcher<ITerm> pathWf;
    private final Rule dataWf;

    public QueryFilter(IRegExp<ITerm> pathWf, Rule dataConstraint) {
        this(RegExpMatcher.create(pathWf), dataConstraint);
    }

    public QueryFilter(IRegExpMatcher<ITerm> pathWf, Rule dataConstraint) {
        this.pathWf = pathWf;
        this.dataWf = dataConstraint;
    }

    public IRegExpMatcher<ITerm> getLabelWF() {
        return this.pathWf;
    }

    public Rule getDataWF() {
        return this.dataWf;
    }

    public Set.Immutable<ITermVar> getVars() {
        return RuleUtil.vars(this.dataWf);
    }

    public QueryFilter apply(ISubstitution.Immutable subst) {
        return new QueryFilter(this.pathWf, this.dataWf.apply(subst));
    }

    public QueryFilter unsafeApply(ISubstitution.Immutable subst) {
        return new QueryFilter(this.pathWf, this.dataWf.unsafeApply(subst));
    }

    public QueryFilter apply(IRenaming subst) {
        return new QueryFilter(this.pathWf, this.dataWf.apply(subst));
    }

    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append("filter ");
        sb.append(this.pathWf);
        sb.append(" and ");
        sb.append(this.dataWf.toString(termToString));
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryFilter that = (QueryFilter)o;
        return Objects.equals(this.pathWf, that.pathWf) && Objects.equals(this.dataWf, that.dataWf);
    }

    public int hashCode() {
        return Objects.hash(this.pathWf, this.dataWf);
    }
}

