/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mb.nabl2.terms.ITermVar;
import mb.statix.solver.Delay;
import mb.statix.solver.IConstraint;
import mb.statix.solver.IState;
import mb.statix.solver.persistent.AStepResult;

final class StepResult
extends AStepResult {
    private final IState.Immutable state;
    private final ImmutableList<ITermVar> updatedVars;
    private final ImmutableList<IConstraint> newConstraints;
    private final ImmutableMap<Delay, IConstraint> delayedConstraints;
    private final ImmutableMap<ITermVar, ITermVar> existentials;
    private transient int hashCode;

    private StepResult(IState.Immutable state, Iterable<? extends ITermVar> updatedVars, Iterable<? extends IConstraint> newConstraints, Map<? extends Delay, ? extends IConstraint> delayedConstraints, Map<? extends ITermVar, ? extends ITermVar> existentials) {
        this.state = Objects.requireNonNull(state, "state");
        this.updatedVars = ImmutableList.copyOf(updatedVars);
        this.newConstraints = ImmutableList.copyOf(newConstraints);
        this.delayedConstraints = ImmutableMap.copyOf(delayedConstraints);
        this.existentials = ImmutableMap.copyOf(existentials);
    }

    private StepResult(StepResult original, IState.Immutable state, ImmutableList<ITermVar> updatedVars, ImmutableList<IConstraint> newConstraints, ImmutableMap<Delay, IConstraint> delayedConstraints, ImmutableMap<ITermVar, ITermVar> existentials) {
        this.state = state;
        this.updatedVars = updatedVars;
        this.newConstraints = newConstraints;
        this.delayedConstraints = delayedConstraints;
        this.existentials = existentials;
    }

    @Override
    public IState.Immutable state() {
        return this.state;
    }

    public ImmutableList<ITermVar> updatedVars() {
        return this.updatedVars;
    }

    public ImmutableList<IConstraint> newConstraints() {
        return this.newConstraints;
    }

    public ImmutableMap<Delay, IConstraint> delayedConstraints() {
        return this.delayedConstraints;
    }

    public ImmutableMap<ITermVar, ITermVar> existentials() {
        return this.existentials;
    }

    public final StepResult withState(IState.Immutable value) {
        if (this.state == value) {
            return this;
        }
        IState.Immutable newValue = Objects.requireNonNull(value, "state");
        return new StepResult(this, newValue, this.updatedVars, this.newConstraints, this.delayedConstraints, this.existentials);
    }

    public final StepResult withUpdatedVars(ITermVar ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new StepResult(this, this.state, (ImmutableList<ITermVar>)newValue, this.newConstraints, this.delayedConstraints, this.existentials);
    }

    public final StepResult withUpdatedVars(Iterable<? extends ITermVar> elements) {
        if (this.updatedVars == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new StepResult(this, this.state, (ImmutableList<ITermVar>)newValue, this.newConstraints, this.delayedConstraints, this.existentials);
    }

    public final StepResult withNewConstraints(IConstraint ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new StepResult(this, this.state, this.updatedVars, (ImmutableList<IConstraint>)newValue, this.delayedConstraints, this.existentials);
    }

    public final StepResult withNewConstraints(Iterable<? extends IConstraint> elements) {
        if (this.newConstraints == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new StepResult(this, this.state, this.updatedVars, (ImmutableList<IConstraint>)newValue, this.delayedConstraints, this.existentials);
    }

    public final StepResult withDelayedConstraints(Map<? extends Delay, ? extends IConstraint> entries) {
        if (this.delayedConstraints == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new StepResult(this, this.state, this.updatedVars, this.newConstraints, (ImmutableMap<Delay, IConstraint>)newValue, this.existentials);
    }

    public final StepResult withExistentials(Map<? extends ITermVar, ? extends ITermVar> entries) {
        if (this.existentials == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new StepResult(this, this.state, this.updatedVars, this.newConstraints, this.delayedConstraints, (ImmutableMap<ITermVar, ITermVar>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof StepResult && this.equalTo((StepResult)another);
    }

    private boolean equalTo(StepResult another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.state.equals(another.state) && this.updatedVars.equals(another.updatedVars) && this.newConstraints.equals(another.newConstraints) && this.delayedConstraints.equals(another.delayedConstraints) && this.existentials.equals(another.existentials);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.state.hashCode();
        h += (h << 5) + this.updatedVars.hashCode();
        h += (h << 5) + this.newConstraints.hashCode();
        h += (h << 5) + this.delayedConstraints.hashCode();
        h += (h << 5) + this.existentials.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StepResult").omitNullValues().add("state", (Object)this.state).add("updatedVars", this.updatedVars).add("newConstraints", this.newConstraints).add("delayedConstraints", this.delayedConstraints).add("existentials", this.existentials).toString();
    }

    public static StepResult of(IState.Immutable state, List<ITermVar> updatedVars, List<IConstraint> newConstraints, Map<Delay, IConstraint> delayedConstraints, Map<ITermVar, ITermVar> existentials) {
        return StepResult.of(state, updatedVars, newConstraints, delayedConstraints, existentials);
    }

    public static StepResult of(IState.Immutable state, Iterable<? extends ITermVar> updatedVars, Iterable<? extends IConstraint> newConstraints, Map<? extends Delay, ? extends IConstraint> delayedConstraints, Map<? extends ITermVar, ? extends ITermVar> existentials) {
        return new StepResult(state, updatedVars, newConstraints, delayedConstraints, existentials);
    }

    public static StepResult copyOf(AStepResult instance) {
        if (instance instanceof StepResult) {
            return (StepResult)instance;
        }
        return StepResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ StepResult(StepResult stepResult, IState.Immutable immutable, ImmutableList immutableList, ImmutableList immutableList2, ImmutableMap immutableMap, ImmutableMap immutableMap2, StepResult stepResult2) {
        this(stepResult, immutable, (ImmutableList<ITermVar>)immutableList, (ImmutableList<IConstraint>)immutableList2, (ImmutableMap<Delay, IConstraint>)immutableMap, (ImmutableMap<ITermVar, ITermVar>)immutableMap2);
    }

    public static final class Builder {
        private static final long INIT_BIT_STATE = 1L;
        private long initBits = 1L;
        private IState.Immutable state;
        private ImmutableList.Builder<ITermVar> updatedVars = ImmutableList.builder();
        private ImmutableList.Builder<IConstraint> newConstraints = ImmutableList.builder();
        private ImmutableMap.Builder<Delay, IConstraint> delayedConstraints = ImmutableMap.builder();
        private ImmutableMap.Builder<ITermVar, ITermVar> existentials = ImmutableMap.builder();

        private Builder() {
        }

        public final Builder from(AStepResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.state(instance.state());
            this.addAllUpdatedVars(instance.updatedVars());
            this.addAllNewConstraints(instance.newConstraints());
            this.putAllDelayedConstraints(instance.delayedConstraints());
            this.putAllExistentials(instance.existentials());
            return this;
        }

        public final Builder state(IState.Immutable state) {
            this.state = Objects.requireNonNull(state, "state");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addUpdatedVars(ITermVar element) {
            this.updatedVars.add((Object)element);
            return this;
        }

        public final Builder addUpdatedVars(ITermVar ... elements) {
            this.updatedVars.add((Object[])elements);
            return this;
        }

        public final Builder updatedVars(Iterable<? extends ITermVar> elements) {
            this.updatedVars = ImmutableList.builder();
            return this.addAllUpdatedVars(elements);
        }

        public final Builder addAllUpdatedVars(Iterable<? extends ITermVar> elements) {
            this.updatedVars.addAll(elements);
            return this;
        }

        public final Builder addNewConstraints(IConstraint element) {
            this.newConstraints.add((Object)element);
            return this;
        }

        public final Builder addNewConstraints(IConstraint ... elements) {
            this.newConstraints.add((Object[])elements);
            return this;
        }

        public final Builder newConstraints(Iterable<? extends IConstraint> elements) {
            this.newConstraints = ImmutableList.builder();
            return this.addAllNewConstraints(elements);
        }

        public final Builder addAllNewConstraints(Iterable<? extends IConstraint> elements) {
            this.newConstraints.addAll(elements);
            return this;
        }

        public final Builder putDelayedConstraints(Delay key, IConstraint value) {
            this.delayedConstraints.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putDelayedConstraints(Map.Entry<? extends Delay, ? extends IConstraint> entry) {
            this.delayedConstraints.put(entry);
            return this;
        }

        public final Builder delayedConstraints(Map<? extends Delay, ? extends IConstraint> entries) {
            this.delayedConstraints = ImmutableMap.builder();
            return this.putAllDelayedConstraints(entries);
        }

        public final Builder putAllDelayedConstraints(Map<? extends Delay, ? extends IConstraint> entries) {
            this.delayedConstraints.putAll(entries);
            return this;
        }

        public final Builder putExistentials(ITermVar key, ITermVar value) {
            this.existentials.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putExistentials(Map.Entry<? extends ITermVar, ? extends ITermVar> entry) {
            this.existentials.put(entry);
            return this;
        }

        public final Builder existentials(Map<? extends ITermVar, ? extends ITermVar> entries) {
            this.existentials = ImmutableMap.builder();
            return this.putAllExistentials(entries);
        }

        public final Builder putAllExistentials(Map<? extends ITermVar, ? extends ITermVar> entries) {
            this.existentials.putAll(entries);
            return this;
        }

        public StepResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new StepResult(null, this.state, this.updatedVars.build(), this.newConstraints.build(), this.delayedConstraints.build(), this.existentials.build(), null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("state");
            }
            return "Cannot build StepResult, some of required attributes are not set " + attributes;
        }
    }
}

