/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.completeness;

import com.google.common.collect.Streams;
import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.terms.unification.u.PersistentUnifier;
import mb.scopegraph.oopsla20.reference.EdgeOrData;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.CriticalEdge;
import mb.statix.solver.completeness.CompletenessUtil;
import mb.statix.solver.completeness.ICompleteness;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.MultiSet;
import org.metaborg.util.collection.MultiSetMap;

public abstract class Completeness
implements ICompleteness {
    private static final Immutable EMPTY = new Immutable(MultiSetMap.Immutable.of());

    protected abstract MultiSetMap<ITerm, EdgeOrData<ITerm>> asMap();

    @Override
    public Set<Map.Entry<ITerm, MultiSet.Immutable<EdgeOrData<ITerm>>>> entrySet() {
        return this.asMap().entrySet();
    }

    @Override
    public boolean isEmpty() {
        return this.asMap().isEmpty();
    }

    @Override
    public MultiSet<EdgeOrData<ITerm>> get(ITerm scopeOrVar, IUnifier unifier) {
        return Completeness.getVarOrScope(scopeOrVar, unifier).map(sOV -> this.asMap().get((ITerm)sOV)).orElse(MultiSet.Immutable.of());
    }

    @Override
    public boolean isComplete(Scope scope, EdgeOrData<ITerm> label, IUnifier unifier) {
        if (!label.match(() -> true, lbl -> lbl.isGround()).booleanValue()) {
            throw new IllegalArgumentException("Label must be ground, got " + label);
        }
        return Completeness.getVarOrScope(scope, unifier).map(sOV -> !this.asMap().containsKey((ITerm)sOV) || this.asMap().get((ITerm)sOV).count(label) <= 0).orElse(true);
    }

    protected static Set<ITerm> getVarsOrScopes(Iterable<? extends ITerm> varOrScopes, IUnifier unifier) {
        return Streams.stream(varOrScopes).flatMap(t -> Streams.stream(Completeness.getVarOrScope(t, unifier))).collect(Collectors.toSet());
    }

    protected static Optional<ITerm> getVarOrScope(ITerm scopeOrVar, IUnifier unifier) {
        return CompletenessUtil.scopeOrVar().match(scopeOrVar, unifier);
    }

    public String toString() {
        return this.asMap().toString();
    }

    public static class Immutable
    extends Completeness
    implements ICompleteness.Immutable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final MultiSetMap.Immutable<ITerm, EdgeOrData<ITerm>> incomplete;

        private Immutable(MultiSetMap.Immutable<ITerm, EdgeOrData<ITerm>> incomplete) {
            this.incomplete = incomplete;
        }

        protected MultiSetMap.Immutable<ITerm, EdgeOrData<ITerm>> asMap() {
            return this.incomplete;
        }

        @Override
        public ICompleteness.Immutable addAll(ICompleteness.Immutable criticalEdges, IUnifier unifier) {
            Transient _completeness = this.melt();
            _completeness.addAll(criticalEdges, unifier);
            return _completeness.freeze();
        }

        @Override
        public ICompleteness.Immutable apply(ISubstitution.Immutable subst) {
            Transient _completeness = this.melt();
            _completeness.apply(subst);
            return _completeness.freeze();
        }

        @Override
        public ICompleteness.Immutable apply(IRenaming subst) {
            Transient _completeness = this.melt();
            _completeness.apply(subst);
            return _completeness.freeze();
        }

        @Override
        public ICompleteness.Immutable removeAll(Iterable<? extends ITerm> varOrScopes, IUnifier unifier) {
            return new Immutable(this.incomplete.removeAll(Immutable.getVarsOrScopes(varOrScopes, unifier)));
        }

        @Override
        public ICompleteness.Immutable retainAll(Iterable<? extends ITerm> varOrScopes, IUnifier unifier) {
            return new Immutable(this.incomplete.retainAll(Immutable.getVarsOrScopes(varOrScopes, unifier)));
        }

        @Override
        public ICompleteness.Immutable updateAll(Iterable<? extends ITermVar> vars, IUnifier unifier) {
            Transient _completeness = this.melt();
            _completeness.updateAll(vars, unifier);
            return _completeness.freeze();
        }

        @Override
        public Transient melt() {
            return new Transient(this.incomplete.melt());
        }

        public static Immutable of() {
            return EMPTY;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Immutable immutable = (Immutable)o;
            return this.incomplete.equals(immutable.incomplete);
        }

        public int hashCode() {
            return this.incomplete.hashCode();
        }
    }

    public static class Transient
    extends Completeness
    implements ICompleteness.Transient {
        private final MultiSetMap.Transient<ITerm, EdgeOrData<ITerm>> incomplete;

        private Transient(MultiSetMap.Transient<ITerm, EdgeOrData<ITerm>> incomplete) {
            this.incomplete = incomplete;
        }

        @Override
        protected MultiSetMap<ITerm, EdgeOrData<ITerm>> asMap() {
            return this.incomplete;
        }

        @Override
        public void add(ITerm scopeTerm, EdgeOrData<ITerm> label, IUnifier unifier) {
            Transient.getVarOrScope(scopeTerm, unifier).ifPresent(scopeOrVar -> this.incomplete.put((ITerm)scopeOrVar, label));
        }

        @Override
        public void addAll(ICompleteness.Immutable criticalEdges, IUnifier unifier) {
            for (Map.Entry<ITerm, MultiSet.Immutable<EdgeOrData<ITerm>>> varLabel : criticalEdges.entrySet()) {
                Transient.getVarOrScope(varLabel.getKey(), unifier).ifPresent(scopeOrVar -> this.incomplete.putAll((ITerm)scopeOrVar, (MultiSet.Immutable)varLabel.getValue()));
            }
        }

        @Override
        public Set.Immutable<CriticalEdge> remove(ITerm scopeTerm, EdgeOrData<ITerm> label, IUnifier unifier) {
            Set.Transient removedEdges = CapsuleUtil.transientSet();
            Transient.getVarOrScope(scopeTerm, unifier).ifPresent(scopeOrVar -> {
                int n = this.incomplete.remove((ITerm)scopeOrVar, label);
                if (n == 0) {
                    throw new IllegalStateException("Absent critical edge: " + scopeOrVar + "/" + label);
                }
                if (n == 1) {
                    removedEdges.__insert((Object)CriticalEdge.of(scopeOrVar, label));
                }
            });
            return removedEdges.freeze();
        }

        @Override
        public Set.Immutable<CriticalEdge> removeAll(ICompleteness.Immutable criticalEdges, IUnifier unifier) {
            Set.Transient removedEdges = CapsuleUtil.transientSet();
            for (Map.Entry<ITerm, MultiSet.Immutable<EdgeOrData<ITerm>>> varLabel : criticalEdges.entrySet()) {
                Transient.getVarOrScope(varLabel.getKey(), unifier).ifPresent(scopeOrVar -> {
                    for (Map.Entry labelCount : ((MultiSet.Immutable)varLabel.getValue()).entrySet()) {
                        int n = this.incomplete.remove((ITerm)scopeOrVar, (EdgeOrData)labelCount.getKey(), labelCount.getValue());
                        if (n == 0) {
                            throw new IllegalStateException("Absent critical edge: " + scopeOrVar + "/" + labelCount.getKey() + "#" + labelCount.getValue());
                        }
                        if (n != 1) continue;
                        removedEdges.__insert((Object)CriticalEdge.of(scopeOrVar, (EdgeOrData)labelCount.getKey()));
                    }
                });
            }
            return removedEdges.freeze();
        }

        @Override
        public void update(ITermVar var, IUnifier unifier) {
            if (!this.incomplete.containsKey(var)) {
                return;
            }
            MultiSet.Immutable<EdgeOrData<ITerm>> updatedLabels = this.incomplete.removeKey(var);
            Transient.getVarOrScope(var, unifier).ifPresent(scopeOrVar -> this.incomplete.putAll((ITerm)scopeOrVar, updatedLabels));
        }

        @Override
        public void apply(ISubstitution.Immutable subst) {
            MultiSetMap.Transient newEntries = MultiSetMap.Transient.of();
            for (Map.Entry<ITermVar, ITerm> varTerm : subst.entrySet()) {
                MultiSet.Immutable<EdgeOrData<ITerm>> updatedLabels = this.incomplete.removeKey(varTerm.getKey());
                if (updatedLabels.isEmpty()) continue;
                Transient.getVarOrScope(varTerm.getValue(), PersistentUnifier.Immutable.of()).ifPresent(scopeOrVar -> newEntries.putAll(scopeOrVar, updatedLabels));
            }
            for (Map.Entry<ITermVar, ITerm> varTerm : newEntries.asMap().entrySet()) {
                this.incomplete.putAll((ITerm)varTerm.getKey(), (MultiSet.Immutable)((Object)varTerm.getValue()));
            }
        }

        @Override
        public void apply(IRenaming renaming) {
            MultiSetMap.Transient<ITermVar, EdgeOrData<ITerm>> newEntries = MultiSetMap.Transient.of();
            for (ITermVar var : renaming.keySet()) {
                MultiSet.Immutable<EdgeOrData<ITerm>> updatedLabels = this.incomplete.removeKey(var);
                if (updatedLabels.isEmpty()) continue;
                newEntries.putAll(renaming.rename(var), updatedLabels);
            }
            for (Map.Entry varTerm : newEntries.asMap().entrySet()) {
                this.incomplete.putAll((ITerm)varTerm.getKey(), (MultiSet.Immutable)varTerm.getValue());
            }
        }

        @Override
        public Immutable freeze() {
            return this.incomplete.isEmpty() ? EMPTY : new Immutable(this.incomplete.freeze());
        }

        public static Transient of() {
            return new Transient(MultiSetMap.Transient.of());
        }
    }
}

