/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import io.usethesource.capsule.util.stream.CapsuleCollectors;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.stratego.TermIndex;
import mb.nabl2.terms.stratego.TermOrigin;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.substitution.Renaming;
import mb.nabl2.terms.unification.OccursException;
import mb.nabl2.terms.unification.RigidException;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.terms.unification.ud.Diseq;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.p_raffrayi.DeadlockException;
import mb.p_raffrayi.ITypeCheckerContext;
import mb.p_raffrayi.nameresolution.DataLeq;
import mb.p_raffrayi.nameresolution.DataWf;
import mb.scopegraph.ecoop21.RegExpLabelWf;
import mb.scopegraph.ecoop21.RelationLabelOrder;
import mb.scopegraph.oopsla20.path.IResolutionPath;
import mb.scopegraph.patching.IPatchCollection;
import mb.statix.concurrent.SolverState;
import mb.statix.concurrent.util.Patching;
import mb.statix.concurrent.util.VarIndexedCollection;
import mb.statix.constraints.CArith;
import mb.statix.constraints.CAstId;
import mb.statix.constraints.CAstProperty;
import mb.statix.constraints.CCompiledQuery;
import mb.statix.constraints.CConj;
import mb.statix.constraints.CEqual;
import mb.statix.constraints.CExists;
import mb.statix.constraints.CFalse;
import mb.statix.constraints.CInequal;
import mb.statix.constraints.CNew;
import mb.statix.constraints.CResolveQuery;
import mb.statix.constraints.CTellEdge;
import mb.statix.constraints.CTrue;
import mb.statix.constraints.CTry;
import mb.statix.constraints.CUser;
import mb.statix.constraints.Constraints;
import mb.statix.constraints.IResolveQuery;
import mb.statix.constraints.messages.IMessage;
import mb.statix.constraints.messages.MessageKind;
import mb.statix.constraints.messages.MessageUtil;
import mb.statix.scopegraph.AScope;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.CriticalEdge;
import mb.statix.solver.Delay;
import mb.statix.solver.IConstraint;
import mb.statix.solver.IConstraintStore;
import mb.statix.solver.IState;
import mb.statix.solver.ITermProperty;
import mb.statix.solver.completeness.Completeness;
import mb.statix.solver.completeness.CompletenessUtil;
import mb.statix.solver.completeness.ICompleteness;
import mb.statix.solver.log.IDebugContext;
import mb.statix.solver.log.LazyDebugContext;
import mb.statix.solver.log.NullDebugContext;
import mb.statix.solver.persistent.BagTermProperty;
import mb.statix.solver.persistent.SingletonTermProperty;
import mb.statix.solver.persistent.Solver;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.solver.persistent.State;
import mb.statix.solver.query.QueryFilter;
import mb.statix.solver.query.QueryMin;
import mb.statix.solver.query.ResolutionDelayException;
import mb.statix.solver.store.BaseConstraintStore;
import mb.statix.spec.ApplyMode;
import mb.statix.spec.ApplyResult;
import mb.statix.spec.Rule;
import mb.statix.spec.RuleUtil;
import mb.statix.spec.Spec;
import mb.statix.spoofax.StatixTerms;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.CheckedAction0;
import org.metaborg.util.functions.Function0;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.Level;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.metaborg.util.task.NullProgress;
import org.metaborg.util.tuple.Tuple2;
import org.metaborg.util.tuple.Tuple3;
import org.metaborg.util.unit.Unit;

public class StatixSolver {
    private static final ShadowOptimization SHADOW_OPTIMIZATION = ShadowOptimization.RULE;
    private static final boolean LOCAL_INFERENCE = true;
    private static final ImmutableSet<ITermVar> NO_UPDATED_VARS = ImmutableSet.of();
    private static final ImmutableList<IConstraint> NO_NEW_CONSTRAINTS = ImmutableList.of();
    private static final Completeness.Immutable NO_NEW_CRITICAL_EDGES = Completeness.Immutable.of();
    private static final ImmutableMap<ITermVar, ITermVar> NO_EXISTENTIALS = ImmutableMap.of();
    private static final int MAX_DEPTH = 32;
    private final Spec spec;
    private final IConstraintStore constraints;
    private final IDebugContext debug;
    private final IProgress progress;
    private final ICancel cancel;
    private final ITypeCheckerContext<Scope, ITerm, ITerm> scopeGraph;
    private final int flags;
    private IState.Immutable state;
    private ICompleteness.Immutable completeness;
    private Map<ITermVar, ITermVar> existentials = null;
    private final List<ITermVar> updatedVars = Lists.newArrayList();
    private final Map<IConstraint, IMessage> failed = Maps.newHashMap();
    private final AtomicBoolean inFixedPoint = new AtomicBoolean(false);
    private final Set.Transient<IConstraint> pendingConstraints = CapsuleUtil.transientSet();
    private final CompletableFuture<SolverResult> result;
    private Set.Transient<CriticalEdge> delayedCloses = CapsuleUtil.transientSet();
    private final VarIndexedCollection<CheckedAction0<InterruptedException>> delayedActions = new VarIndexedCollection();

    public StatixSolver(IConstraint constraint, Spec spec, IState.Immutable state, ICompleteness.Immutable completeness, IDebugContext debug, IProgress progress, ICancel cancel, ITypeCheckerContext<Scope, ITerm, ITerm> scopeGraph, int flags) {
        if (!spec.hasPrecomputedCriticalEdges()) {
            debug.warn("Leaving precomputing critical edges to solver may result in duplicate work.", new Object[0]);
            this.spec = spec.precomputeCriticalEdges();
        } else {
            this.spec = spec;
        }
        this.scopeGraph = scopeGraph;
        this.state = state;
        this.debug = debug;
        this.constraints = new BaseConstraintStore(debug);
        ICompleteness.Transient _completeness = completeness.melt();
        Tuple2<IConstraint, ICompleteness.Immutable> initialConstraintAndCriticalEdges = CompletenessUtil.precomputeCriticalEdges(constraint, spec.scopeExtensions());
        this.constraints.add(initialConstraintAndCriticalEdges._1());
        _completeness.addAll(initialConstraintAndCriticalEdges._2(), state.unifier());
        this.completeness = _completeness.freeze();
        this.result = new CompletableFuture();
        this.progress = progress;
        this.cancel = cancel;
        this.flags = flags;
    }

    public StatixSolver(SolverState state, Spec spec, IDebugContext debug, IProgress progress, ICancel cancel, ITypeCheckerContext<Scope, ITerm, ITerm> scopeGraph, int flags) {
        if (!spec.hasPrecomputedCriticalEdges()) {
            debug.warn("Leaving precomputing critical edges to solver may result in duplicate work.", new Object[0]);
            this.spec = spec.precomputeCriticalEdges();
        } else {
            this.spec = spec;
        }
        this.scopeGraph = scopeGraph;
        this.debug = debug;
        this.constraints = new BaseConstraintStore(debug);
        this.result = new CompletableFuture();
        this.progress = progress;
        this.cancel = cancel;
        this.flags = flags;
        this.state = state.state();
        this.completeness = state.completeness();
        this.constraints.addAll((Iterable<? extends IConstraint>)state.constraints());
        this.existentials = state.existentials();
        this.updatedVars.addAll((Collection<ITermVar>)state.updatedVars());
        this.failed.putAll((Map<IConstraint, IMessage>)state.failed());
        try {
            for (CriticalEdge criticalEdge : state.delayedCloses()) {
                this.closeEdge(criticalEdge);
            }
        }
        catch (InterruptedException e) {
            this.result.completeExceptionally(e);
        }
    }

    public IFuture<SolverResult> solve(Iterable<Scope> roots) {
        try {
            for (Scope root : CapsuleUtil.toSet(roots)) {
                Set.Immutable<ITerm> openEdges = this.getOpenEdges(root);
                this.scopeGraph.initScope(root, (Iterable<ITerm>)openEdges, false);
            }
            this.fixedpoint();
        }
        catch (Throwable e) {
            this.result.completeExceptionally(e);
        }
        return this.result;
    }

    public IFuture<SolverResult> continueSolve() {
        try {
            this.fixedpoint();
        }
        catch (Throwable e) {
            this.result.completeExceptionally(e);
        }
        return this.result;
    }

    public IFuture<SolverResult> entail() {
        return this.solve(Collections.emptyList());
    }

    private <R> void solveK(K<R> k, R r, Throwable ex) {
        this.debug.debug("Solving continuation", new Object[0]);
        try {
            if (!k.k(r, ex, 32)) {
                this.debug.debug("Finished fast.", new Object[0]);
                this.result.complete(this.finishSolve());
                return;
            }
            this.fixedpoint();
        }
        catch (Throwable e) {
            this.result.completeExceptionally(e);
        }
        this.debug.debug("Solved continuation", new Object[0]);
    }

    private void fixedpoint() throws InterruptedException {
        IConstraint constraint;
        if (!this.inFixedPoint.compareAndSet(false, true)) {
            return;
        }
        this.debug.debug("Solving constraints", new Object[0]);
        while ((constraint = this.constraints.remove()) != null) {
            if (this.k(constraint, 32)) continue;
            this.debug.debug("Finished fast.", new Object[0]);
            this.result.complete(this.finishSolve());
            return;
        }
        if (this.constraints.activeSize() > 0) {
            this.debug.warn("Fixed point finished with remaining constraints", new Object[0]);
            throw new IllegalStateException("Expected no remaining active constraints, but got " + this.constraints.activeSize());
        }
        this.debug.debug("Has pending: {}, done: {}", this.pendingConstraints.size(), this.result.isDone());
        if (this.pendingConstraints.size() == 0 && !this.result.isDone()) {
            this.debug.debug("Finished.", new Object[0]);
            this.result.complete(this.finishSolve());
        } else {
            this.debug.debug("Not finished.", new Object[0]);
        }
        if (!this.inFixedPoint.compareAndSet(true, false)) {
            throw new IllegalStateException("Fixed point nesting detection error.");
        }
    }

    private SolverResult finishSolve() throws InterruptedException {
        Map<IConstraint, Delay> delayed = this.constraints.delayed();
        this.debug.debug("Solved constraints with {} failed and {} remaining constraint(s).", this.failed.size(), this.constraints.delayedSize());
        if (this.debug.isEnabled(Level.Debug)) {
            for (Map.Entry entry : delayed.entrySet()) {
                Object[] objectArray = new Object[2];
                objectArray[0] = ((IConstraint)entry.getKey()).toString(this.state.unifier()::toString);
                objectArray[1] = entry.getValue();
                this.debug.debug(" * {} on {}", objectArray);
            }
        }
        for (IConstraint iConstraint : delayed.keySet()) {
            this.removeCompleteness(iConstraint);
        }
        Map map = (Map)Optional.ofNullable(this.existentials).orElse((Map<ITermVar, ITermVar>)NO_EXISTENTIALS);
        ImmutableSet removedEdges = ImmutableSet.of();
        Completeness.Immutable completeness = Completeness.Immutable.of();
        SolverResult result = SolverResult.of(this.spec, this.state, this.failed, delayed, map, this.updatedVars, (Iterable<? extends CriticalEdge>)removedEdges, (ICompleteness.Immutable)completeness);
        return result;
    }

    private boolean success(IConstraint constraint, IState.Immutable newState, Collection<ITermVar> updatedVars, Collection<IConstraint> newConstraints, ICompleteness.Immutable newCriticalEdges, Map<ITermVar, ITermVar> existentials, int fuel) throws InterruptedException {
        ICompleteness.Transient _completeness;
        this.state = newState;
        IDebugContext subDebug = this.debug.subContext();
        if (this.existentials == null) {
            this.existentials = existentials;
        }
        IUniDisunifier.Immutable unifier = this.state.unifier();
        if (!updatedVars.isEmpty()) {
            _completeness = this.completeness.melt();
            _completeness.updateAll(updatedVars, unifier);
            this.completeness = _completeness.freeze();
            this.constraints.activateFromVars(updatedVars, this.debug);
            this.updatedVars.addAll(updatedVars);
        }
        if (!newConstraints.isEmpty()) {
            _completeness = this.completeness.melt();
            _completeness.addAll(newCriticalEdges, unifier);
            this.completeness = _completeness.freeze();
            if (subDebug.isEnabled(Level.Debug) && !newConstraints.isEmpty()) {
                subDebug.debug("Simplified to:", new Object[0]);
                for (IConstraint newConstraint : newConstraints) {
                    subDebug.debug(" * {}", Solver.toString(newConstraint, unifier));
                }
            }
        }
        this.removeCompleteness(constraint);
        if (!updatedVars.isEmpty()) {
            this.releaseDelayedActions(updatedVars);
        }
        for (IConstraint newConstraint : newConstraints) {
            if (this.k(newConstraint, fuel - 1)) continue;
            return false;
        }
        return true;
    }

    private boolean delay(IConstraint constraint, Delay delay) throws InterruptedException {
        if (!delay.criticalEdges().isEmpty()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = delay.criticalEdges();
            objectArray[1] = constraint.toString(this.state.unifier()::toString);
            this.debug.error("FIXME: constraint failed on critical edges {}: {}", objectArray);
            return this.fail(constraint);
        }
        Set.Immutable vars = (Set.Immutable)delay.vars().stream().flatMap(v -> this.state.unifier().getVars((ITerm)v).stream()).collect(CapsuleCollectors.toSet());
        if (vars.isEmpty()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = delay.criticalEdges();
            objectArray[1] = constraint.toString(this.state.unifier()::toString);
            this.debug.error("FIXME: constraint delayed on no vars: {}", objectArray);
            return this.fail(constraint);
        }
        if (this.debug.isEnabled(Level.Debug)) {
            Object[] objectArray = new Object[2];
            objectArray[0] = vars;
            objectArray[1] = constraint.toString(this.state.unifier()::toString);
            this.debug.debug("constraint delayed on vars {}: {}", objectArray);
        }
        IDebugContext subDebug = this.debug.subContext();
        this.constraints.delay(constraint, delay);
        if (subDebug.isEnabled(Level.Debug)) {
            subDebug.debug("Delayed: {}", Solver.toString(constraint, this.state.unifier()));
        }
        return true;
    }

    private <R> boolean future(IConstraint constraint, IFuture<R> future, K<? super R> k) throws InterruptedException {
        this.pendingConstraints.__insert((Object)constraint);
        future.handle((r, ex) -> {
            this.pendingConstraints.__remove((Object)constraint);
            if (!this.result.isDone()) {
                this.solveK(k, (Object)r, (Throwable)ex);
            }
            return Unit.unit;
        });
        return true;
    }

    private boolean fail(IConstraint constraint) throws InterruptedException {
        IMessage message = MessageUtil.findClosestMessage(constraint);
        this.failed.put(constraint, message);
        this.removeCompleteness(constraint);
        return message.kind() != MessageKind.ERROR || (this.flags & 1) == 0;
    }

    private void removeCompleteness(IConstraint constraint) throws InterruptedException {
        ICompleteness.Transient _completeness = this.completeness.melt();
        if (!constraint.ownCriticalEdges().isPresent()) {
            throw new IllegalArgumentException("Solver only accepts constraints with pre-computed critical edges.");
        }
        Set.Immutable<CriticalEdge> removedEdges = _completeness.removeAll(constraint.ownCriticalEdges().get(), this.state.unifier());
        for (CriticalEdge criticalEdge : removedEdges) {
            this.closeEdge(criticalEdge);
        }
        this.completeness = _completeness.freeze();
    }

    private boolean queue(IConstraint constraint) {
        this.constraints.add(constraint);
        return true;
    }

    private boolean k(IConstraint constraint, final int fuel) throws InterruptedException {
        if (this.cancel.cancelled()) {
            throw new InterruptedException();
        }
        if (fuel <= 0) {
            return this.queue(constraint);
        }
        if (this.debug.isEnabled(Level.Debug)) {
            this.debug.debug("Solving {}", constraint.toString(Solver.shallowTermFormatter(this.state.unifier(), 4)));
        }
        return constraint.matchOrThrow(new IConstraint.CheckedCases<Boolean, InterruptedException>(){

            @Override
            public Boolean caseArith(CArith c) throws InterruptedException {
                IUniDisunifier.Immutable unifier = StatixSolver.this.state.unifier();
                Optional<ITerm> term1 = c.expr1().isTerm();
                Optional<ITerm> term2 = c.expr2().isTerm();
                try {
                    if (c.op().isEquals() && term1.isPresent()) {
                        int i2 = c.expr2().eval(unifier);
                        CEqual eq = new CEqual(term1.get(), (ITerm)TermBuild.B.newInt(i2), c);
                        return StatixSolver.this.success(c, StatixSolver.this.state, (Collection)NO_UPDATED_VARS, (Collection)ImmutableList.of((Object)eq), NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
                    }
                    if (c.op().isEquals() && term2.isPresent()) {
                        int i1 = c.expr1().eval(unifier);
                        CEqual eq = new CEqual((ITerm)TermBuild.B.newInt(i1), term2.get(), c);
                        return StatixSolver.this.success(c, StatixSolver.this.state, (Collection)NO_UPDATED_VARS, (Collection)ImmutableList.of((Object)eq), NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
                    }
                    int i1 = c.expr1().eval(unifier);
                    int i2 = c.expr2().eval(unifier);
                    if (c.op().test(i1, i2)) {
                        return StatixSolver.this.success(c, StatixSolver.this.state, (Collection)NO_UPDATED_VARS, (Collection)NO_NEW_CONSTRAINTS, NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
                    }
                    return StatixSolver.this.fail(c);
                }
                catch (Delay d) {
                    return StatixSolver.this.delay(c, d);
                }
            }

            @Override
            public Boolean caseConj(CConj c) throws InterruptedException {
                return StatixSolver.this.success(c, StatixSolver.this.state, (Collection)NO_UPDATED_VARS, Constraints.disjoin(c), NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
            }

            @Override
            public Boolean caseEqual(CEqual c) throws InterruptedException {
                ITerm term1 = c.term1();
                ITerm term2 = c.term2();
                IUniDisunifier.Immutable unifier = StatixSolver.this.state.unifier();
                try {
                    IUniDisunifier.Result result = unifier.unify(term1, term2, v -> StatixSolver.this.isRigid(v, StatixSolver.this.state)).orElse(null);
                    if (result != null) {
                        if (StatixSolver.this.debug.isEnabled(Level.Debug)) {
                            StatixSolver.this.debug.debug("Unification succeeded: {}", result.result());
                        }
                        IState.Immutable newState = StatixSolver.this.state.withUnifier(result.unifier());
                        Set.Immutable<ITermVar> updatedVars = ((IUnifier.Immutable)result.result()).domainSet();
                        return StatixSolver.this.success(c, newState, updatedVars, (Collection)NO_NEW_CONSTRAINTS, NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
                    }
                    if (StatixSolver.this.debug.isEnabled(Level.Debug)) {
                        StatixSolver.this.debug.debug("Unification failed: {} != {}", unifier.toString(term1), unifier.toString(term2));
                    }
                    return StatixSolver.this.fail(c);
                }
                catch (OccursException e) {
                    if (StatixSolver.this.debug.isEnabled(Level.Debug)) {
                        StatixSolver.this.debug.debug("Unification failed: {} != {}", unifier.toString(term1), unifier.toString(term2));
                    }
                    return StatixSolver.this.fail(c);
                }
                catch (RigidException e) {
                    return StatixSolver.this.delay(c, Delay.ofVars(e.vars()));
                }
            }

            @Override
            public Boolean caseExists(CExists c) throws InterruptedException {
                Renaming.Builder _existentials = Renaming.builder();
                IState.Immutable newState = StatixSolver.this.state;
                for (ITermVar var : c.vars()) {
                    Tuple2<ITermVar, IState.Immutable> varAndState = newState.freshVar(var);
                    ITermVar freshVar = varAndState._1();
                    newState = varAndState._2();
                    _existentials.put(var, freshVar);
                }
                Renaming existentials = _existentials.build();
                ISubstitution.Immutable subst = existentials.asSubstitution();
                IConstraint newConstraint = c.constraint().apply(subst).withCause(c.cause().orElse(null));
                if (!c.bodyCriticalEdges().isPresent()) {
                    throw new IllegalArgumentException("Solver only accepts constraints with pre-computed critical edges.");
                }
                ICompleteness.Immutable newCriticalEdges = c.bodyCriticalEdges().orElse(NO_NEW_CRITICAL_EDGES).apply(subst);
                return StatixSolver.this.success(c, newState, (Collection)NO_UPDATED_VARS, Constraints.disjoin(newConstraint), newCriticalEdges, existentials.asMap(), fuel);
            }

            @Override
            public Boolean caseFalse(CFalse c) throws InterruptedException {
                return StatixSolver.this.fail(c);
            }

            @Override
            public Boolean caseInequal(CInequal c) throws InterruptedException {
                ITerm term1 = c.term1();
                ITerm term2 = c.term2();
                IUniDisunifier.Immutable unifier = StatixSolver.this.state.unifier();
                try {
                    IUniDisunifier.Result result = unifier.disunify((Iterable<ITermVar>)c.universals(), term1, term2, v -> StatixSolver.this.isRigid(v, StatixSolver.this.state)).orElse(null);
                    if (result != null) {
                        if (StatixSolver.this.debug.isEnabled(Level.Debug)) {
                            StatixSolver.this.debug.debug("Disunification succeeded: {}", result);
                        }
                        IState.Immutable newState = StatixSolver.this.state.withUnifier(result.unifier());
                        java.util.Set updatedVars = ((Optional)result.result()).map(Diseq::domainSet).orElse((java.util.Set)NO_UPDATED_VARS);
                        return StatixSolver.this.success(c, newState, updatedVars, (Collection)NO_NEW_CONSTRAINTS, NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
                    }
                    if (StatixSolver.this.debug.isEnabled(Level.Debug)) {
                        StatixSolver.this.debug.debug("Disunification failed", new Object[0]);
                    }
                    return StatixSolver.this.fail(c);
                }
                catch (RigidException e) {
                    return StatixSolver.this.delay(c, Delay.ofVars(e.vars()));
                }
            }

            @Override
            public Boolean caseNew(CNew c) throws InterruptedException {
                ITerm scopeTerm = c.scopeTerm();
                ITerm datumTerm = c.datumTerm();
                String name = TermMatch.M.var(ITermVar::getName).match(scopeTerm).orElse("s");
                Set.Immutable labels = StatixSolver.this.getOpenEdges(scopeTerm);
                Scope scope = (Scope)StatixSolver.this.scopeGraph.freshScope(name, labels, true, false);
                StatixSolver.this.scopeGraph.setDatum(scope, datumTerm);
                CEqual eq = new CEqual(scopeTerm, (ITerm)scope, c);
                return StatixSolver.this.success(c, StatixSolver.this.state, (Collection)NO_UPDATED_VARS, (Collection)ImmutableList.of((Object)eq), NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
            }

            @Override
            public Boolean caseResolveQuery(IResolveQuery c) throws InterruptedException {
                IFuture<java.util.Set<IResolutionPath<Scope, ITerm, ITerm>>> future;
                QueryFilter filter = c.filter();
                final QueryMin min2 = c.min();
                ITerm scopeTerm = c.scopeTerm();
                ITerm resultTerm = c.resultTerm();
                IUniDisunifier.Immutable unifier = StatixSolver.this.state.unifier();
                Set.Immutable freeVars = (Set.Immutable)Streams.concat((Stream[])new Stream[]{unifier.getVars(scopeTerm).stream(), filter.getDataWF().freeVars().stream().flatMap(v -> unifier.getVars((ITerm)v).stream()), min2.getDataEquiv().freeVars().stream().flatMap(v -> unifier.getVars((ITerm)v).stream())}).collect(CapsuleCollectors.toSet());
                if (!freeVars.isEmpty()) {
                    return StatixSolver.this.delay(c, Delay.ofVars((Iterable<ITermVar>)freeVars));
                }
                Rule dataWfRule = RuleUtil.instantiateHeadPatterns(RuleUtil.closeInUnifier(filter.getDataWF(), StatixSolver.this.state.unifier(), ApplyMode.Safety.UNSAFE));
                Rule dataLeqRule = RuleUtil.instantiateHeadPatterns(RuleUtil.closeInUnifier(min2.getDataEquiv(), StatixSolver.this.state.unifier(), ApplyMode.Safety.UNSAFE));
                final Scope scope = AScope.matcher().match(scopeTerm, unifier).orElseThrow(() -> new IllegalArgumentException("Expected scope, got " + unifier.toString(scopeTerm)));
                final RegExpLabelWf<ITerm> labelWF = new RegExpLabelWf<ITerm>(filter.getLabelWF());
                final ConstraintDataWF dataWF = new ConstraintDataWF(StatixSolver.this.spec, dataWfRule);
                final ConstraintDataEquiv dataEquiv = new ConstraintDataEquiv(StatixSolver.this.spec, dataLeqRule);
                final ConstraintDataWFInternal dataWFInternal = new ConstraintDataWFInternal(dataWfRule);
                final ConstraintDataEquivInternal dataEquivInternal = new ConstraintDataEquivInternal(dataLeqRule);
                if ((StatixSolver.this.flags & 2) == 0) {
                    future = c.match(new IResolveQuery.Cases<IFuture<? extends java.util.Set<IResolutionPath<Scope, ITerm, ITerm>>>>(){

                        @Override
                        public IFuture<? extends java.util.Set<IResolutionPath<Scope, ITerm, ITerm>>> caseResolveQuery(CResolveQuery q) {
                            RelationLabelOrder labelOrder = new RelationLabelOrder(min2.getLabelOrder());
                            return StatixSolver.this.scopeGraph.query(scope, labelWF, labelOrder, dataWF, dataEquiv, dataWFInternal, dataEquivInternal);
                        }

                        @Override
                        public IFuture<? extends java.util.Set<IResolutionPath<Scope, ITerm, ITerm>>> caseCompiledQuery(CCompiledQuery q) {
                            return StatixSolver.this.scopeGraph.query(scope, q.stateMachine(), dataWF, dataEquiv, dataWFInternal, dataEquivInternal);
                        }
                    });
                } else {
                    RelationLabelOrder labelOrder = new RelationLabelOrder(min2.getLabelOrder());
                    future = StatixSolver.this.scopeGraph.query(scope, labelWF, labelOrder, dataWF, dataEquiv, dataWFInternal, dataEquivInternal);
                }
                K<java.util.Set> k = (paths, ex, fuel) -> {
                    if (ex != null) {
                        try {
                            throw ex;
                        }
                        catch (ResolutionDelayException rde) {
                            if (StatixSolver.this.debug.isEnabled(Level.Debug)) {
                                Object[] objectArray = new Object[1];
                                objectArray[0] = c.toString(StatixSolver.this.state.unifier()::toString);
                                StatixSolver.this.debug.debug("delayed query (unsupported) {}", rde, objectArray);
                            }
                            return StatixSolver.this.fail(c);
                        }
                        catch (DeadlockException dle) {
                            if (StatixSolver.this.debug.isEnabled(Level.Debug)) {
                                Object[] objectArray = new Object[1];
                                objectArray[0] = c.toString(StatixSolver.this.state.unifier()::toString);
                                StatixSolver.this.debug.debug("deadlocked query (spec error) {}", objectArray);
                            }
                            return StatixSolver.this.fail(c);
                        }
                        catch (InterruptedException t) {
                            throw t;
                        }
                        catch (Throwable t) {
                            Object[] objectArray = new Object[1];
                            objectArray[0] = c.toString(StatixSolver.this.state.unifier()::toString);
                            StatixSolver.this.debug.error("failed query {}", t, objectArray);
                            return StatixSolver.this.fail(c);
                        }
                    }
                    List pathTerms = (List)paths.stream().map(p -> StatixTerms.pathToTerm(p, StatixSolver.this.spec.dataLabels())).collect(ImmutableList.toImmutableList());
                    CEqual C2 = new CEqual(resultTerm, (ITerm)TermBuild.B.newList(pathTerms), c);
                    return StatixSolver.this.success(c, StatixSolver.this.state, (Collection)NO_UPDATED_VARS, (Collection)ImmutableList.of((Object)C2), NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
                };
                return StatixSolver.this.future(c, future, k);
            }

            @Override
            public Boolean caseTellEdge(CTellEdge c) throws InterruptedException {
                ITerm sourceTerm = c.sourceTerm();
                ITerm label = c.label();
                ITerm targetTerm = c.targetTerm();
                IUniDisunifier.Immutable unifier = StatixSolver.this.state.unifier();
                if (!unifier.isGround(sourceTerm)) {
                    return StatixSolver.this.delay(c, Delay.ofVars(unifier.getVars(sourceTerm)));
                }
                if (!unifier.isGround(targetTerm)) {
                    return StatixSolver.this.delay(c, Delay.ofVars(unifier.getVars(targetTerm)));
                }
                Scope source = AScope.matcher().match(sourceTerm, unifier).orElseThrow(() -> new IllegalArgumentException("Expected source scope, got " + unifier.toString(sourceTerm)));
                Scope target = AScope.matcher().match(targetTerm, unifier).orElseThrow(() -> new IllegalArgumentException("Expected target scope, got " + unifier.toString(targetTerm)));
                StatixSolver.this.scopeGraph.addEdge(source, label, target);
                return StatixSolver.this.success(c, StatixSolver.this.state, (Collection)NO_UPDATED_VARS, (Collection)NO_NEW_CONSTRAINTS, NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
            }

            @Override
            public Boolean caseTermId(CAstId c) throws InterruptedException {
                ITerm term = c.astTerm();
                ITerm idTerm = c.idTerm();
                IUniDisunifier.Immutable unifier = StatixSolver.this.state.unifier();
                if (!unifier.isGround(term)) {
                    return StatixSolver.this.delay(c, Delay.ofVars(unifier.getVars(term)));
                }
                Optional<Scope> maybeScope = AScope.matcher().match(term, unifier);
                if (maybeScope.isPresent()) {
                    AScope scope = maybeScope.get();
                    CEqual eq = new CEqual(idTerm, scope);
                    return StatixSolver.this.success(c, StatixSolver.this.state, (Collection)NO_UPDATED_VARS, (Collection)ImmutableList.of((Object)eq), NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
                }
                Optional<TermIndex> maybeIndex = TermIndex.find(unifier.findTerm(term));
                if (maybeIndex.isPresent()) {
                    TermIndex indexTerm = TermOrigin.copy(term, maybeIndex.get());
                    CEqual eq = new CEqual(idTerm, indexTerm);
                    return StatixSolver.this.success(c, StatixSolver.this.state, (Collection)NO_UPDATED_VARS, (Collection)ImmutableList.of((Object)eq), NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
                }
                return StatixSolver.this.fail(c);
            }

            @Override
            public Boolean caseTermProperty(CAstProperty c) throws InterruptedException {
                ITerm idTerm = c.idTerm();
                ITerm prop = c.property();
                ITerm value = c.value();
                IUniDisunifier.Immutable unifier = StatixSolver.this.state.unifier();
                if (!unifier.isGround(idTerm)) {
                    return StatixSolver.this.delay(c, Delay.ofVars(unifier.getVars(idTerm)));
                }
                Optional<TermIndex> maybeIndex = TermIndex.matcher().match(idTerm, unifier);
                if (maybeIndex.isPresent()) {
                    ITermProperty property;
                    TermIndex index = maybeIndex.get();
                    Tuple2<TermIndex, ITerm> key = Tuple2.of(index, prop);
                    switch (c.op()) {
                        case ADD: {
                            property = (ITermProperty)StatixSolver.this.state.termProperties().getOrDefault(key, (Object)BagTermProperty.of());
                            if (!property.multiplicity().equals((Object)ITermProperty.Multiplicity.BAG)) {
                                return StatixSolver.this.fail(c);
                            }
                            property = property.addValue(value);
                            break;
                        }
                        case SET: {
                            if (StatixSolver.this.state.termProperties().containsKey(key)) {
                                ITermProperty property2 = (ITermProperty)StatixSolver.this.state.termProperties().get(key);
                                if (property2.multiplicity().equals((Object)ITermProperty.Multiplicity.SINGLETON) && property2.value().equals(value) && property2.value().getAttachments().equals(value.getAttachments())) {
                                    return StatixSolver.this.success(c, StatixSolver.this.state, (Collection)NO_UPDATED_VARS, (Collection)NO_NEW_CONSTRAINTS, NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
                                }
                                return StatixSolver.this.fail(c);
                            }
                            property = SingletonTermProperty.of(value);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown op " + (Object)((Object)c.op()));
                        }
                    }
                    IState.Immutable newState = StatixSolver.this.state.withTermProperties((Map.Immutable<Tuple2<TermIndex, ITerm>, ITermProperty>)StatixSolver.this.state.termProperties().__put(key, (Object)property));
                    return StatixSolver.this.success(c, newState, (Collection)NO_UPDATED_VARS, (Collection)NO_NEW_CONSTRAINTS, NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
                }
                return StatixSolver.this.fail(c);
            }

            @Override
            public Boolean caseTrue(CTrue c) throws InterruptedException {
                return StatixSolver.this.success(c, StatixSolver.this.state, (Collection)NO_UPDATED_VARS, (Collection)NO_NEW_CONSTRAINTS, NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
            }

            @Override
            public Boolean caseTry(CTry c) throws InterruptedException {
                IDebugContext subDebug = StatixSolver.this.debug.subContext();
                ITypeCheckerContext<Scope, ITerm, ITerm> subContext = StatixSolver.this.scopeGraph.subContext("try");
                IState.Immutable subState = StatixSolver.this.state.subState().withResource(subContext.id());
                StatixSolver subSolver = new StatixSolver(c.constraint(), StatixSolver.this.spec, subState, StatixSolver.this.completeness, subDebug, StatixSolver.this.progress, StatixSolver.this.cancel, subContext, 1);
                IFuture<SolverResult> subResult = subSolver.entail();
                K<SolverResult> k = (r, ex, fuel) -> {
                    if (ex != null) {
                        Object[] objectArray = new Object[1];
                        objectArray[0] = c.toString(StatixSolver.this.state.unifier()::toString);
                        StatixSolver.this.debug.error("try {} failed", ex, objectArray);
                        return StatixSolver.this.fail(c);
                    }
                    try {
                        if (Solver.entailed(subState, r, subDebug)) {
                            if (StatixSolver.this.debug.isEnabled(Level.Debug)) {
                                Object[] objectArray = new Object[1];
                                objectArray[0] = c.toString(StatixSolver.this.state.unifier()::toString);
                                StatixSolver.this.debug.debug("constraint {} entailed", objectArray);
                            }
                            return StatixSolver.this.success(c, StatixSolver.this.state, (Collection)NO_UPDATED_VARS, (Collection)NO_NEW_CONSTRAINTS, NO_NEW_CRITICAL_EDGES, (Map)NO_EXISTENTIALS, fuel);
                        }
                        if (StatixSolver.this.debug.isEnabled(Level.Debug)) {
                            Object[] objectArray = new Object[1];
                            objectArray[0] = c.toString(StatixSolver.this.state.unifier()::toString);
                            StatixSolver.this.debug.debug("constraint {} not entailed", objectArray);
                        }
                        return StatixSolver.this.fail(c);
                    }
                    catch (Delay delay) {
                        return StatixSolver.this.delay(c, delay);
                    }
                };
                return StatixSolver.this.future(c, subResult, k);
            }

            @Override
            public Boolean caseUser(CUser c) throws InterruptedException {
                String name = c.name();
                List<ITerm> args = c.args();
                LazyDebugContext proxyDebug = new LazyDebugContext(StatixSolver.this.debug);
                ImmutableList<Rule> rules = StatixSolver.this.spec.rules().getRules(name);
                Tuple3 result = RuleUtil.applyOrderedOne(StatixSolver.this.state.unifier(), rules, args, c, ApplyMode.RELAXED, ApplyMode.Safety.UNSAFE).orElse(null);
                if (result == null) {
                    StatixSolver.this.debug.debug("No rule applies", new Object[0]);
                    return StatixSolver.this.fail(c);
                }
                ApplyResult applyResult = (ApplyResult)result._2();
                if (!((Boolean)result._3()).booleanValue()) {
                    Set stuckVars = (Set)Streams.stream(applyResult.guard()).flatMap(g -> g.domainSet().stream()).collect(CapsuleCollectors.toSet());
                    proxyDebug.debug("Rule delayed (multiple conditional matches)", new Object[0]);
                    return StatixSolver.this.delay(c, Delay.ofVars((Iterable<ITermVar>)stuckVars));
                }
                proxyDebug.debug("Rule accepted", new Object[0]);
                proxyDebug.commit();
                if (applyResult.criticalEdges() == null) {
                    throw new IllegalArgumentException("Solver only accepts specs with pre-computed critical edges.");
                }
                return StatixSolver.this.success(c, StatixSolver.this.state, (Collection)NO_UPDATED_VARS, Collections.singletonList(applyResult.body()), applyResult.criticalEdges(), (Map)NO_EXISTENTIALS, fuel);
            }
        });
    }

    private static IFuture<Boolean> entails(ITypeCheckerContext<Scope, ITerm, ITerm> context, Spec spec, IState.Immutable state, IConstraint constraint, ICompleteness.Immutable criticalEdges, IDebugContext debug, ICancel cancel, IProgress progress) throws Delay {
        IDebugContext subDebug = debug.subContext();
        ITypeCheckerContext<Scope, ITerm, ITerm> subContext = context.subContext("entails");
        IState.Immutable subState = state.subState().withResource(subContext.id());
        Solver.PreSolveResult preSolveResult = Solver.preEntail(subState, criticalEdges, constraint).orElse(null);
        if (preSolveResult == null) {
            return CompletableFuture.completedFuture(false);
        }
        if (preSolveResult.constraints.isEmpty()) {
            return CompletableFuture.completedFuture(Solver.entailed(subState, preSolveResult, subDebug));
        }
        StatixSolver subSolver = new StatixSolver(Constraints.conjoin(preSolveResult.constraints), spec, preSolveResult.state, preSolveResult.criticalEdges, subDebug, progress, cancel, subContext, 1);
        return subSolver.entail().thenCompose(r -> {
            boolean result;
            try {
                if (Solver.entailed(subState, r, subDebug)) {
                    if (debug.isEnabled(Level.Debug)) {
                        Object[] objectArray = new Object[1];
                        objectArray[0] = constraint.toString(state.unifier()::toString);
                        debug.debug("constraint {} entailed", objectArray);
                    }
                    result = true;
                } else {
                    if (debug.isEnabled(Level.Debug)) {
                        Object[] objectArray = new Object[1];
                        objectArray[0] = constraint.toString(state.unifier()::toString);
                        debug.debug("constraint {} not entailed", objectArray);
                    }
                    result = false;
                }
            }
            catch (Delay delay) {
                throw new IllegalStateException("Unexpected delay.", delay);
            }
            return CompletableFuture.completedFuture(result);
        });
    }

    private IFuture<Boolean> entails(ITypeCheckerContext<Scope, ITerm, ITerm> subContext, IConstraint constraint, ICompleteness.Immutable criticalEdges, ICancel cancel) {
        IDebugContext subDebug = this.debug.subContext();
        return this.absorbDelays(() -> {
            Solver.PreSolveResult preSolveResult;
            IState.Immutable subState = this.state.subState().withResource(subContext.id());
            try {
                preSolveResult = Solver.preEntail(subState, criticalEdges, constraint).orElse(null);
                if (preSolveResult == null) {
                    return CompletableFuture.completedFuture(false);
                }
            }
            catch (Delay d) {
                return CompletableFuture.completedExceptionally(d);
            }
            if (preSolveResult.constraints.isEmpty()) {
                return CompletableFuture.completedFuture(Solver.entailed(subState, preSolveResult, subDebug));
            }
            StatixSolver subSolver = new StatixSolver(Constraints.conjoin(preSolveResult.constraints), this.spec, preSolveResult.state, preSolveResult.criticalEdges, subDebug, this.progress, cancel, subContext, 1);
            return subSolver.entail().thenCompose(r -> {
                boolean result;
                if (Solver.entailed(subState, r, subDebug)) {
                    if (this.debug.isEnabled(Level.Debug)) {
                        Object[] objectArray = new Object[1];
                        objectArray[0] = constraint.toString(this.state.unifier()::toString);
                        this.debug.debug("constraint {} entailed", objectArray);
                    }
                    result = true;
                } else {
                    if (this.debug.isEnabled(Level.Debug)) {
                        Object[] objectArray = new Object[1];
                        objectArray[0] = constraint.toString(this.state.unifier()::toString);
                        this.debug.debug("constraint {} not entailed", objectArray);
                    }
                    result = false;
                }
                return CompletableFuture.completedFuture(result);
            });
        });
    }

    private <T> IFuture<T> absorbDelays(Function0<IFuture<T>> f) {
        return f.apply().compose((r, ex) -> {
            if (ex != null) {
                try {
                    throw ex;
                }
                catch (Delay delay) {
                    if (!delay.criticalEdges().isEmpty()) {
                        this.debug.error("unsupported delay with critical edges {}", delay, new Object[0]);
                        throw new IllegalStateException("unsupported delay with critical edges");
                    }
                    if (delay.vars().isEmpty()) {
                        this.debug.error("unsupported delay without variables {}", delay, new Object[0]);
                        throw new IllegalStateException("unsupported delay without variables");
                    }
                    CompletableFuture result = new CompletableFuture();
                    try {
                        this.delayAction(() -> this.absorbDelays(f).whenComplete(result::complete), (Iterable<ITermVar>)delay.vars());
                    }
                    catch (InterruptedException ie) {
                        result.completeExceptionally(ie);
                    }
                    return result;
                }
                catch (Throwable t) {
                    return CompletableFuture.completedExceptionally(t);
                }
            }
            return CompletableFuture.completedFuture(r);
        });
    }

    private Set.Immutable<ITerm> getOpenEdges(ITerm varOrScope) {
        List openEdges = Streams.stream(this.completeness.get(varOrScope, this.state.unifier())).collect(Collectors.toList());
        List queuedEdges = TermMatch.M.var().match(varOrScope).map(var -> this.delayedCloses.stream().filter(e -> this.state.unifier().equal((ITerm)var, e.scope())).map(e -> e.edgeOrData())).orElse(Stream.empty()).collect(Collectors.toList());
        return (Set.Immutable)Streams.stream((Iterable)Iterables.concat(openEdges, queuedEdges)).flatMap(eod -> eod.match(() -> Stream.empty(), l -> Stream.of(l))).collect(CapsuleCollectors.toSet());
    }

    private void closeEdge(CriticalEdge criticalEdge) throws InterruptedException {
        if (this.debug.isEnabled(Level.Debug)) {
            this.debug.debug("client {} close edge {}/{}", this, this.state.unifier().toString(criticalEdge.scope()), criticalEdge.edgeOrData());
        }
        this.delayedCloses.__insert((Object)criticalEdge);
        this.delayAction(() -> {
            this.delayedCloses.__remove((Object)criticalEdge);
            this.closeGroundEdge(criticalEdge);
        }, (Iterable<ITermVar>)this.state.unifier().getVars(criticalEdge.scope()));
    }

    private void closeGroundEdge(CriticalEdge criticalEdge) {
        if (this.debug.isEnabled(Level.Debug)) {
            this.debug.debug("client {} close edge {}/{}", this, this.state.unifier().toString(criticalEdge.scope()), criticalEdge.edgeOrData());
        }
        Scope scope = Scope.matcher().match(criticalEdge.scope(), this.state.unifier()).orElseThrow(() -> new IllegalArgumentException("Expected scope, got " + this.state.unifier().toString(criticalEdge.scope())));
        criticalEdge.edgeOrData().match(() -> Unit.unit, label -> {
            this.scopeGraph.closeEdge(scope, (ITerm)label);
            return Unit.unit;
        });
    }

    private void delayAction(CheckedAction0<InterruptedException> action, Iterable<ITermVar> vars) throws InterruptedException {
        Set.Immutable foreignVars = (Set.Immutable)Streams.stream(vars).filter(v -> !this.state.vars().contains(v)).collect(CapsuleCollectors.toSet());
        if (!foreignVars.isEmpty()) {
            throw new IllegalStateException("Cannot delay on foreign variables: " + foreignVars);
        }
        if (!this.delayedActions.put(action, vars, this.state.unifier())) {
            action.apply();
        }
    }

    private void releaseDelayedActions(Iterable<ITermVar> updatedVars) throws InterruptedException {
        for (CheckedAction0 action : this.delayedActions.update(updatedVars, (IUnifier)this.state.unifier())) {
            action.apply();
        }
    }

    public IFuture<ITerm> getExternalRepresentation(ITerm t) {
        CompletableFuture<ITerm> f = new CompletableFuture<ITerm>();
        try {
            this.delayAction(() -> f.complete(this.state.unifier().findRecursive(t)), (Iterable<ITermVar>)this.state.unifier().getVars(t));
        }
        catch (InterruptedException ex) {
            f.completeExceptionally(ex);
        }
        return f;
    }

    public ITerm internalData(ITerm datum) {
        return this.state.unifier().findRecursive(datum);
    }

    public SolverState snapshot() {
        SolverState.Builder builder = SolverState.builder();
        builder.state(this.state);
        builder.completeness(this.completeness);
        builder.addAllConstraints(this.constraints.active());
        builder.addAllConstraints((Iterable<? extends IConstraint>)this.pendingConstraints);
        builder.addAllConstraints(this.constraints.delayed().keySet());
        builder.existentials(this.existentials);
        builder.updatedVars(this.updatedVars);
        builder.failed(this.failed);
        Set.Immutable closes = this.delayedCloses.freeze();
        this.delayedCloses = closes.asTransient();
        builder.delayedCloses((Set.Immutable<CriticalEdge>)closes);
        return builder.build();
    }

    private boolean isRigid(ITermVar var, IState state) {
        return !state.vars().contains((Object)var);
    }

    public String toString() {
        return "StatixSolver";
    }

    private static class ConstraintDataEquiv
    implements DataLeq<Scope, ITerm, ITerm>,
    Serializable {
        private static final long serialVersionUID = 42L;
        private final Spec spec;
        private final Rule constraint;
        private final IState.Immutable state;
        @Nullable
        private transient IFuture<Boolean> alwaysTrue;
        private volatile int hashCode = 0;

        public ConstraintDataEquiv(Spec spec, Rule constraint) {
            this.spec = spec;
            this.constraint = constraint;
            this.state = State.of();
        }

        @Override
        public IFuture<Boolean> leq(ITerm datum1, ITerm datum2, ITypeCheckerContext<Scope, ITerm, ITerm> context, ICancel cancel) throws InterruptedException {
            try {
                ApplyResult applyResult = RuleUtil.apply(this.state.unifier(), this.constraint, (List<? extends ITerm>)ImmutableList.of((Object)datum1, (Object)datum2), null, ApplyMode.STRICT, ApplyMode.Safety.UNSAFE).orElse(null);
                if (applyResult == null) {
                    return CompletableFuture.completedFuture(false);
                }
                return StatixSolver.entails(context, this.spec, this.state, applyResult.body(), applyResult.criticalEdges(), new NullDebugContext(), cancel, new NullProgress());
            }
            catch (Delay e) {
                throw new IllegalStateException("Unexpected delay.", e);
            }
        }

        @Override
        public IFuture<Boolean> alwaysTrue(ITypeCheckerContext<Scope, ITerm, ITerm> context, ICancel cancel) {
            if (this.alwaysTrue == null) {
                try {
                    switch (SHADOW_OPTIMIZATION) {
                        case CONTEXT: {
                            Boolean isAlways = this.constraint.isAlways().orElse(null);
                            if (isAlways != null) {
                                this.alwaysTrue = CompletableFuture.completedFuture(isAlways);
                                break;
                            }
                            Tuple2<ITermVar, IState.Immutable> d1_state = this.state.freshVar(TermBuild.B.newVar(this.state.resource(), "d1"));
                            Tuple2<ITermVar, IState.Immutable> d2_state = d1_state._2().freshVar(TermBuild.B.newVar(this.state.resource(), "d2"));
                            try {
                                ApplyResult result = RuleUtil.apply(d2_state._2().unifier(), this.constraint, (List<? extends ITerm>)ImmutableList.of((Object)d1_state._1(), (Object)d2_state._1()), null, ApplyMode.STRICT, ApplyMode.Safety.UNSAFE).orElse(null);
                                if (result == null) {
                                    this.alwaysTrue = CompletableFuture.completedFuture(false);
                                    break;
                                }
                                this.alwaysTrue = StatixSolver.entails(context, this.spec, d2_state._2(), result.body(), result.criticalEdges(), new NullDebugContext(), cancel, new NullProgress());
                                break;
                            }
                            catch (Delay e) {
                                throw new IllegalStateException("Unexpected delay.", e);
                            }
                        }
                        case RULE: {
                            this.alwaysTrue = CompletableFuture.completedFuture(this.constraint.isAlways().orElse(false));
                            break;
                        }
                        default: {
                            this.alwaysTrue = CompletableFuture.completedFuture(false);
                            break;
                        }
                    }
                }
                catch (InterruptedException e) {
                    return CompletableFuture.completedExceptionally(e);
                }
            }
            return this.alwaysTrue;
        }

        public String toString() {
            return this.constraint.toString(this.state.unifier()::toString);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ConstraintDataEquiv other = (ConstraintDataEquiv)obj;
            int h = this.hashCode;
            int oh = other.hashCode;
            if (h != oh && h != 0 && oh != 0) {
                return false;
            }
            return this.constraint.equals(other.constraint);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = this.constraint.hashCode();
            }
            return result;
        }
    }

    private class ConstraintDataEquivInternal
    implements DataLeq<Scope, ITerm, ITerm> {
        private final Rule constraint;
        @Nullable
        private transient IFuture<Boolean> alwaysTrue;

        public ConstraintDataEquivInternal(Rule constraint) {
            this.constraint = constraint;
        }

        @Override
        public IFuture<Boolean> leq(ITerm datum1, ITerm datum2, ITypeCheckerContext<Scope, ITerm, ITerm> context, ICancel cancel) throws InterruptedException {
            return StatixSolver.this.absorbDelays(() -> {
                try {
                    ApplyResult applyResult = RuleUtil.apply(StatixSolver.this.state.unifier(), this.constraint, (List<? extends ITerm>)ImmutableList.of((Object)datum1, (Object)datum2), null, ApplyMode.STRICT, ApplyMode.Safety.UNSAFE).orElse(null);
                    if (applyResult == null) {
                        return CompletableFuture.completedFuture(false);
                    }
                    return StatixSolver.this.entails(context, applyResult.body(), applyResult.criticalEdges(), cancel);
                }
                catch (Delay delay) {
                    return CompletableFuture.completedExceptionally(delay);
                }
            });
        }

        @Override
        public IFuture<Boolean> alwaysTrue(ITypeCheckerContext<Scope, ITerm, ITerm> context, ICancel cancel) {
            if (this.alwaysTrue == null) {
                try {
                    switch (SHADOW_OPTIMIZATION) {
                        case CONTEXT: {
                            Boolean isAlways = this.constraint.isAlways().orElse(null);
                            if (isAlways != null) {
                                this.alwaysTrue = CompletableFuture.completedFuture(isAlways);
                                break;
                            }
                            this.alwaysTrue = StatixSolver.this.absorbDelays(() -> {
                                try {
                                    Tuple2<ITermVar, IState.Immutable> d1_state = StatixSolver.this.state.freshVar(TermBuild.B.newVar(StatixSolver.this.state.resource(), "d1"));
                                    Tuple2<ITermVar, IState.Immutable> d2_state = d1_state._2().freshVar(TermBuild.B.newVar(StatixSolver.this.state.resource(), "d2"));
                                    ApplyResult result = RuleUtil.apply(d2_state._2().unifier(), this.constraint, (List<? extends ITerm>)ImmutableList.of((Object)d1_state._1(), (Object)d2_state._1()), null, ApplyMode.STRICT, ApplyMode.Safety.UNSAFE).orElse(null);
                                    if (result == null) {
                                        return CompletableFuture.completedFuture(false);
                                    }
                                    return StatixSolver.entails(context, StatixSolver.this.spec, StatixSolver.this.state, result.body(), result.criticalEdges(), new NullDebugContext(), cancel, new NullProgress());
                                }
                                catch (Delay delay) {
                                    return CompletableFuture.completedExceptionally(delay);
                                }
                            });
                            break;
                        }
                        case RULE: {
                            this.alwaysTrue = CompletableFuture.completedFuture(this.constraint.isAlways().orElse(false));
                            break;
                        }
                        default: {
                            this.alwaysTrue = CompletableFuture.completedFuture(false);
                            break;
                        }
                    }
                }
                catch (InterruptedException e) {
                    return CompletableFuture.completedExceptionally(e);
                }
            }
            return this.alwaysTrue;
        }

        public String toString() {
            return this.constraint.toString(StatixSolver.this.state.unifier()::toString);
        }
    }

    private static class ConstraintDataWF
    implements DataWf<Scope, ITerm, ITerm>,
    Serializable {
        private static final long serialVersionUID = 42L;
        private final Spec spec;
        private final Rule constraint;
        private final IState.Immutable state;
        private Set.Immutable<Scope> scopes;
        private volatile int hashCode = 0;

        public ConstraintDataWF(Spec spec, Rule constraint) {
            this.spec = spec;
            this.constraint = constraint;
            this.state = State.of();
        }

        @Override
        public IFuture<Boolean> wf(ITerm datum, ITypeCheckerContext<Scope, ITerm, ITerm> context, ICancel cancel) throws InterruptedException {
            try {
                ApplyResult applyResult = RuleUtil.apply(this.state.unifier(), this.constraint, (List<? extends ITerm>)ImmutableList.of((Object)datum), null, ApplyMode.STRICT, ApplyMode.Safety.UNSAFE).orElse(null);
                if (applyResult == null) {
                    return CompletableFuture.completedFuture(false);
                }
                return StatixSolver.entails(context, this.spec, this.state, applyResult.body(), applyResult.criticalEdges(), new NullDebugContext(), cancel, new NullProgress());
            }
            catch (Delay e) {
                throw new IllegalStateException("Unexpected delay.", e);
            }
        }

        @Override
        public Set.Immutable<Scope> scopes() {
            Set.Immutable<Scope> result = this.scopes;
            if (result == null) {
                this.scopes = result = Patching.ruleScopes(this.constraint);
            }
            return result;
        }

        @Override
        public DataWf<Scope, ITerm, ITerm> patch(IPatchCollection.Immutable<Scope> patches) {
            Rule newRule = Patching.patch(this.constraint, patches);
            if (newRule == null) {
                return this;
            }
            return new ConstraintDataWF(this.spec, newRule);
        }

        public String toString() {
            return this.constraint.toString();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ConstraintDataWF other = (ConstraintDataWF)obj;
            int h = this.hashCode;
            int oh = other.hashCode;
            if (h != oh && h != 0 && oh != 0) {
                return false;
            }
            return this.constraint.equals(other.constraint);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = this.constraint.hashCode();
            }
            return result;
        }
    }

    private class ConstraintDataWFInternal
    implements DataWf<Scope, ITerm, ITerm> {
        private final Rule constraint;

        public ConstraintDataWFInternal(Rule constraint) {
            this.constraint = constraint;
        }

        @Override
        public IFuture<Boolean> wf(ITerm datum, ITypeCheckerContext<Scope, ITerm, ITerm> context, ICancel cancel) throws InterruptedException {
            return StatixSolver.this.absorbDelays(() -> {
                try {
                    ApplyResult applyResult = RuleUtil.apply(StatixSolver.this.state.unifier(), this.constraint, (List<? extends ITerm>)ImmutableList.of((Object)datum), null, ApplyMode.STRICT, ApplyMode.Safety.UNSAFE).orElse(null);
                    if (applyResult == null) {
                        return CompletableFuture.completedFuture(false);
                    }
                    return StatixSolver.this.entails(context, applyResult.body(), applyResult.criticalEdges(), cancel);
                }
                catch (Delay delay) {
                    return CompletableFuture.completedExceptionally(delay);
                }
            });
        }

        public String toString() {
            return this.constraint.toString(StatixSolver.this.state.unifier()::toString);
        }
    }

    @FunctionalInterface
    private static interface K<R> {
        public boolean k(R var1, Throwable var2, int var3) throws InterruptedException;
    }

    private static enum ShadowOptimization {
        NONE,
        RULE,
        CONTEXT;

    }
}

