/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent;

import com.google.common.collect.ImmutableList;
import io.usethesource.capsule.Set;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.matching.Transform;
import mb.p_raffrayi.IScopeGraphLibrary;
import mb.scopegraph.oopsla20.IScopeGraph;
import mb.scopegraph.oopsla20.reference.ScopeGraph;
import mb.statix.concurrent.IStatixLibrary;
import mb.statix.scopegraph.Scope;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.tuple.Tuple2;

public class StatixLibrary
implements IStatixLibrary,
IScopeGraphLibrary<Scope, ITerm, ITerm> {
    private final List<Scope> rootScopes;
    private final Set<Scope> ownScopes;
    private final IScopeGraph.Immutable<Scope, ITerm, ITerm> scopeGraph;

    public StatixLibrary(List<Scope> rootScopes, Collection<Scope> ownScopes, IScopeGraph.Immutable<Scope, ITerm, ITerm> scopeGraph) {
        this.rootScopes = ImmutableList.copyOf(rootScopes);
        this.ownScopes = CapsuleUtil.toSet(ownScopes);
        this.scopeGraph = scopeGraph;
    }

    @Override
    public List<Scope> rootScopes() {
        return this.rootScopes;
    }

    @Override
    public Set<Scope> ownScopes() {
        return this.ownScopes;
    }

    @Override
    public IScopeGraph.Immutable<Scope, ITerm, ITerm> scopeGraph() {
        return this.scopeGraph;
    }

    @Override
    public Tuple2<Set.Immutable<Scope>, IScopeGraph.Immutable<Scope, ITerm, ITerm>> initialize(List<Scope> rootScopes, Function1<String, Scope> freshScope) {
        Scope scope;
        Set.Immutable<ITerm> edgeLabels = this.scopeGraph.getLabels();
        HashMap<Scope, Scope> scopeMap = new HashMap<Scope, Scope>();
        Set.Transient ownScopes = CapsuleUtil.transientSet();
        ScopeGraph.Transient<Scope, ITerm, ITerm> scopeGraph = ScopeGraph.Transient.of();
        if (this.rootScopes.size() != rootScopes.size()) {
            throw new IllegalArgumentException("Number of root scopes does not match.");
        }
        int i = 0;
        while (i < rootScopes.size()) {
            Scope libRootScope = this.rootScopes.get(i);
            if (!scopeMap.containsKey(libRootScope)) {
                Scope rootScope = rootScopes.get(i);
                scopeMap.put(libRootScope, rootScope);
            }
            ++i;
        }
        for (Scope libScope : this.ownScopes) {
            if (scopeMap.containsKey(libScope)) {
                throw new IllegalStateException("Scope already initialized.");
            }
            scope = freshScope.apply(libScope.getName());
            ownScopes.__insert((Object)scope);
            scopeMap.put(libScope, scope);
        }
        for (Scope libScope : this.rootScopes) {
            scope = (Scope)scopeMap.get(libScope);
            for (ITerm label : edgeLabels) {
                for (Scope libTarget : this.scopeGraph.getEdges(libScope, label)) {
                    Scope target = (Scope)scopeMap.get(libTarget);
                    scopeGraph.addEdge(scope, label, target);
                }
            }
        }
        for (Scope libScope : this.ownScopes) {
            scope = (Scope)scopeMap.get(libScope);
            ITerm libDatum = this.scopeGraph.getData(libScope).orElse(null);
            if (libDatum != null) {
                ITerm datum = StatixLibrary.substituteScopes(libDatum, scopeMap);
                scopeGraph.setDatum(scope, datum);
            }
            for (ITerm label : edgeLabels) {
                for (Scope libTarget : this.scopeGraph.getEdges(libScope, label)) {
                    Scope target = (Scope)scopeMap.get(libTarget);
                    scopeGraph.addEdge(scope, label, target);
                }
            }
        }
        return Tuple2.of(ownScopes.freeze(), scopeGraph.freeze());
    }

    private static ITerm substituteScopes(ITerm datum, Map<Scope, Scope> substitution) {
        return Transform.T.sometd(Scope.matcher().map(s -> substitution.getOrDefault(s, (Scope)s))::match).apply(datum);
    }
}

