/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import mb.statix.concurrent.AStatixGroup;
import mb.statix.concurrent.IStatixGroup;
import mb.statix.concurrent.IStatixUnit;
import mb.statix.spec.Rule;

public final class StatixGroup
extends AStatixGroup {
    private final String resource;
    private final ImmutableList<String> scopeNames;
    private final Rule rule;
    private final boolean changed;
    private final ImmutableMap<String, IStatixGroup> groups;
    private final ImmutableMap<String, IStatixUnit> units;
    private transient int hashCode;

    private StatixGroup(String resource, Iterable<String> scopeNames, Optional<? extends Rule> rule, boolean changed, Map<String, ? extends IStatixGroup> groups, Map<String, ? extends IStatixUnit> units) {
        this.resource = Objects.requireNonNull(resource, "resource");
        this.scopeNames = ImmutableList.copyOf(scopeNames);
        this.rule = rule.orElse(null);
        this.changed = changed;
        this.groups = ImmutableMap.copyOf(groups);
        this.units = ImmutableMap.copyOf(units);
    }

    private StatixGroup(StatixGroup original, String resource, ImmutableList<String> scopeNames, Rule rule, boolean changed, ImmutableMap<String, IStatixGroup> groups, ImmutableMap<String, IStatixUnit> units) {
        this.resource = resource;
        this.scopeNames = scopeNames;
        this.rule = rule;
        this.changed = changed;
        this.groups = groups;
        this.units = units;
    }

    @Override
    public String resource() {
        return this.resource;
    }

    public ImmutableList<String> scopeNames() {
        return this.scopeNames;
    }

    @Override
    public Optional<Rule> rule() {
        return Optional.ofNullable(this.rule);
    }

    @Override
    public boolean changed() {
        return this.changed;
    }

    public ImmutableMap<String, IStatixGroup> groups() {
        return this.groups;
    }

    public ImmutableMap<String, IStatixUnit> units() {
        return this.units;
    }

    public final StatixGroup withResource(String value) {
        String newValue = Objects.requireNonNull(value, "resource");
        if (this.resource.equals(newValue)) {
            return this;
        }
        return new StatixGroup(this, newValue, this.scopeNames, this.rule, this.changed, this.groups, this.units);
    }

    public final StatixGroup withScopeNames(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new StatixGroup(this, this.resource, (ImmutableList<String>)newValue, this.rule, this.changed, this.groups, this.units);
    }

    public final StatixGroup withScopeNames(Iterable<String> elements) {
        if (this.scopeNames == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new StatixGroup(this, this.resource, (ImmutableList<String>)newValue, this.rule, this.changed, this.groups, this.units);
    }

    public final StatixGroup withRule(Rule value) {
        Rule newValue = Objects.requireNonNull(value, "rule");
        if (this.rule == newValue) {
            return this;
        }
        return new StatixGroup(this, this.resource, this.scopeNames, newValue, this.changed, this.groups, this.units);
    }

    public final StatixGroup withRule(Optional<? extends Rule> optional) {
        Rule value = optional.orElse(null);
        if (this.rule == value) {
            return this;
        }
        return new StatixGroup(this, this.resource, this.scopeNames, value, this.changed, this.groups, this.units);
    }

    public final StatixGroup withChanged(boolean value) {
        if (this.changed == value) {
            return this;
        }
        return new StatixGroup(this, this.resource, this.scopeNames, this.rule, value, this.groups, this.units);
    }

    public final StatixGroup withGroups(Map<String, ? extends IStatixGroup> entries) {
        if (this.groups == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new StatixGroup(this, this.resource, this.scopeNames, this.rule, this.changed, (ImmutableMap<String, IStatixGroup>)newValue, this.units);
    }

    public final StatixGroup withUnits(Map<String, ? extends IStatixUnit> entries) {
        if (this.units == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new StatixGroup(this, this.resource, this.scopeNames, this.rule, this.changed, this.groups, (ImmutableMap<String, IStatixUnit>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof StatixGroup && this.equalTo((StatixGroup)another);
    }

    private boolean equalTo(StatixGroup another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.resource.equals(another.resource) && this.scopeNames.equals(another.scopeNames) && Objects.equals(this.rule, another.rule) && this.changed == another.changed && this.groups.equals(another.groups) && this.units.equals(another.units);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.resource.hashCode();
        h += (h << 5) + this.scopeNames.hashCode();
        h += (h << 5) + Objects.hashCode(this.rule);
        h += (h << 5) + Booleans.hashCode((boolean)this.changed);
        h += (h << 5) + this.groups.hashCode();
        h += (h << 5) + this.units.hashCode();
        return h;
    }

    public static StatixGroup of(String resource, List<String> scopeNames, Optional<Rule> rule, boolean changed, Map<String, IStatixGroup> groups, Map<String, IStatixUnit> units) {
        return StatixGroup.of(resource, scopeNames, rule, changed, groups, units);
    }

    public static StatixGroup of(String resource, Iterable<String> scopeNames, Optional<? extends Rule> rule, boolean changed, Map<String, ? extends IStatixGroup> groups, Map<String, ? extends IStatixUnit> units) {
        return new StatixGroup(resource, scopeNames, rule, changed, groups, units);
    }

    public static StatixGroup copyOf(AStatixGroup instance) {
        if (instance instanceof StatixGroup) {
            return (StatixGroup)instance;
        }
        return StatixGroup.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ StatixGroup(StatixGroup statixGroup, String string, ImmutableList immutableList, Rule rule, boolean bl, ImmutableMap immutableMap, ImmutableMap immutableMap2, StatixGroup statixGroup2) {
        this(statixGroup, string, (ImmutableList<String>)immutableList, rule, bl, (ImmutableMap<String, IStatixGroup>)immutableMap, (ImmutableMap<String, IStatixUnit>)immutableMap2);
    }

    public static final class Builder {
        private static final long INIT_BIT_RESOURCE = 1L;
        private static final long INIT_BIT_CHANGED = 2L;
        private long initBits = 3L;
        private String resource;
        private ImmutableList.Builder<String> scopeNames = ImmutableList.builder();
        private Rule rule;
        private boolean changed;
        private ImmutableMap.Builder<String, IStatixGroup> groups = ImmutableMap.builder();
        private ImmutableMap.Builder<String, IStatixUnit> units = ImmutableMap.builder();

        private Builder() {
        }

        public final Builder from(IStatixGroup instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AStatixGroup instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<Rule> ruleOptional;
            IStatixGroup instance;
            long bits = 0L;
            if (object instanceof IStatixGroup) {
                instance = (IStatixGroup)object;
                if ((bits & 4L) == 0L) {
                    ruleOptional = instance.rule();
                    if (ruleOptional.isPresent()) {
                        this.rule(ruleOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.putAllGroups(instance.groups());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.putAllUnits(instance.units());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    this.resource(instance.resource());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllScopeNames(instance.scopeNames());
                    bits |= 2L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.changed(instance.changed());
                    bits |= 0x20L;
                }
            }
            if (object instanceof AStatixGroup) {
                instance = (AStatixGroup)object;
                if ((bits & 4L) == 0L) {
                    ruleOptional = ((AStatixGroup)instance).rule();
                    if (ruleOptional.isPresent()) {
                        this.rule(ruleOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.putAllGroups(((AStatixGroup)instance).groups());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.putAllUnits(((AStatixGroup)instance).units());
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    this.resource(((AStatixGroup)instance).resource());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllScopeNames(((AStatixGroup)instance).scopeNames());
                    bits |= 2L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.changed(((AStatixGroup)instance).changed());
                    bits |= 0x20L;
                }
            }
        }

        public final Builder resource(String resource) {
            this.resource = Objects.requireNonNull(resource, "resource");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addScopeNames(String element) {
            this.scopeNames.add((Object)element);
            return this;
        }

        public final Builder addScopeNames(String ... elements) {
            this.scopeNames.add((Object[])elements);
            return this;
        }

        public final Builder scopeNames(Iterable<String> elements) {
            this.scopeNames = ImmutableList.builder();
            return this.addAllScopeNames(elements);
        }

        public final Builder addAllScopeNames(Iterable<String> elements) {
            this.scopeNames.addAll(elements);
            return this;
        }

        public final Builder rule(Rule rule) {
            this.rule = Objects.requireNonNull(rule, "rule");
            return this;
        }

        public final Builder rule(Optional<? extends Rule> rule) {
            this.rule = rule.orElse(null);
            return this;
        }

        public final Builder changed(boolean changed) {
            this.changed = changed;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder putGroups(String key, IStatixGroup value) {
            this.groups.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putGroups(Map.Entry<String, ? extends IStatixGroup> entry) {
            this.groups.put(entry);
            return this;
        }

        public final Builder groups(Map<String, ? extends IStatixGroup> entries) {
            this.groups = ImmutableMap.builder();
            return this.putAllGroups(entries);
        }

        public final Builder putAllGroups(Map<String, ? extends IStatixGroup> entries) {
            this.groups.putAll(entries);
            return this;
        }

        public final Builder putUnits(String key, IStatixUnit value) {
            this.units.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putUnits(Map.Entry<String, ? extends IStatixUnit> entry) {
            this.units.put(entry);
            return this;
        }

        public final Builder units(Map<String, ? extends IStatixUnit> entries) {
            this.units = ImmutableMap.builder();
            return this.putAllUnits(entries);
        }

        public final Builder putAllUnits(Map<String, ? extends IStatixUnit> entries) {
            this.units.putAll(entries);
            return this;
        }

        public StatixGroup build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new StatixGroup(null, this.resource, this.scopeNames.build(), this.rule, this.changed, this.groups.build(), this.units.build(), null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("resource");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("changed");
            }
            return "Cannot build StatixGroup, some of required attributes are not set " + attributes;
        }
    }
}

