/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.resolution;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mb.scopegraph.oopsla20.reference.ResolutionException;
import mb.scopegraph.resolution.RExp;
import mb.scopegraph.resolution.RVar;

public final class RMerge<L>
implements RExp<L>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ImmutableList<RVar> envs;

    public RMerge(Iterable<RVar> envs) {
        this.envs = ImmutableList.copyOf(envs);
    }

    public RMerge(RVar ... envs) {
        this.envs = ImmutableList.copyOf((Object[])envs);
    }

    public ImmutableList<RVar> envs() {
        return this.envs;
    }

    @Override
    public <R> R match(RExp.Cases<L, R> cases) {
        return cases.caseMerge((List<RVar>)this.envs);
    }

    @Override
    public <R, E extends Throwable> R matchInResolution(RExp.ResolutionCases<L, R> cases) throws ResolutionException, InterruptedException {
        return cases.caseMerge((List<RVar>)this.envs);
    }

    public String toString() {
        return "merge(" + this.envs.stream().map(RVar::toString).collect(Collectors.joining(", ")) + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RMerge other = (RMerge)obj;
        return Objects.equals(this.envs, other.envs);
    }

    public int hashCode() {
        return Objects.hash(this.envs);
    }
}

