/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.regexp.impl;

import com.google.common.collect.ImmutableSet;
import mb.scopegraph.regexp.IAlphabet;
import mb.scopegraph.regexp.IRegExp;
import mb.scopegraph.regexp.impl.FiniteAlphabet;

public final class RegExps {
    public static <S> IAlphabet<S> alphabet(IRegExp<S> re) {
        ImmutableSet.Builder alphabet = ImmutableSet.builder();
        RegExps.alphabet(re, alphabet);
        return new FiniteAlphabet(alphabet.build());
    }

    private static <S> void alphabet(IRegExp<S> re, final ImmutableSet.Builder<S> alphabet) {
        new IRegExp.ICases<S, S>(){

            @Override
            public S emptySet() {
                return null;
            }

            @Override
            public S emptyString() {
                return null;
            }

            @Override
            public S symbol(S s) {
                alphabet.add(s);
                return null;
            }

            @Override
            public S concat(IRegExp<S> left, IRegExp<S> right) {
                RegExps.alphabet(left, alphabet);
                RegExps.alphabet(right, alphabet);
                return null;
            }

            @Override
            public S closure(IRegExp<S> re) {
                RegExps.alphabet(re, alphabet);
                return null;
            }

            @Override
            public S or(IRegExp<S> left, IRegExp<S> right) {
                RegExps.alphabet(left, alphabet);
                RegExps.alphabet(right, alphabet);
                return null;
            }

            @Override
            public S and(IRegExp<S> left, IRegExp<S> right) {
                RegExps.alphabet(left, alphabet);
                RegExps.alphabet(right, alphabet);
                return null;
            }

            @Override
            public S complement(IRegExp<S> re) {
                RegExps.alphabet(re, alphabet);
                return null;
            }
        }.apply(re);
    }

    public static <S> boolean isNullable(IRegExp<S> re) {
        return (Boolean)re.match(new IRegExp.ICases<S, Boolean>(){

            @Override
            public Boolean emptySet() {
                return false;
            }

            @Override
            public Boolean emptyString() {
                return true;
            }

            @Override
            public Boolean symbol(S s) {
                return false;
            }

            @Override
            public Boolean concat(IRegExp<S> left, IRegExp<S> right) {
                if (((Boolean)left.match(this)).booleanValue() && ((Boolean)right.match(this)).booleanValue()) {
                    return true;
                }
                return false;
            }

            @Override
            public Boolean closure(IRegExp<S> re) {
                return true;
            }

            @Override
            public Boolean or(IRegExp<S> left, IRegExp<S> right) {
                if (!((Boolean)left.match(this)).booleanValue() && !((Boolean)right.match(this)).booleanValue()) {
                    return false;
                }
                return true;
            }

            @Override
            public Boolean and(IRegExp<S> left, IRegExp<S> right) {
                if (((Boolean)left.match(this)).booleanValue() && ((Boolean)right.match(this)).booleanValue()) {
                    return true;
                }
                return false;
            }

            @Override
            public Boolean complement(IRegExp<S> re) {
                return (Boolean)re.match(this) == false;
            }
        });
    }

    public static <S> boolean isOblivion(IRegExp<S> regexp) {
        return (Boolean)regexp.match(new IRegExp.ICases<S, Boolean>(){

            @Override
            public Boolean emptySet() {
                return true;
            }

            @Override
            public Boolean emptyString() {
                return false;
            }

            @Override
            public Boolean symbol(S s) {
                return false;
            }

            @Override
            public Boolean concat(IRegExp<S> left, IRegExp<S> right) {
                return false;
            }

            @Override
            public Boolean closure(IRegExp<S> re) {
                return false;
            }

            @Override
            public Boolean or(IRegExp<S> left, IRegExp<S> right) {
                return false;
            }

            @Override
            public Boolean and(IRegExp<S> left, IRegExp<S> right) {
                return false;
            }

            @Override
            public Boolean complement(IRegExp<S> re) {
                return false;
            }
        });
    }
}

