/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.pepm16.terms.path;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.math.IntMath;
import io.usethesource.capsule.Set;
import javax.annotation.Nullable;
import mb.scopegraph.pepm16.ILabel;
import mb.scopegraph.pepm16.IOccurrence;
import mb.scopegraph.pepm16.IScope;
import mb.scopegraph.pepm16.path.IResolutionPath;
import mb.scopegraph.pepm16.path.IScopePath;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import org.metaborg.util.collection.ConsList;

@Value.Immutable
@Serial.Version(value=42L)
abstract class AComposedScopePath<S extends IScope, L extends ILabel, O extends IOccurrence>
implements IScopePath<S, L, O> {
    AComposedScopePath() {
    }

    @Value.Parameter
    public abstract IScopePath<S, L, O> getLeft();

    @Value.Parameter
    public abstract IScopePath<S, L, O> getRight();

    @Nullable
    @Value.Check
    public AComposedScopePath<S, L, O> check() {
        if (!this.getLeft().getTarget().equals(this.getRight().getSource())) {
            return null;
        }
        if (this.getScopes().size() <= this.size()) {
            return null;
        }
        return this;
    }

    @Override
    @Value.Lazy
    public S getSource() {
        return this.getLeft().getSource();
    }

    @Override
    @Value.Lazy
    public S getTarget() {
        return this.getRight().getTarget();
    }

    @Override
    @Value.Lazy
    public int size() {
        return this.getLeft().size() + this.getRight().size();
    }

    @Override
    @Value.Lazy
    public Set.Immutable<O> getImports() {
        return this.getLeft().getImports().__insertAll(this.getRight().getImports());
    }

    @Override
    public Iterable<IResolutionPath<S, L, O>> getImportPaths() {
        return Iterables.concat(this.getLeft().getImportPaths(), this.getRight().getImportPaths());
    }

    @Override
    @Value.Lazy
    public Set.Immutable<S> getScopes() {
        return this.getLeft().getScopes().__insertAll(this.getRight().getScopes());
    }

    @Override
    @Value.Lazy
    public ConsList<L> getLabels() {
        return this.getLeft().getLabels().append(this.getRight().getLabels());
    }

    @Value.Lazy
    public int hashCode() {
        return this.getLeft().hashCode() + IntMath.pow((int)31, (int)this.getLeft().size()) * this.getRight().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IScopePath)) {
            return false;
        }
        IScopePath other = (IScopePath)obj;
        if (!this.getSource().equals(other.getSource())) {
            return false;
        }
        if (!this.getTarget().equals(other.getTarget())) {
            return false;
        }
        return Iterators.elementsEqual(this.iterator(), other.iterator());
    }

    @Override
    public String toString(boolean includeSource, boolean includeTarget) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLeft().toString(includeSource, true));
        sb.append(" ");
        sb.append(this.getRight().toString(false, includeTarget));
        return sb.toString();
    }

    public String toString() {
        return this.toString(true, true);
    }
}

