/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.pepm16.terms;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.terms.ITerm;
import mb.scopegraph.pepm16.INamespace;
import mb.scopegraph.pepm16.terms.ASpacedName;

public final class SpacedName
extends ASpacedName
implements Serializable {
    private final INamespace namespace;
    private final ITerm name;
    private final int hashCode;
    private static final long serialVersionUID = 42L;

    private SpacedName(INamespace namespace, ITerm name) {
        this.namespace = Objects.requireNonNull(namespace, "namespace");
        this.name = Objects.requireNonNull(name, "name");
        this.hashCode = this.computeHashCode();
    }

    private SpacedName(SpacedName original, INamespace namespace, ITerm name) {
        this.namespace = namespace;
        this.name = name;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public INamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public ITerm getName() {
        return this.name;
    }

    public final SpacedName withNamespace(INamespace value) {
        if (this.namespace == value) {
            return this;
        }
        INamespace newValue = Objects.requireNonNull(value, "namespace");
        return new SpacedName(this, newValue, this.name);
    }

    public final SpacedName withName(ITerm value) {
        if (this.name == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "name");
        return new SpacedName(this, this.namespace, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SpacedName && this.equalTo((SpacedName)another);
    }

    private boolean equalTo(SpacedName another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.namespace.equals(another.namespace) && this.name.equals(another.name);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.namespace.hashCode();
        h += (h << 5) + this.name.hashCode();
        return h;
    }

    public static SpacedName of(INamespace namespace, ITerm name) {
        return new SpacedName(namespace, name);
    }

    public static SpacedName copyOf(ASpacedName instance) {
        if (instance instanceof SpacedName) {
            return (SpacedName)instance;
        }
        return SpacedName.of(instance.getNamespace(), instance.getName());
    }

    private Object readResolve() throws ObjectStreamException {
        return new SpacedName(this, this.namespace, this.name);
    }
}

