/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.pepm16.esop15;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import mb.scopegraph.pepm16.ILabel;
import mb.scopegraph.pepm16.IScope;
import mb.scopegraph.pepm16.esop15.ACriticalEdge;

public final class CriticalEdge
extends ACriticalEdge
implements Serializable {
    private final IScope scope;
    private final ILabel label;
    private static final long serialVersionUID = 42L;

    private CriticalEdge(IScope scope, ILabel label) {
        this.scope = Objects.requireNonNull(scope, "scope");
        this.label = Objects.requireNonNull(label, "label");
    }

    private CriticalEdge(CriticalEdge original, IScope scope, ILabel label) {
        this.scope = scope;
        this.label = label;
    }

    @Override
    public IScope scope() {
        return this.scope;
    }

    @Override
    public ILabel label() {
        return this.label;
    }

    public final CriticalEdge withScope(IScope value) {
        if (this.scope == value) {
            return this;
        }
        IScope newValue = Objects.requireNonNull(value, "scope");
        return new CriticalEdge(this, newValue, this.label);
    }

    public final CriticalEdge withLabel(ILabel value) {
        if (this.label == value) {
            return this;
        }
        ILabel newValue = Objects.requireNonNull(value, "label");
        return new CriticalEdge(this, this.scope, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CriticalEdge && this.equalTo((CriticalEdge)another);
    }

    private boolean equalTo(CriticalEdge another) {
        return this.scope.equals(another.scope) && this.label.equals(another.label);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.scope.hashCode();
        h += (h << 5) + this.label.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CriticalEdge").omitNullValues().add("scope", (Object)this.scope).add("label", (Object)this.label).toString();
    }

    public static CriticalEdge of(IScope scope, ILabel label) {
        return new CriticalEdge(scope, label);
    }

    public static CriticalEdge copyOf(ACriticalEdge instance) {
        if (instance instanceof CriticalEdge) {
            return (CriticalEdge)instance;
        }
        return CriticalEdge.of(instance.scope(), instance.label());
    }
}

