/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical.match;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import mb.resource.hierarchical.HierarchicalResource;
import mb.resource.hierarchical.match.ResourceMatcher;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AllResourceMatcher
implements ResourceMatcher {
    private final List<ResourceMatcher> matchers;

    public AllResourceMatcher(ArrayList<ResourceMatcher> matchers) {
        this.matchers = matchers;
    }

    public AllResourceMatcher(ResourceMatcher ... matchers) {
        this.matchers = Arrays.asList(matchers);
    }

    @Override
    public boolean matches(HierarchicalResource resource, HierarchicalResource rootDirectory) throws IOException {
        for (ResourceMatcher matcher : this.matchers) {
            if (matcher.matches(resource, rootDirectory)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AllResourceMatcher other = (AllResourceMatcher)obj;
        return this.matchers.equals(other.matchers);
    }

    public int hashCode() {
        return Objects.hash(this.matchers);
    }

    public String toString() {
        return "all(" + this.matchers + ")";
    }
}

