/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api;

import java.io.Serializable;
import mb.pie.api.Observability;
import mb.pie.api.Output;
import mb.pie.api.TaskDeps;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TaskData {
    public final Serializable input;
    public final @Nullable Serializable internalObject;
    private final @Nullable Output output;
    public final Observability taskObservability;
    public final TaskDeps deps;

    public TaskData(Serializable input, @Nullable Serializable internalObject, @Nullable Output output, Observability taskObservability, TaskDeps deps) {
        this.input = input;
        this.internalObject = internalObject;
        this.output = output;
        this.taskObservability = taskObservability;
        this.deps = deps;
    }

    public boolean hasOutput() {
        return this.output != null;
    }

    public @Nullable Serializable getOutput() {
        if (!this.hasOutput()) {
            throw new IllegalStateException("Cannot get output as " + this + " has no output");
        }
        return this.output.output;
    }

    public <O extends Serializable> O getOutputCasted() {
        Serializable output = this.getOutput();
        return (O)output;
    }

    public @Nullable Output getWrappedOutput() {
        return this.output;
    }

    public TaskData withTaskObservability(Observability taskObservability) {
        return new TaskData(this.input, this.internalObject, this.output, taskObservability, this.deps);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskData taskData = (TaskData)o;
        if (!this.input.equals(taskData.input)) {
            return false;
        }
        if (this.internalObject != null ? !this.internalObject.equals(taskData.internalObject) : taskData.internalObject != null) {
            return false;
        }
        if (this.output != null ? !this.output.equals(taskData.output) : taskData.output != null) {
            return false;
        }
        if (this.taskObservability != taskData.taskObservability) {
            return false;
        }
        return this.deps.equals(taskData.deps);
    }

    public int hashCode() {
        int result = this.input.hashCode();
        result = 31 * result + (this.internalObject != null ? this.internalObject.hashCode() : 0);
        result = 31 * result + (this.output != null ? this.output.hashCode() : 0);
        result = 31 * result + this.taskObservability.hashCode();
        result = 31 * result + this.deps.hashCode();
        return result;
    }

    public String toString() {
        return "TaskData{input=" + this.input + ", internalObject=" + this.internalObject + ", output=" + this.output + ", taskObservability=" + this.taskObservability + ", deps=" + this.deps + '}';
    }
}

