/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl.tokens;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Objects;
import mb.p_raffrayi.actors.IActorRef;
import mb.p_raffrayi.impl.IUnit;
import mb.p_raffrayi.impl.tokens.AMatch;

public final class Match<S, L, D>
extends AMatch<S, L, D> {
    private final IActorRef<? extends IUnit<S, L, D, ?>> origin;
    private final S scope;

    private Match(IActorRef<? extends IUnit<S, L, D, ?>> origin, S scope) {
        this.origin = Objects.requireNonNull(origin, "origin");
        this.scope = Objects.requireNonNull(scope, "scope");
    }

    private Match(Match<S, L, D> original, IActorRef<? extends IUnit<S, L, D, ?>> origin, S scope) {
        this.origin = origin;
        this.scope = scope;
    }

    @Override
    public IActorRef<? extends IUnit<S, L, D, ?>> origin() {
        return this.origin;
    }

    @Override
    public S scope() {
        return this.scope;
    }

    public final Match<S, L, D> withOrigin(IActorRef<? extends IUnit<S, L, D, ?>> value) {
        if (this.origin == value) {
            return this;
        }
        IActorRef<? extends IUnit<S, L, D, ?>> newValue = Objects.requireNonNull(value, "origin");
        return new Match<S, L, D>(this, newValue, this.scope);
    }

    public final Match<S, L, D> withScope(S value) {
        if (this.scope == value) {
            return this;
        }
        S newValue = Objects.requireNonNull(value, "scope");
        return new Match<S, L, D>(this, this.origin, newValue);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Match").omitNullValues().add("origin", this.origin).add("scope", this.scope).toString();
    }

    public static <S, L, D> Match<S, L, D> of(IActorRef<? extends IUnit<S, L, D, ?>> origin, S scope) {
        return new Match<S, L, D>(origin, scope);
    }

    public static <S, L, D> Match<S, L, D> copyOf(AMatch<S, L, D> instance) {
        if (instance instanceof Match) {
            return (Match)instance;
        }
        return Match.builder().from(instance).build();
    }

    public static <S, L, D> Builder<S, L, D> builder() {
        return new Builder();
    }

    /* synthetic */ Match(Match match, IActorRef iActorRef, Object object, Match match2) {
        this(match, iActorRef, object);
    }

    public static final class Builder<S, L, D> {
        private static final long INIT_BIT_ORIGIN = 1L;
        private static final long INIT_BIT_SCOPE = 2L;
        private long initBits = 3L;
        private IActorRef<? extends IUnit<S, L, D, ?>> origin;
        private S scope;

        private Builder() {
        }

        public final Builder<S, L, D> from(AMatch<S, L, D> instance) {
            Objects.requireNonNull(instance, "instance");
            this.origin(instance.origin());
            this.scope(instance.scope());
            return this;
        }

        public final Builder<S, L, D> origin(IActorRef<? extends IUnit<S, L, D, ?>> origin) {
            this.origin = Objects.requireNonNull(origin, "origin");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<S, L, D> scope(S scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Match<S, L, D> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Match(null, this.origin, this.scope, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("origin");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("scope");
            }
            return "Cannot build Match, some of required attributes are not set " + attributes;
        }
    }
}

