/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl.diff;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import mb.p_raffrayi.impl.diff.AScopeDiff;
import mb.scopegraph.oopsla20.diff.Edge;

public final class ScopeDiff<S, L, D>
extends AScopeDiff<S, L, D> {
    private final ImmutableSet<Edge<S, L>> addedEdges;
    private final ImmutableSet<Edge<S, L>> matchedEdges;
    private final ImmutableSet<Edge<S, L>> removedEdges;
    private transient int hashCode;

    private ScopeDiff(Iterable<? extends Edge<S, L>> addedEdges, Iterable<? extends Edge<S, L>> matchedEdges, Iterable<? extends Edge<S, L>> removedEdges) {
        this.addedEdges = ImmutableSet.copyOf(addedEdges);
        this.matchedEdges = ImmutableSet.copyOf(matchedEdges);
        this.removedEdges = ImmutableSet.copyOf(removedEdges);
    }

    private ScopeDiff(ScopeDiff<S, L, D> original, ImmutableSet<Edge<S, L>> addedEdges, ImmutableSet<Edge<S, L>> matchedEdges, ImmutableSet<Edge<S, L>> removedEdges) {
        this.addedEdges = addedEdges;
        this.matchedEdges = matchedEdges;
        this.removedEdges = removedEdges;
    }

    @Override
    public ImmutableSet<Edge<S, L>> addedEdges() {
        return this.addedEdges;
    }

    @Override
    public ImmutableSet<Edge<S, L>> matchedEdges() {
        return this.matchedEdges;
    }

    @Override
    public ImmutableSet<Edge<S, L>> removedEdges() {
        return this.removedEdges;
    }

    @SafeVarargs
    public final ScopeDiff<S, L, D> withAddedEdges(Edge<S, L> ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ScopeDiff<S, L, D>(this, newValue, this.matchedEdges, this.removedEdges);
    }

    public final ScopeDiff<S, L, D> withAddedEdges(Iterable<? extends Edge<S, L>> elements) {
        if (this.addedEdges == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ScopeDiff<S, L, D>(this, newValue, this.matchedEdges, this.removedEdges);
    }

    @SafeVarargs
    public final ScopeDiff<S, L, D> withMatchedEdges(Edge<S, L> ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ScopeDiff<S, L, D>(this, this.addedEdges, newValue, this.removedEdges);
    }

    public final ScopeDiff<S, L, D> withMatchedEdges(Iterable<? extends Edge<S, L>> elements) {
        if (this.matchedEdges == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ScopeDiff<S, L, D>(this, this.addedEdges, newValue, this.removedEdges);
    }

    @SafeVarargs
    public final ScopeDiff<S, L, D> withRemovedEdges(Edge<S, L> ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ScopeDiff<S, L, D>(this, this.addedEdges, this.matchedEdges, newValue);
    }

    public final ScopeDiff<S, L, D> withRemovedEdges(Iterable<? extends Edge<S, L>> elements) {
        if (this.removedEdges == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ScopeDiff<S, L, D>(this, this.addedEdges, this.matchedEdges, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ScopeDiff && this.equalTo((ScopeDiff)another);
    }

    private boolean equalTo(ScopeDiff<?, ?, ?> another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.addedEdges.equals(another.addedEdges) && this.matchedEdges.equals(another.matchedEdges) && this.removedEdges.equals(another.removedEdges);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.addedEdges.hashCode();
        h += (h << 5) + this.matchedEdges.hashCode();
        h += (h << 5) + this.removedEdges.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ScopeDiff").omitNullValues().add("addedEdges", this.addedEdges).add("matchedEdges", this.matchedEdges).add("removedEdges", this.removedEdges).toString();
    }

    public static <S, L, D> ScopeDiff<S, L, D> of(Set<Edge<S, L>> addedEdges, Set<Edge<S, L>> matchedEdges, Set<Edge<S, L>> removedEdges) {
        return ScopeDiff.of(addedEdges, matchedEdges, removedEdges);
    }

    public static <S, L, D> ScopeDiff<S, L, D> of(Iterable<? extends Edge<S, L>> addedEdges, Iterable<? extends Edge<S, L>> matchedEdges, Iterable<? extends Edge<S, L>> removedEdges) {
        return new ScopeDiff<S, L, D>(addedEdges, matchedEdges, removedEdges);
    }

    public static <S, L, D> ScopeDiff<S, L, D> copyOf(AScopeDiff<S, L, D> instance) {
        if (instance instanceof ScopeDiff) {
            return (ScopeDiff)instance;
        }
        return ScopeDiff.builder().from(instance).build();
    }

    public static <S, L, D> Builder<S, L, D> builder() {
        return new Builder();
    }

    /* synthetic */ ScopeDiff(ScopeDiff scopeDiff, ImmutableSet immutableSet, ImmutableSet immutableSet2, ImmutableSet immutableSet3, ScopeDiff scopeDiff2) {
        this(scopeDiff, immutableSet, immutableSet2, immutableSet3);
    }

    public static final class Builder<S, L, D> {
        private ImmutableSet.Builder<Edge<S, L>> addedEdges = ImmutableSet.builder();
        private ImmutableSet.Builder<Edge<S, L>> matchedEdges = ImmutableSet.builder();
        private ImmutableSet.Builder<Edge<S, L>> removedEdges = ImmutableSet.builder();

        private Builder() {
        }

        public final Builder<S, L, D> from(AScopeDiff<S, L, D> instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllAddedEdges(instance.addedEdges());
            this.addAllMatchedEdges(instance.matchedEdges());
            this.addAllRemovedEdges(instance.removedEdges());
            return this;
        }

        public final Builder<S, L, D> addAddedEdges(Edge<S, L> element) {
            this.addedEdges.add(element);
            return this;
        }

        @SafeVarargs
        public final Builder<S, L, D> addAddedEdges(Edge<S, L> ... elements) {
            this.addedEdges.add((Object[])elements);
            return this;
        }

        public final Builder<S, L, D> addedEdges(Iterable<? extends Edge<S, L>> elements) {
            this.addedEdges = ImmutableSet.builder();
            return this.addAllAddedEdges(elements);
        }

        public final Builder<S, L, D> addAllAddedEdges(Iterable<? extends Edge<S, L>> elements) {
            this.addedEdges.addAll(elements);
            return this;
        }

        public final Builder<S, L, D> addMatchedEdges(Edge<S, L> element) {
            this.matchedEdges.add(element);
            return this;
        }

        @SafeVarargs
        public final Builder<S, L, D> addMatchedEdges(Edge<S, L> ... elements) {
            this.matchedEdges.add((Object[])elements);
            return this;
        }

        public final Builder<S, L, D> matchedEdges(Iterable<? extends Edge<S, L>> elements) {
            this.matchedEdges = ImmutableSet.builder();
            return this.addAllMatchedEdges(elements);
        }

        public final Builder<S, L, D> addAllMatchedEdges(Iterable<? extends Edge<S, L>> elements) {
            this.matchedEdges.addAll(elements);
            return this;
        }

        public final Builder<S, L, D> addRemovedEdges(Edge<S, L> element) {
            this.removedEdges.add(element);
            return this;
        }

        @SafeVarargs
        public final Builder<S, L, D> addRemovedEdges(Edge<S, L> ... elements) {
            this.removedEdges.add((Object[])elements);
            return this;
        }

        public final Builder<S, L, D> removedEdges(Iterable<? extends Edge<S, L>> elements) {
            this.removedEdges = ImmutableSet.builder();
            return this.addAllRemovedEdges(elements);
        }

        public final Builder<S, L, D> addAllRemovedEdges(Iterable<? extends Edge<S, L>> elements) {
            this.removedEdges.addAll(elements);
            return this;
        }

        public ScopeDiff<S, L, D> build() {
            return new ScopeDiff(null, this.addedEdges.build(), this.matchedEdges.build(), this.removedEdges.build(), null);
        }
    }
}

