/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl.confirm;

import java.util.Optional;
import mb.p_raffrayi.impl.confirm.BaseConfirmation;
import mb.p_raffrayi.impl.confirm.ConfirmResult;
import mb.p_raffrayi.impl.confirm.IConfirmationContext;
import mb.p_raffrayi.impl.confirm.IConfirmationFactory;
import mb.p_raffrayi.impl.envdiff.AddedEdge;
import mb.p_raffrayi.impl.envdiff.RemovedEdge;
import mb.p_raffrayi.nameresolution.DataLeq;
import mb.p_raffrayi.nameresolution.DataWf;
import mb.scopegraph.ecoop21.LabelOrder;
import mb.scopegraph.oopsla20.terms.newPath.ScopePath;
import org.metaborg.util.future.AggregateFuture;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class OptimisticConfirmation<S, L, D>
extends BaseConfirmation<S, L, D> {
    private static final ILogger logger = LoggerUtils.logger(OptimisticConfirmation.class);

    public OptimisticConfirmation(IConfirmationContext<S, L, D> context) {
        super(context);
    }

    @Override
    protected IFuture<AggregateFuture.SC<ConfirmResult<S, L, D>, ConfirmResult<S, L, D>>> handleAddedEdge(AddedEdge<S, L, D> addedEdge, BaseConfirmation.LazyFuture<Optional<DataWf<S, L, D>>> dataWf) {
        logger.debug("Handling added edge by regular query: {}.", addedEdge);
        return dataWf.get().thenCompose(newDataWfOpt -> newDataWfOpt.map(newDataWf -> this.context.query(new ScopePath(addedEdge.target()), addedEdge.labelWf(), LabelOrder.none(), newDataWf, DataLeq.none()).thenApply(ans -> ans.env().isEmpty() ? this.acceptAdded(ans.transitiveQueries(), ans.predicateQueries()) : this.deny())).orElse(this.denyFuture()));
    }

    @Override
    protected IFuture<AggregateFuture.SC<ConfirmResult<S, L, D>, ConfirmResult<S, L, D>>> handleRemovedEdge(RemovedEdge<S, L, D> removedEdge, DataWf<S, L, D> dataWf, boolean prevEnvEnpty) {
        if (prevEnvEnpty) {
            logger.debug("Confirming removed edge: previous environment empty.");
            return this.acceptFuture();
        }
        logger.debug("Confirming removed edge by previous result query: {}.", removedEdge);
        return this.context.queryPrevious(new ScopePath(removedEdge.target()), removedEdge.labelWf(), dataWf, LabelOrder.none(), DataLeq.none()).thenApply(ans -> ans.env().isEmpty() ? this.acceptRemoved(ans.transitiveQueries(), ans.predicateQueries()) : this.deny());
    }

    public static <S, L, D> IConfirmationFactory<S, L, D> factory() {
        return OptimisticConfirmation::new;
    }
}

