/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import mb.p_raffrayi.ITypeChecker;
import mb.p_raffrayi.impl.AResult;
import mb.p_raffrayi.impl.StateCapture;
import mb.scopegraph.oopsla20.IScopeGraph;

public final class Result<S, L, D, A extends ITypeChecker.IOutput<S, L, D>, T extends ITypeChecker.IState<S, L, D>>
extends AResult<S, L, D, A, T>
implements Serializable {
    @Nullable
    private final A analysis;
    @Nullable
    private final StateCapture<S, L, D, T> localState;
    @Nullable
    private final IScopeGraph.Immutable<S, L, D> scopeGraph;
    @Nullable
    private final ImmutableSet<S> sharedScopes;
    private int hashCode;
    private static final long serialVersionUID = 42L;

    private Result(@Nullable A analysis, @Nullable StateCapture<S, L, D, T> localState, @Nullable IScopeGraph.Immutable<S, L, D> scopeGraph, @Nullable Iterable<? extends S> sharedScopes) {
        this.analysis = analysis;
        this.localState = localState;
        this.scopeGraph = scopeGraph;
        this.sharedScopes = sharedScopes == null ? null : ImmutableSet.copyOf(sharedScopes);
    }

    private Result(Result<S, L, D, A, T> original, @Nullable A analysis, @Nullable StateCapture<S, L, D, T> localState, @Nullable IScopeGraph.Immutable<S, L, D> scopeGraph, @Nullable ImmutableSet<S> sharedScopes) {
        this.analysis = analysis;
        this.localState = localState;
        this.scopeGraph = scopeGraph;
        this.sharedScopes = sharedScopes;
    }

    @Override
    @Nullable
    public A analysis() {
        return this.analysis;
    }

    @Override
    @Nullable
    public StateCapture<S, L, D, T> localState() {
        return this.localState;
    }

    @Override
    @Nullable
    public IScopeGraph.Immutable<S, L, D> scopeGraph() {
        return this.scopeGraph;
    }

    @Override
    @Nullable
    public ImmutableSet<S> sharedScopes() {
        return this.sharedScopes;
    }

    public final Result<S, L, D, A, T> withAnalysis(@Nullable A value) {
        if (this.analysis == value) {
            return this;
        }
        return new Result<S, L, D, A, T>(this, value, this.localState, this.scopeGraph, this.sharedScopes);
    }

    public final Result<S, L, D, A, T> withLocalState(@Nullable StateCapture<S, L, D, T> value) {
        if (this.localState == value) {
            return this;
        }
        return new Result<S, L, D, A, T>(this, this.analysis, value, this.scopeGraph, this.sharedScopes);
    }

    public final Result<S, L, D, A, T> withScopeGraph(@Nullable IScopeGraph.Immutable<S, L, D> value) {
        if (this.scopeGraph == value) {
            return this;
        }
        return new Result<S, L, D, A, T>(this, this.analysis, this.localState, value, this.sharedScopes);
    }

    @SafeVarargs
    public final Result<S, L, D, A, T> withSharedScopes(S ... elements) {
        if (elements == null) {
            return new Result<S, L, D, A, T>(this, this.analysis, this.localState, this.scopeGraph, null);
        }
        ImmutableSet newValue = elements == null ? null : ImmutableSet.copyOf((Object[])elements);
        return new Result<S, L, D, A, T>(this, this.analysis, this.localState, this.scopeGraph, newValue);
    }

    public final Result<S, L, D, A, T> withSharedScopes(@Nullable Iterable<? extends S> elements) {
        if (this.sharedScopes == elements) {
            return this;
        }
        ImmutableSet newValue = elements == null ? null : ImmutableSet.copyOf(elements);
        return new Result<S, L, D, A, T>(this, this.analysis, this.localState, this.scopeGraph, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Result && this.equalTo((Result)another);
    }

    private boolean equalTo(Result<?, ?, ?, ?, ?> another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.analysis, another.analysis) && Objects.equals(this.localState, another.localState) && Objects.equals(this.scopeGraph, another.scopeGraph) && Objects.equals(this.sharedScopes, another.sharedScopes);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.analysis);
        h += (h << 5) + Objects.hashCode(this.localState);
        h += (h << 5) + Objects.hashCode(this.scopeGraph);
        h += (h << 5) + Objects.hashCode(this.sharedScopes);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Result").omitNullValues().add("analysis", this.analysis).add("localState", this.localState).add("scopeGraph", this.scopeGraph).add("sharedScopes", this.sharedScopes).toString();
    }

    public static <S, L, D, A extends ITypeChecker.IOutput<S, L, D>, T extends ITypeChecker.IState<S, L, D>> Result<S, L, D, A, T> of(@Nullable A analysis, @Nullable StateCapture<S, L, D, T> localState, @Nullable IScopeGraph.Immutable<S, L, D> scopeGraph, @Nullable Set<S> sharedScopes) {
        return Result.of(analysis, localState, scopeGraph, sharedScopes);
    }

    public static <S, L, D, A extends ITypeChecker.IOutput<S, L, D>, T extends ITypeChecker.IState<S, L, D>> Result<S, L, D, A, T> of(@Nullable A analysis, @Nullable StateCapture<S, L, D, T> localState, @Nullable IScopeGraph.Immutable<S, L, D> scopeGraph, @Nullable Iterable<? extends S> sharedScopes) {
        return new Result<S, L, D, A, T>(analysis, localState, scopeGraph, sharedScopes);
    }

    public static <S, L, D, A extends ITypeChecker.IOutput<S, L, D>, T extends ITypeChecker.IState<S, L, D>> Result<S, L, D, A, T> copyOf(AResult<S, L, D, A, T> instance) {
        if (instance instanceof Result) {
            return (Result)instance;
        }
        return Result.builder().from(instance).build();
    }

    public static <S, L, D, A extends ITypeChecker.IOutput<S, L, D>, T extends ITypeChecker.IState<S, L, D>> Builder<S, L, D, A, T> builder() {
        return new Builder();
    }

    /* synthetic */ Result(Result result, ITypeChecker.IOutput iOutput, StateCapture stateCapture, IScopeGraph.Immutable immutable, ImmutableSet immutableSet, Result result2) {
        this(result, iOutput, stateCapture, immutable, immutableSet);
    }

    public static final class Builder<S, L, D, A extends ITypeChecker.IOutput<S, L, D>, T extends ITypeChecker.IState<S, L, D>> {
        private A analysis;
        private StateCapture<S, L, D, T> localState;
        private IScopeGraph.Immutable<S, L, D> scopeGraph;
        private ImmutableSet.Builder<S> sharedScopes = null;

        private Builder() {
        }

        public final Builder<S, L, D, A, T> from(AResult<S, L, D, A, T> instance) {
            Set<S> sharedScopesValue;
            IScopeGraph.Immutable<S, L, D> scopeGraphValue;
            StateCapture<S, L, D, T> localStateValue;
            Objects.requireNonNull(instance, "instance");
            A analysisValue = instance.analysis();
            if (analysisValue != null) {
                this.analysis(analysisValue);
            }
            if ((localStateValue = instance.localState()) != null) {
                this.localState(localStateValue);
            }
            if ((scopeGraphValue = instance.scopeGraph()) != null) {
                this.scopeGraph(scopeGraphValue);
            }
            if ((sharedScopesValue = instance.sharedScopes()) != null) {
                this.addAllSharedScopes(sharedScopesValue);
            }
            return this;
        }

        public final Builder<S, L, D, A, T> analysis(@Nullable A analysis) {
            this.analysis = analysis;
            return this;
        }

        public final Builder<S, L, D, A, T> localState(@Nullable StateCapture<S, L, D, T> localState) {
            this.localState = localState;
            return this;
        }

        public final Builder<S, L, D, A, T> scopeGraph(@Nullable IScopeGraph.Immutable<S, L, D> scopeGraph) {
            this.scopeGraph = scopeGraph;
            return this;
        }

        public final Builder<S, L, D, A, T> addSharedScopes(S element) {
            if (this.sharedScopes == null) {
                this.sharedScopes = ImmutableSet.builder();
            }
            this.sharedScopes.add(element);
            return this;
        }

        @SafeVarargs
        public final Builder<S, L, D, A, T> addSharedScopes(S ... elements) {
            if (this.sharedScopes == null) {
                this.sharedScopes = ImmutableSet.builder();
            }
            this.sharedScopes.add((Object[])elements);
            return this;
        }

        public final Builder<S, L, D, A, T> sharedScopes(@Nullable Iterable<? extends S> elements) {
            if (elements == null) {
                this.sharedScopes = null;
                return this;
            }
            this.sharedScopes = ImmutableSet.builder();
            return this.addAllSharedScopes(elements);
        }

        public final Builder<S, L, D, A, T> addAllSharedScopes(Iterable<? extends S> elements) {
            Objects.requireNonNull(elements, "sharedScopes element");
            if (this.sharedScopes == null) {
                this.sharedScopes = ImmutableSet.builder();
            }
            this.sharedScopes.addAll(elements);
            return this;
        }

        public Result<S, L, D, A, T> build() {
            return new Result(null, (ITypeChecker.IOutput)this.analysis, this.localState, this.scopeGraph, this.sharedScopes == null ? null : this.sharedScopes.build(), null);
        }
    }
}

