/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import mb.p_raffrayi.impl.ARecordedQuery;
import mb.p_raffrayi.nameresolution.DataWf;
import mb.scopegraph.ecoop21.LabelWf;

public final class RecordedQuery<S, L, D>
extends ARecordedQuery<S, L, D>
implements Serializable {
    private final S source;
    private final ImmutableSet<S> datumScopes;
    private final LabelWf<L> labelWf;
    private final DataWf<S, L, D> dataWf;
    private final boolean empty;
    private final boolean includePatches;
    private int hashCode;
    private static final long serialVersionUID = 42L;

    private RecordedQuery(S source, Iterable<? extends S> datumScopes, LabelWf<L> labelWf, DataWf<S, L, D> dataWf, boolean empty, boolean includePatches) {
        this.source = Objects.requireNonNull(source, "source");
        this.datumScopes = ImmutableSet.copyOf(datumScopes);
        this.labelWf = Objects.requireNonNull(labelWf, "labelWf");
        this.dataWf = Objects.requireNonNull(dataWf, "dataWf");
        this.empty = empty;
        this.includePatches = includePatches;
    }

    private RecordedQuery(RecordedQuery<S, L, D> original, S source, ImmutableSet<S> datumScopes, LabelWf<L> labelWf, DataWf<S, L, D> dataWf, boolean empty, boolean includePatches) {
        this.source = source;
        this.datumScopes = datumScopes;
        this.labelWf = labelWf;
        this.dataWf = dataWf;
        this.empty = empty;
        this.includePatches = includePatches;
    }

    @Override
    public S source() {
        return this.source;
    }

    @Override
    public ImmutableSet<S> datumScopes() {
        return this.datumScopes;
    }

    @Override
    public LabelWf<L> labelWf() {
        return this.labelWf;
    }

    @Override
    public DataWf<S, L, D> dataWf() {
        return this.dataWf;
    }

    @Override
    public boolean empty() {
        return this.empty;
    }

    @Override
    public boolean includePatches() {
        return this.includePatches;
    }

    public final RecordedQuery<S, L, D> withSource(S value) {
        if (this.source == value) {
            return this;
        }
        S newValue = Objects.requireNonNull(value, "source");
        return new RecordedQuery<S, L, D>(this, newValue, this.datumScopes, this.labelWf, this.dataWf, this.empty, this.includePatches);
    }

    @SafeVarargs
    public final RecordedQuery<S, L, D> withDatumScopes(S ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new RecordedQuery<S, L, D>(this, this.source, newValue, this.labelWf, this.dataWf, this.empty, this.includePatches);
    }

    public final RecordedQuery<S, L, D> withDatumScopes(Iterable<? extends S> elements) {
        if (this.datumScopes == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new RecordedQuery<S, L, D>(this, this.source, newValue, this.labelWf, this.dataWf, this.empty, this.includePatches);
    }

    public final RecordedQuery<S, L, D> withLabelWf(LabelWf<L> value) {
        if (this.labelWf == value) {
            return this;
        }
        LabelWf<L> newValue = Objects.requireNonNull(value, "labelWf");
        return new RecordedQuery<S, L, D>(this, this.source, this.datumScopes, newValue, this.dataWf, this.empty, this.includePatches);
    }

    public final RecordedQuery<S, L, D> withDataWf(DataWf<S, L, D> value) {
        if (this.dataWf == value) {
            return this;
        }
        DataWf<S, L, D> newValue = Objects.requireNonNull(value, "dataWf");
        return new RecordedQuery<S, L, D>(this, this.source, this.datumScopes, this.labelWf, newValue, this.empty, this.includePatches);
    }

    public final RecordedQuery<S, L, D> withEmpty(boolean value) {
        if (this.empty == value) {
            return this;
        }
        return new RecordedQuery<S, L, D>(this, this.source, this.datumScopes, this.labelWf, this.dataWf, value, this.includePatches);
    }

    @Override
    public final RecordedQuery<S, L, D> withIncludePatches(boolean value) {
        if (this.includePatches == value) {
            return this;
        }
        return new RecordedQuery<S, L, D>(this, this.source, this.datumScopes, this.labelWf, this.dataWf, this.empty, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof RecordedQuery && this.equalTo((RecordedQuery)another);
    }

    private boolean equalTo(RecordedQuery<?, ?, ?> another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.source.equals(another.source) && this.datumScopes.equals(another.datumScopes) && this.labelWf.equals(another.labelWf) && this.dataWf.equals(another.dataWf) && this.empty == another.empty && this.includePatches == another.includePatches;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.source.hashCode();
        h += (h << 5) + this.datumScopes.hashCode();
        h += (h << 5) + this.labelWf.hashCode();
        h += (h << 5) + this.dataWf.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.empty);
        h += (h << 5) + Booleans.hashCode((boolean)this.includePatches);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RecordedQuery").omitNullValues().add("source", this.source).add("datumScopes", this.datumScopes).add("labelWf", this.labelWf).add("dataWf", this.dataWf).add("empty", this.empty).add("includePatches", this.includePatches).toString();
    }

    public static <S, L, D> RecordedQuery<S, L, D> of(S source, Set<S> datumScopes, LabelWf<L> labelWf, DataWf<S, L, D> dataWf, boolean empty, boolean includePatches) {
        return RecordedQuery.of(source, datumScopes, labelWf, dataWf, empty, includePatches);
    }

    public static <S, L, D> RecordedQuery<S, L, D> of(S source, Iterable<? extends S> datumScopes, LabelWf<L> labelWf, DataWf<S, L, D> dataWf, boolean empty, boolean includePatches) {
        return new RecordedQuery<S, L, D>(source, datumScopes, labelWf, dataWf, empty, includePatches);
    }

    public static <S, L, D> RecordedQuery<S, L, D> copyOf(ARecordedQuery<S, L, D> instance) {
        if (instance instanceof RecordedQuery) {
            return (RecordedQuery)instance;
        }
        return RecordedQuery.builder().from(instance).build();
    }

    public static <S, L, D> Builder<S, L, D> builder() {
        return new Builder();
    }

    /* synthetic */ RecordedQuery(RecordedQuery recordedQuery, Object object, ImmutableSet immutableSet, LabelWf labelWf, DataWf dataWf, boolean bl, boolean bl2, RecordedQuery recordedQuery2) {
        this(recordedQuery, object, immutableSet, labelWf, dataWf, bl, bl2);
    }

    public static final class Builder<S, L, D> {
        private static final long INIT_BIT_SOURCE = 1L;
        private static final long INIT_BIT_LABEL_WF = 2L;
        private static final long INIT_BIT_DATA_WF = 4L;
        private static final long INIT_BIT_EMPTY = 8L;
        private static final long INIT_BIT_INCLUDE_PATCHES = 16L;
        private long initBits = 31L;
        private S source;
        private ImmutableSet.Builder<S> datumScopes = ImmutableSet.builder();
        private LabelWf<L> labelWf;
        private DataWf<S, L, D> dataWf;
        private boolean empty;
        private boolean includePatches;

        private Builder() {
        }

        public final Builder<S, L, D> from(ARecordedQuery<S, L, D> instance) {
            Objects.requireNonNull(instance, "instance");
            this.source(instance.source());
            this.addAllDatumScopes(instance.datumScopes());
            this.labelWf(instance.labelWf());
            this.dataWf(instance.dataWf());
            this.empty(instance.empty());
            this.includePatches(instance.includePatches());
            return this;
        }

        public final Builder<S, L, D> source(S source) {
            this.source = Objects.requireNonNull(source, "source");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<S, L, D> addDatumScopes(S element) {
            this.datumScopes.add(element);
            return this;
        }

        @SafeVarargs
        public final Builder<S, L, D> addDatumScopes(S ... elements) {
            this.datumScopes.add((Object[])elements);
            return this;
        }

        public final Builder<S, L, D> datumScopes(Iterable<? extends S> elements) {
            this.datumScopes = ImmutableSet.builder();
            return this.addAllDatumScopes(elements);
        }

        public final Builder<S, L, D> addAllDatumScopes(Iterable<? extends S> elements) {
            this.datumScopes.addAll(elements);
            return this;
        }

        public final Builder<S, L, D> labelWf(LabelWf<L> labelWf) {
            this.labelWf = Objects.requireNonNull(labelWf, "labelWf");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder<S, L, D> dataWf(DataWf<S, L, D> dataWf) {
            this.dataWf = Objects.requireNonNull(dataWf, "dataWf");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder<S, L, D> empty(boolean empty) {
            this.empty = empty;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder<S, L, D> includePatches(boolean includePatches) {
            this.includePatches = includePatches;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public RecordedQuery<S, L, D> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new RecordedQuery(null, this.source, this.datumScopes.build(), this.labelWf, this.dataWf, this.empty, this.includePatches, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("source");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("labelWf");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("dataWf");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("empty");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("includePatches");
            }
            return "Cannot build RecordedQuery, some of required attributes are not set " + attributes;
        }
    }
}

