/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.util.graph.alg.misc.memory;

import io.usethesource.capsule.Map;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import mb.nabl2.util.graph.alg.misc.memory.MapBackedMemoryView;

public interface IMemoryView<T>
extends Iterable<T> {
    public int getCount(T var1);

    public int getCountUnsafe(Object var1);

    public boolean containsNonZero(T var1);

    public boolean containsNonZeroUnsafe(Object var1);

    public int size();

    public boolean isEmpty();

    public Set<T> distinctValues();

    public Iterable<Map.Entry<T, Integer>> entriesWithMultiplicities();

    default public void forEachEntryWithMultiplicities(BiConsumer<T, Integer> entryConsumer) {
        for (Map.Entry<T, Integer> e : this.entriesWithMultiplicities()) {
            entryConsumer.accept(e.getKey(), e.getValue());
        }
    }

    public Map.Immutable<T, Integer> asMap();

    public static <T> IMemoryView<T> fromMap(Map.Immutable<T, Integer> wrapped) {
        return new MapBackedMemoryView<T>(wrapped);
    }

    public static <T> boolean equals(IMemoryView<T> self, Object obj) {
        if (obj instanceof IMemoryView) {
            IMemoryView other = (IMemoryView)obj;
            if (other.size() != self.size()) {
                return false;
            }
            for (Map.Entry<T, Integer> entry : other.entriesWithMultiplicities()) {
                if (entry.getValue().equals(self.getCountUnsafe(entry.getKey()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static <T> int hashCode(IMemoryView<T> memory) {
        int hashCode = 0;
        for (T value : memory.distinctValues()) {
            hashCode += value.hashCode() ^ Integer.hashCode(memory.getCount(value));
        }
        return hashCode;
    }
}

