/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.substitution;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.ListTerms;
import mb.nabl2.terms.Terms;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.substitution.IReplacement;

public class Replacement
implements IReplacement {
    private final BiMap<ITerm, ITerm> replacement;
    private final boolean traverseSubTerms;

    private Replacement(BiMap<ITerm, ITerm> replacement, boolean traverseSubTerms) {
        this.replacement = replacement;
        this.traverseSubTerms = traverseSubTerms;
    }

    @Override
    public boolean isEmpty() {
        return this.replacement.isEmpty();
    }

    @Override
    public Set<ITerm> keySet() {
        return this.replacement.keySet();
    }

    @Override
    public Set<ITerm> valueSet() {
        return this.replacement.values();
    }

    @Override
    public Set<? extends Map.Entry<ITerm, ITerm>> entrySet() {
        return this.replacement.entrySet();
    }

    @Override
    public ITerm replace(ITerm term) {
        return (ITerm)this.replacement.getOrDefault((Object)term, (Object)term);
    }

    @Override
    public ITerm apply(ITerm term) {
        return term.match(Terms.cases(appl -> {
            IApplTerm newAppl = (IApplTerm)this.replace(term);
            if (!this.traverseSubTerms) {
                return newAppl;
            }
            ImmutableList<ITerm> newArgs = Terms.applyLazy(newAppl.getArgs(), this::apply);
            if (newArgs == null) {
                return newAppl;
            }
            return TermBuild.B.newAppl(newAppl.getOp(), (Iterable<? extends ITerm>)newArgs, appl.getAttachments());
        }, list -> this.apply((IListTerm)list), string -> this.replace((ITerm)string), integer -> this.replace((ITerm)integer), blob -> this.replace((ITerm)blob), var -> var));
    }

    private IListTerm apply(IListTerm list) {
        IListTerm newList = (IListTerm)this.replace(list);
        if (!this.traverseSubTerms) {
            return newList;
        }
        return newList.match(ListTerms.cases(cons -> {
            ITerm newHead = this.apply(cons.getHead());
            IListTerm newTail = this.apply(cons.getTail());
            if (newHead != cons.getHead() || newTail != cons.getTail()) {
                TermBuild.B.newCons(newHead, newTail, cons.getAttachments());
            }
            return cons;
        }, nil -> nil, var -> var));
    }

    public String toString() {
        return this.replacement.entrySet().stream().map(e -> e.getKey() + " |-> " + e.getValue()).collect(Collectors.joining(", ", "{", "}"));
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ Replacement(BiMap biMap, boolean bl, Replacement replacement) {
        this((BiMap<ITerm, ITerm>)biMap, bl);
    }

    public static class Builder {
        private boolean traverseSubTerms = false;
        private final BiMap<ITerm, ITerm> replacement = HashBiMap.create();

        private Builder() {
        }

        public boolean containsKey(ITermVar var) {
            return this.replacement.containsKey((Object)var);
        }

        public boolean containsValue(ITermVar var) {
            return this.replacement.containsValue((Object)var);
        }

        public Builder put(boolean traverseSubTerms) {
            this.traverseSubTerms = traverseSubTerms;
            return this;
        }

        public Builder put(ITerm v1, ITerm v2) {
            if (!v1.isGround() || !v2.isGround()) {
                throw new IllegalStateException("Use unification or renaming to change unification variables.");
            }
            if (!v1.equals(v2)) {
                this.replacement.put((Object)v1, (Object)v2);
            }
            return this;
        }

        public Replacement build() {
            return new Replacement(this.replacement, this.traverseSubTerms, null);
        }
    }
}

