/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.matching;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.usethesource.capsule.Map;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.IBlobTerm;
import mb.nabl2.terms.IConsTerm;
import mb.nabl2.terms.IIntTerm;
import mb.nabl2.terms.IListTerm;
import mb.nabl2.terms.INilTerm;
import mb.nabl2.terms.IStringTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.ListTerms;
import mb.nabl2.terms.Terms;
import mb.nabl2.terms.unification.Unifiers;
import mb.nabl2.terms.unification.u.IUnifier;
import org.metaborg.util.Ref;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.functions.Function2;
import org.metaborg.util.functions.Function3;
import org.metaborg.util.functions.Function4;
import org.metaborg.util.functions.Function5;
import org.metaborg.util.functions.Function6;
import org.metaborg.util.functions.Function7;
import org.metaborg.util.optionals.Optionals;
import org.metaborg.util.tuple.Tuple2;

public class TermMatch {
    public static final M M = new M();

    @FunctionalInterface
    public static interface IMatcher<T> {
        public Optional<T> match(ITerm var1, IUnifier var2);

        default public Optional<T> match(ITerm term) {
            return this.match(term, Unifiers.Immutable.of());
        }

        default public <R> IMatcher<R> map(Function<T, R> fun) {
            return (term, unifier) -> {
                Optional<T> result = this.match(term, unifier);
                if (result.isPresent()) {
                    return Optional.of(fun.apply(result.get()));
                }
                return Optional.empty();
            };
        }

        default public IMatcher<T> filter(Predicate<T> pred) {
            return (term, unifier) -> {
                Optional<T> result = this.match(term, unifier);
                if (result.isPresent() && pred.test(result.get())) {
                    return result;
                }
                return Optional.empty();
            };
        }

        default public <R> IMatcher<R> flatMap(Function<T, Optional<R>> fun) {
            return (term, unifier) -> {
                Optional<T> result = this.match(term, unifier);
                if (result.isPresent()) {
                    return (Optional)fun.apply(result.get());
                }
                return Optional.empty();
            };
        }

        public static <T> IMatcher<T> flatten(IMatcher<Optional<T>> m) {
            return m.flatMap(o -> o)::match;
        }
    }

    public static class M {
        public IMatcher<ITerm> term() {
            return (term, unifier) -> Optional.of(term);
        }

        public <R> IMatcher<R> term(Function1<? super ITerm, R> f) {
            return (term, unifier) -> Optional.of(f.apply(term));
        }

        public <T, R> IMatcher<R> term(IMatcher<? extends T> m, Function2<? super ITerm, ? super T, R> f) {
            return (term, unifier) -> m.match(term, unifier).map(t -> f.apply(term, (Object)t));
        }

        public <R> IMatcher<R> term(ITerm.Cases<Optional<R>> cases) {
            return (term, unifier) -> (Optional)unifier.findTerm(term).match(cases);
        }

        public IMatcher<IApplTerm> appl() {
            return (term, unifier) -> unifier.findTerm(term).match(Terms.cases(Optional::of, this::empty, this::empty, this::empty, this::empty, this::empty));
        }

        public <R> IMatcher<R> appl(String op, Function1<? super IApplTerm, R> f) {
            return this.flatten(this.appl(appl -> appl.getOp().equals(op) ? Optional.of(f.apply((IApplTerm)appl)) : Optional.empty()));
        }

        public <R> IMatcher<R> appl(Function1<? super IApplTerm, R> f) {
            return (term, unifier) -> unifier.findTerm(term).match(Terms.cases(appl -> Optional.of(f.apply((IApplTerm)appl)), this::empty, this::empty, this::empty, this::empty, this::empty));
        }

        public IMatcher<IApplTerm> appl0(String op) {
            return this.appl0(op, appl -> appl);
        }

        public <R> IMatcher<R> appl0(String op, Function1<? super IApplTerm, R> f) {
            return (term, unifier) -> unifier.findTerm(term).match(Terms.cases(appl -> {
                if (appl.getArity() != 0 || !op.equals(appl.getOp())) {
                    return Optional.empty();
                }
                return Optional.of(f.apply((IApplTerm)appl));
            }, this::empty, this::empty, this::empty, this::empty, this::empty));
        }

        public <T> IMatcher<IApplTerm> appl1(String op, IMatcher<? extends T> m) {
            return this.appl1(op, m, (appl, t) -> appl);
        }

        public <T, R> IMatcher<R> appl1(String op, IMatcher<? extends T> m, Function2<? super IApplTerm, ? super T, R> f) {
            return (term, unifier) -> unifier.findTerm(term).match(Terms.cases(appl -> {
                if (appl.getArity() != 1 || !op.equals(appl.getOp())) {
                    return Optional.empty();
                }
                return m.match(appl.getArgs().get(0), unifier).map(t -> f.apply((IApplTerm)appl, (Object)t));
            }, this::empty, this::empty, this::empty, this::empty, this::empty));
        }

        public <T1, T2> IMatcher<IApplTerm> appl2(String op, IMatcher<? extends T1> m1, IMatcher<? extends T2> m2) {
            return this.appl2(op, m1, m2, (appl, t1, t2) -> appl);
        }

        public <T1, T2, R> IMatcher<R> appl2(String op, IMatcher<? extends T1> m1, IMatcher<? extends T2> m2, Function3<? super IApplTerm, ? super T1, ? super T2, R> f) {
            return (term, unifier) -> unifier.findTerm(term).match(Terms.cases(appl -> {
                if (appl.getArity() != 2 || !op.equals(appl.getOp())) {
                    return Optional.empty();
                }
                Optional o1 = m1.match(appl.getArgs().get(0), unifier);
                Optional o2 = m2.match(appl.getArgs().get(1), unifier);
                return Optionals.lift(o1, o2, (t1, t2) -> f.apply((IApplTerm)appl, (Object)t1, (Object)t2));
            }, this::empty, this::empty, this::empty, this::empty, this::empty));
        }

        public <T1, T2, T3> IMatcher<IApplTerm> appl3(String op, IMatcher<? extends T1> m1, IMatcher<? extends T2> m2, IMatcher<T3> m3) {
            return this.appl3(op, m1, m2, m3, (appl, t1, t2, t3) -> appl);
        }

        public <T1, T2, T3, R> IMatcher<R> appl3(String op, IMatcher<? extends T1> m1, IMatcher<? extends T2> m2, IMatcher<? extends T3> m3, Function4<? super IApplTerm, ? super T1, ? super T2, ? super T3, R> f) {
            return (term, unifier) -> unifier.findTerm(term).match(Terms.cases(appl -> {
                if (appl.getArity() != 3 || !op.equals(appl.getOp())) {
                    return Optional.empty();
                }
                Optional o1 = m1.match(appl.getArgs().get(0), unifier);
                Optional o2 = m2.match(appl.getArgs().get(1), unifier);
                Optional o3 = m3.match(appl.getArgs().get(2), unifier);
                return Optionals.lift(o1, o2, o3, (t1, t2, t3) -> f.apply((IApplTerm)appl, (Object)t1, (Object)t2, (Object)t3));
            }, this::empty, this::empty, this::empty, this::empty, this::empty));
        }

        public <T1, T2, T3, T4> IMatcher<IApplTerm> appl4(String op, IMatcher<? extends T1> m1, IMatcher<? extends T2> m2, IMatcher<T3> m3, IMatcher<T4> m4) {
            return this.appl4(op, m1, m2, m3, m4, (appl, t1, t2, t3, t4) -> appl);
        }

        public <T1, T2, T3, T4, R> IMatcher<R> appl4(String op, IMatcher<? extends T1> m1, IMatcher<? extends T2> m2, IMatcher<? extends T3> m3, IMatcher<? extends T4> m4, Function5<? super IApplTerm, ? super T1, ? super T2, ? super T3, ? super T4, R> f) {
            return (term, unifier) -> unifier.findTerm(term).match(Terms.cases(appl -> {
                if (appl.getArity() != 4 || !op.equals(appl.getOp())) {
                    return Optional.empty();
                }
                Optional o1 = m1.match(appl.getArgs().get(0), unifier);
                Optional o2 = m2.match(appl.getArgs().get(1), unifier);
                Optional o3 = m3.match(appl.getArgs().get(2), unifier);
                Optional o4 = m4.match(appl.getArgs().get(3), unifier);
                return Optionals.lift(o1, o2, o3, o4, (t1, t2, t3, t4) -> f.apply((IApplTerm)appl, (Object)t1, (Object)t2, (Object)t3, (Object)t4));
            }, this::empty, this::empty, this::empty, this::empty, this::empty));
        }

        public <T1, T2, T3, T4, T5> IMatcher<IApplTerm> appl5(String op, IMatcher<? extends T1> m1, IMatcher<? extends T2> m2, IMatcher<T3> m3, IMatcher<T4> m4, IMatcher<T5> m5) {
            return this.appl5(op, m1, m2, m3, m4, m5, (appl, t1, t2, t3, t4, t5) -> appl);
        }

        public <T1, T2, T3, T4, T5, R> IMatcher<R> appl5(String op, IMatcher<? extends T1> m1, IMatcher<? extends T2> m2, IMatcher<? extends T3> m3, IMatcher<? extends T4> m4, IMatcher<? extends T5> m5, Function6<? super IApplTerm, ? super T1, ? super T2, ? super T3, ? super T4, ? super T5, R> f) {
            return (term, unifier) -> unifier.findTerm(term).match(Terms.cases(appl -> {
                if (appl.getArity() != 5 || !op.equals(appl.getOp())) {
                    return Optional.empty();
                }
                Optional o1 = m1.match(appl.getArgs().get(0), unifier);
                Optional o2 = m2.match(appl.getArgs().get(1), unifier);
                Optional o3 = m3.match(appl.getArgs().get(2), unifier);
                Optional o4 = m4.match(appl.getArgs().get(3), unifier);
                Optional o5 = m5.match(appl.getArgs().get(4), unifier);
                return Optionals.lift(o1, o2, o3, o4, o5, (t1, t2, t3, t4, t5) -> f.apply((IApplTerm)appl, (Object)t1, (Object)t2, (Object)t3, (Object)t4, (Object)t5));
            }, this::empty, this::empty, this::empty, this::empty, this::empty));
        }

        public <T1, T2, T3, T4, T5, T6> IMatcher<IApplTerm> appl6(String op, IMatcher<? extends T1> m1, IMatcher<? extends T2> m2, IMatcher<T3> m3, IMatcher<T4> m4, IMatcher<T5> m5, IMatcher<T6> m6) {
            return this.appl6(op, m1, m2, m3, m4, m5, m6, (appl, t1, t2, t3, t4, t5, t6) -> appl);
        }

        public <T1, T2, T3, T4, T5, T6, R> IMatcher<R> appl6(String op, IMatcher<? extends T1> m1, IMatcher<? extends T2> m2, IMatcher<? extends T3> m3, IMatcher<? extends T4> m4, IMatcher<? extends T5> m5, IMatcher<T6> m6, Function7<? super IApplTerm, ? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, R> f) {
            return (term, unifier) -> unifier.findTerm(term).match(Terms.cases(appl -> {
                if (appl.getArity() != 6 || !op.equals(appl.getOp())) {
                    return Optional.empty();
                }
                Optional o1 = m1.match(appl.getArgs().get(0), unifier);
                Optional o2 = m2.match(appl.getArgs().get(1), unifier);
                Optional o3 = m3.match(appl.getArgs().get(2), unifier);
                Optional o4 = m4.match(appl.getArgs().get(3), unifier);
                Optional o5 = m5.match(appl.getArgs().get(4), unifier);
                Optional o6 = m6.match(appl.getArgs().get(5), unifier);
                return Optionals.lift(o1, o2, o3, o4, o5, o6, (t1, t2, t3, t4, t5, t6) -> f.apply((IApplTerm)appl, (Object)t1, (Object)t2, (Object)t3, (Object)t4, (Object)t5, (Object)t6));
            }, this::empty, this::empty, this::empty, this::empty, this::empty));
        }

        public <R> IMatcher<R> tuple(Function1<? super IApplTerm, R> f) {
            return M.appl("", f);
        }

        public IMatcher<IApplTerm> tuple0() {
            return M.appl0("");
        }

        public <R> IMatcher<R> tuple0(Function1<? super IApplTerm, R> f) {
            return M.appl0("", f);
        }

        public <T> IMatcher<IApplTerm> tuple1(IMatcher<? extends T> m) {
            return M.appl1("", m);
        }

        public <T, R> IMatcher<R> tuple1(IMatcher<? extends T> m, Function2<? super IApplTerm, ? super T, R> f) {
            return M.appl1("", m, f);
        }

        public <T1, T2> IMatcher<IApplTerm> tuple2(IMatcher<? extends T1> m1, IMatcher<? extends T2> m2) {
            return M.appl2("", m1, m2);
        }

        public <T1, T2, R> IMatcher<R> tuple2(IMatcher<? extends T1> m1, IMatcher<? extends T2> m2, Function3<? super IApplTerm, ? super T1, ? super T2, R> f) {
            return M.appl2("", m1, m2, f);
        }

        public <T1, T2, T3> IMatcher<IApplTerm> tuple3(IMatcher<? extends T1> m1, IMatcher<? extends T2> m2, IMatcher<? extends T3> m3) {
            return M.appl3("", m1, m2, m3);
        }

        public <T1, T2, T3, R> IMatcher<R> tuple3(IMatcher<? extends T1> m1, IMatcher<? extends T2> m2, IMatcher<? extends T3> m3, Function4<? super IApplTerm, ? super T1, ? super T2, ? super T3, R> f) {
            return M.appl3("", m1, m2, m3, f);
        }

        public <T1, T2, T3, T4> IMatcher<IApplTerm> tuple4(IMatcher<? extends T1> m1, IMatcher<? extends T2> m2, IMatcher<? extends T3> m3, IMatcher<? extends T4> m4) {
            return M.appl4("", m1, m2, m3, m4);
        }

        public <T1, T2, T3, T4, R> IMatcher<R> tuple4(IMatcher<? extends T1> m1, IMatcher<? extends T2> m2, IMatcher<? extends T3> m3, IMatcher<? extends T4> m4, Function5<? super IApplTerm, ? super T1, ? super T2, ? super T3, ? super T4, R> f) {
            return M.appl4("", m1, m2, m3, m4, f);
        }

        public <T1, T2, T3, T4, T5> IMatcher<IApplTerm> tuple5(IMatcher<? extends T1> m1, IMatcher<? extends T2> m2, IMatcher<? extends T3> m3, IMatcher<? extends T4> m4, IMatcher<? extends T5> m5) {
            return M.appl5("", m1, m2, m3, m4, m5);
        }

        public <T1, T2, T3, T4, T5, R> IMatcher<R> tuple5(IMatcher<? extends T1> m1, IMatcher<? extends T2> m2, IMatcher<? extends T3> m3, IMatcher<? extends T4> m4, IMatcher<? extends T5> m5, Function6<? super IApplTerm, ? super T1, ? super T2, ? super T3, ? super T4, ? super T5, R> f) {
            return M.appl5("", m1, m2, m3, m4, m5, f);
        }

        public IMatcher<IListTerm> list() {
            return this.list(l -> l);
        }

        public <R> IMatcher<R> list(Function1<? super IListTerm, R> f) {
            Function1<IListTerm, Optional> g = list -> Optional.of(f.apply((IListTerm)list));
            return (term, unifier) -> unifier.findTerm(term).match(Terms.cases(this::empty, g, this::empty, this::empty, this::empty, g));
        }

        public IMatcher<? extends List<? extends ITerm>> listElems() {
            return this.listElems(M.term());
        }

        public <T> IMatcher<List<T>> listElems(IMatcher<T> m) {
            return this.listElems(m, (t, ts) -> ts);
        }

        public <T, R> IMatcher<R> listElems(IMatcher<T> m, Function2<? super IListTerm, ? super ImmutableList<T>, R> f) {
            return (term, unifier) -> unifier.findTerm(term).match(Terms.cases(this::empty, list -> {
                ArrayList os = Lists.newArrayList();
                for (ITerm t : ListTerms.iterable(list)) {
                    os.add(m.match(t, unifier));
                }
                return Optionals.sequence(os).map(ts -> f.apply((IListTerm)list, (Object)ImmutableList.copyOf((Collection)ts)));
            }, this::empty, this::empty, this::empty, this::empty));
        }

        public <R> IMatcher<R> cons(Function1<? super IConsTerm, R> f) {
            return (term, unifier) -> unifier.findTerm(term).match(Terms.cases(this::empty, list -> list.match(ListTerms.cases(cons -> Optional.of(f.apply((IConsTerm)cons)), nil -> Optional.empty(), var -> Optional.empty())), this::empty, this::empty, this::empty, this::empty));
        }

        public <THd, TTl, R> IMatcher<R> cons(IMatcher<? extends THd> mhd, IMatcher<? extends TTl> mtl, Function3<? super IConsTerm, ? super THd, ? super TTl, R> f) {
            return (term, unifier) -> unifier.findTerm(term).match(Terms.cases(this::empty, list -> list.match(ListTerms.cases(cons -> {
                Optional ohd = mhd.match(cons.getHead(), unifier);
                Optional otl = mtl.match(cons.getTail(), unifier);
                return Optionals.lift(ohd, otl, (thd, ttl) -> f.apply((IConsTerm)cons, (Object)thd, (Object)ttl));
            }, this::empty, this::empty)), this::empty, this::empty, this::empty, this::empty));
        }

        public IMatcher<INilTerm> nil() {
            return this.nil(t -> t);
        }

        public <R> IMatcher<R> nil(Function1<? super INilTerm, R> f) {
            return (term, unifier) -> unifier.findTerm(term).match(Terms.cases(this::empty, list -> list.match(ListTerms.cases(cons -> Optional.empty(), nil -> Optional.of(f.apply((INilTerm)nil)), var -> Optional.empty())), this::empty, this::empty, this::empty, this::empty));
        }

        public IMatcher<IStringTerm> string() {
            return this.string(s -> s);
        }

        public <R> IMatcher<R> string(Function1<? super IStringTerm, R> f) {
            return (term, unifier) -> unifier.findTerm(term).match(Terms.cases(this::empty, this::empty, string -> Optional.of(f.apply((IStringTerm)string)), this::empty, this::empty, this::empty));
        }

        public IMatcher<String> stringValue() {
            return this.string(s -> s.getValue());
        }

        public IMatcher<IIntTerm> integer() {
            return this.integer(i -> i);
        }

        public <R> IMatcher<R> integer(Function1<? super IIntTerm, R> f) {
            return (term, unifier) -> unifier.findTerm(term).match(Terms.cases(this::empty, this::empty, this::empty, integer -> Optional.of(f.apply((IIntTerm)integer)), this::empty, this::empty));
        }

        public IMatcher<Integer> integerValue() {
            return this.integer(i -> i.getValue());
        }

        public IMatcher<IBlobTerm> blob() {
            return this.blob(i -> i);
        }

        public <R> IMatcher<R> blob(Function1<? super IBlobTerm, R> f) {
            return (term, unifier) -> unifier.findTerm(term).match(Terms.cases(this::empty, this::empty, this::empty, this::empty, blob -> Optional.of(f.apply((IBlobTerm)blob)), this::empty));
        }

        public <T> IMatcher<T> blobValue(Class<T> blobClass) {
            return (term, unifier) -> this.blob().match(term, unifier).flatMap(b -> {
                if (blobClass.isInstance(b.getValue())) {
                    return Optional.of(b.getValue());
                }
                return Optional.empty();
            });
        }

        public IMatcher<ITermVar> var() {
            return this.var(v -> v);
        }

        public <R> IMatcher<R> var(Function1<? super ITermVar, R> f) {
            return (term, unifier) -> unifier.findTerm(term).match(Terms.cases(this::empty, this::empty, this::empty, this::empty, this::empty, var -> Optional.of(f.apply((ITermVar)var))));
        }

        public IMatcher<ITerm> ground(IMatcher<? extends ITerm> m) {
            return (t, u) -> m.match(t, u).flatMap(t2 -> u.isGround((ITerm)t2) ? Optional.of(u.findRecursive((ITerm)t2)) : Optional.empty());
        }

        public <R> IMatcher<R> flatten(IMatcher<Optional<R>> m) {
            return (term, unifier) -> m.match(term, unifier).flatMap(o -> o);
        }

        @SafeVarargs
        public final <T> IMatcher<T> cases(IMatcher<? extends T> ... matchers) {
            return (term, unifier) -> {
                IMatcher[] iMatcherArray2 = matchers;
                int n = matchers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMatcher matcher = iMatcherArray2[n2];
                    Optional result = matcher.match(term, unifier);
                    if (result.isPresent()) {
                        return Optional.of(result.get());
                    }
                    ++n2;
                }
                return Optional.empty();
            };
        }

        public <T> IMatcher<T> casesFix(Function1<IMatcher<T>, Iterable<IMatcher<? extends T>>> f) {
            Ref ref = new Ref();
            IMatcher fix = (term, unifier) -> ((IMatcher)ref.get()).match(term, unifier);
            ref.set((term, unifier) -> {
                for (IMatcher matcher : (Iterable)f.apply(fix)) {
                    Optional result = matcher.match(term, unifier);
                    if (!result.isPresent()) continue;
                    return Optional.of(result.get());
                }
                return Optional.empty();
            });
            return (IMatcher)ref.get();
        }

        public <R> IMatcher<R> req(IMatcher<R> matcher) {
            return this.req("Cannot match", matcher);
        }

        public <R> IMatcher<R> req(String msg, IMatcher<R> matcher) {
            return (term, unifier) -> matcher.match(term, unifier).map(Optional::of).orElseThrow(() -> new IllegalArgumentException(String.valueOf(msg) + ": " + Unifiers.Immutable.of().toString(term, 4)));
        }

        public <R extends ITerm> IMatcher<R> preserveAttachments(IMatcher<R> matcher) {
            return (term, unifier) -> matcher.match(term, unifier).map(r -> r.withAttachments(term.getAttachments()));
        }

        public <K, V> IMatcher<Map.Immutable<K, V>> map(IMatcher<K> keyMatcher, IMatcher<V> valueMatcher) {
            return this.listElems(this.tuple2(keyMatcher, valueMatcher, (e, k, v) -> Tuple2.of(k, v)), (t, es) -> {
                Map.Transient map = Map.Transient.of();
                for (Tuple2 e : es) {
                    Object key = e._1();
                    if (map.containsKey(key)) {
                        throw new IllegalArgumentException("Map already contains key " + key);
                    }
                    map.__put(key, e._2());
                }
                return map.freeze();
            });
        }

        public <R> IMatcher<Optional<R>> option(IMatcher<R> matcher) {
            return this.cases(this.appl0("None", t -> Optional.empty()), this.appl1("Some", matcher, (t, e) -> Optional.of(e)));
        }

        private <T> Optional<T> empty(ITerm term) {
            return Optional.empty();
        }
    }
}

