/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.matching;

import io.usethesource.capsule.Set;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.Attachments;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.Pattern;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.unification.u.IUnifier;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Action2;
import org.metaborg.util.functions.Function0;
import org.metaborg.util.functions.Function1;

public final class PatternVar
extends Pattern {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final ITermVar var;

    PatternVar() {
        super(Attachments.empty());
        this.var = null;
    }

    PatternVar(String name) {
        this(TermBuild.B.newVar("", name));
    }

    PatternVar(ITermVar var) {
        super(var != null ? var.getAttachments() : Attachments.empty());
        if (var == null) {
            throw new IllegalArgumentException();
        }
        this.var = var;
    }

    @Nullable
    ITermVar getVar() {
        return this.var;
    }

    @Override
    public boolean isConstructed() {
        return false;
    }

    public boolean isWildcard() {
        return this.var == null;
    }

    public Set<ITermVar> getVars() {
        return this.isWildcard() ? CapsuleUtil.immutableSet() : CapsuleUtil.immutableSet(this.var);
    }

    @Override
    protected boolean matchTerm(ITerm term, ISubstitution.Transient subst, IUnifier.Immutable unifier, Pattern.Eqs eqs) {
        if (this.isWildcard()) {
            return true;
        }
        if (subst.contains(this.var)) {
            IUnifier.Immutable diff = unifier.diff(subst.apply(this.var), term).orElse(null);
            if (diff == null) {
                return false;
            }
            for (ITermVar var : diff.domainSet()) {
                eqs.add(var, diff.findTerm(var));
            }
            return true;
        }
        subst.put(this.var, term);
        return true;
    }

    @Override
    public PatternVar apply(IRenaming subst) {
        return this.isWildcard() ? this : new PatternVar(subst.rename(this.var));
    }

    @Override
    public PatternVar eliminateWld(Function0<ITermVar> fresh) {
        return this.isWildcard() ? new PatternVar(fresh.apply()) : this;
    }

    @Override
    protected ITerm asTerm(Action2<ITermVar, ITerm> equalities, Function1<Optional<ITermVar>, ITermVar> fresh) {
        return fresh.apply(Optional.ofNullable(this.var));
    }

    public String toString() {
        return this.isWildcard() ? "_" : this.var.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternVar that = (PatternVar)o;
        return Objects.equals(this.var, that.var);
    }

    public int hashCode() {
        return Objects.hash(this.var);
    }
}

