/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.spoofax.primitives;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.Interpreter;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.UndefinedStrategyException;
import org.spoofax.interpreter.stratego.SDefT;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.strategoxt.HybridInterpreter;
import org.strategoxt.lang.InteropContext;

public class StrategyCalls {
    public static CallableStrategy lookup(IContext env, String name) throws InterpreterException {
        return StrategyCalls.lookup(env, name, null);
    }

    public static CallableStrategy lookup(IContext env, String name, @Nullable Map<String, SDefT> strCache) throws InterpreterException {
        if (env instanceof InteropContext) {
            return StrategyCalls.lookupStrategyJar((InteropContext)env, name);
        }
        return StrategyCalls.lookupStrategyCtree(env, name, strCache);
    }

    private static CallableStrategy lookupStrategyJar(InteropContext context, String name) throws InterpreterException {
        HybridInterpreter interpreter = HybridInterpreter.getInterpreter(context.getContext());
        if (interpreter == null) {
            throw new InterpreterException("Cannot get interpreter.");
        }
        return arg -> {
            IStrategoTerm prev = interpreter.current();
            interpreter.setCurrent(arg);
            try {
                if (!interpreter.invoke(name)) {
                    Optional optional = Optional.empty();
                    return optional;
                }
                Optional<IStrategoTerm> optional = Optional.of(interpreter.current());
                return optional;
            }
            finally {
                interpreter.setCurrent(prev);
            }
        };
    }

    private static CallableStrategy lookupStrategyCtree(IContext env, String name, @Nullable Map<String, SDefT> strCache) throws InterpreterException {
        SDefT s;
        String cname = String.valueOf(Interpreter.cify(name)) + "_0_0";
        if (strCache != null && strCache.containsKey(cname)) {
            s = strCache.get(cname);
        } else {
            s = env.lookupSVar(cname);
            if (s == null) {
                throw new UndefinedStrategyException("Strategy lookup failed.", name);
            }
            if (strCache != null) {
                strCache.put(cname, s);
            }
        }
        return arg -> {
            IStrategoTerm prev = env.current();
            env.setCurrent(arg);
            try {
                if (!s.evaluate(env)) {
                    Optional optional = Optional.empty();
                    return optional;
                }
                Optional<IStrategoTerm> optional = Optional.of(env.current());
                return optional;
            }
            finally {
                env.setCurrent(prev);
            }
        };
    }

    public static interface CallableStrategy {
        public Optional<IStrategoTerm> call(IStrategoTerm var1) throws InterpreterException;
    }
}

