/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter.locals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import java.util.concurrent.locks.Lock;
import mb.flowspec.runtime.interpreter.expressions.ExpressionNode;
import mb.flowspec.runtime.interpreter.locals.WriteVarNode;

@GeneratedBy(value=WriteVarNode.class)
public final class WriteVarNodeGen
extends WriteVarNode {
    private final FrameSlot slot;
    @Node.Child
    private ExpressionNode valNode_;
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;

    private WriteVarNodeGen(ExpressionNode valNode, FrameSlot slot) {
        this.slot = slot;
        this.valNode_ = valNode;
    }

    @Override
    protected FrameSlot getSlot() {
        return this.slot;
    }

    @Override
    public void execute(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 6) == 0 && state != 0) {
            this.execute_int0(frameValue, state);
            return;
        }
        if ((state & 5) == 0 && state != 0) {
            this.execute_boolean1(frameValue, state);
            return;
        }
        this.execute_generic2(frameValue, state);
    }

    private void execute_int0(VirtualFrame frameValue, int state) {
        int valNodeValue_;
        try {
            valNodeValue_ = this.valNode_.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            this.executeAndSpecialize(frameValue, ex.getResult());
            return;
        }
        assert ((state & 1) != 0);
        if (this.isInt(frameValue)) {
            this.writeInt(frameValue, valNodeValue_);
            return;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(frameValue, valNodeValue_);
    }

    private void execute_boolean1(VirtualFrame frameValue, int state) {
        boolean valNodeValue_;
        try {
            valNodeValue_ = this.valNode_.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            this.executeAndSpecialize(frameValue, ex.getResult());
            return;
        }
        assert ((state & 2) != 0);
        if (this.isBoolean(frameValue)) {
            this.writeBoolean(frameValue, valNodeValue_);
            return;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(frameValue, valNodeValue_);
    }

    private void execute_generic2(VirtualFrame frameValue, int state) {
        Object valNodeValue_ = this.valNode_.executeGeneric(frameValue);
        if ((state & 1) != 0 && valNodeValue_ instanceof Integer) {
            int n = (Integer)valNodeValue_;
            if (this.isInt(frameValue)) {
                this.writeInt(frameValue, n);
                return;
            }
        }
        if ((state & 2) != 0 && valNodeValue_ instanceof Boolean) {
            boolean bl = (Boolean)valNodeValue_;
            if (this.isBoolean(frameValue)) {
                this.writeBoolean(frameValue, bl);
                return;
            }
        }
        if ((state & 4) != 0) {
            this.writeObject(frameValue, valNodeValue_);
            return;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(frameValue, valNodeValue_);
    }

    private void executeAndSpecialize(VirtualFrame frameValue, Object valNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if ((exclude & 1) == 0 && valNodeValue instanceof Integer) {
                int n = (Integer)valNodeValue;
                if (this.isInt(frameValue)) {
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    this.writeInt(frameValue, n);
                    return;
                }
            }
            if ((exclude & 2) == 0 && valNodeValue instanceof Boolean) {
                boolean bl = (Boolean)valNodeValue;
                if (this.isBoolean(frameValue)) {
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    this.writeBoolean(frameValue, bl);
                    return;
                }
            }
            this.exclude_ = exclude |= 3;
            state &= 0xFFFFFFFC;
            this.state_ = state |= 4;
            lock.unlock();
            hasLock = false;
            this.writeObject(frameValue, valNodeValue);
            return;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static WriteVarNode create(ExpressionNode valNode, FrameSlot slot) {
        return new WriteVarNodeGen(valNode, slot);
    }
}

