/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.client;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import oracle.pgx.api.internal.ProxyException;
import oracle.pgx.client.RemoteIteratorUtils;
import oracle.pgx.common.util.ErrorMessages;
import org.apache.http.client.fluent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteIterator<T>
implements Iterator<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRemoteIterator.class);
    private final Queue<T> elementCache;
    private final Executor httpExecutor;
    private final String requestUrl;
    private final String proxyId;
    private boolean hasReachedEnd = false;
    private int currentTailPosition = 0;
    protected final int prefetchSize;

    public AbstractRemoteIterator(Executor httpExecutor, String requestUrl, String proxyId, int prefetchSize) {
        this.httpExecutor = httpExecutor;
        this.requestUrl = requestUrl;
        this.proxyId = proxyId;
        this.prefetchSize = prefetchSize;
        this.elementCache = new LinkedList<T>();
    }

    private synchronized void prefetch() {
        if (this.hasReachedEnd) {
            throw new ProxyException(ErrorMessages.getMessage((String)"FETCH_NO_MORE_RESULTS", (Object[])new Object[0]));
        }
        try {
            String response = RemoteIteratorUtils.prefetch(this.httpExecutor, this.requestUrl, this.proxyId, this.currentTailPosition, this.prefetchSize);
            Collection<T> fetchedValues = this.parseResults(response);
            this.elementCache.addAll(fetchedValues);
            this.currentTailPosition += fetchedValues.size();
            if (fetchedValues.size() < this.prefetchSize) {
                this.hasReachedEnd = true;
            }
        }
        catch (IOException e) {
            throw new ProxyException(ErrorMessages.getMessage((String)"FETCH_RESULTS_COMMUNICATION_ERROR", (Object[])new Object[0]));
        }
    }

    protected abstract Collection<T> parseResults(String var1) throws JsonParseException, JsonMappingException, IOException;

    @Override
    public synchronized boolean hasNext() {
        if (this.elementCache.isEmpty() && this.hasReachedEnd) {
            return false;
        }
        if (this.elementCache.isEmpty() && !this.hasReachedEnd) {
            this.prefetch();
        }
        return !this.elementCache.isEmpty();
    }

    @Override
    public synchronized T next() {
        if (this.hasNext()) {
            return this.elementCache.poll();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"CANNOT_REMOVE_COLLECTION_ELEMENT", (Object[])new Object[0]));
    }
}

