/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import oracle.jdbc.OracleClob;
import oracle.spatial.util.SchemaEntityResolver;
import oracle.sql.CLOB;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLParseException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLValidator2 {
    protected HashMap cache = new HashMap();
    protected EntityResolver resolver;
    protected ByteArrayOutputStream errors;

    public XMLValidator2(Connection connection) {
        this.resolver = new SchemaEntityResolver(connection);
        this.errors = new ByteArrayOutputStream();
    }

    public String getErrors() {
        return this.errors.toString();
    }

    public int isSchemaValid(CLOB cLOB, String string) {
        try {
            this.schemaValidate(cLOB, string);
        }
        catch (Exception exception) {
            return 0;
        }
        return 1;
    }

    public int isSchemaValid(OracleClob oracleClob, String string) {
        try {
            this.schemaValidate(oracleClob, string);
        }
        catch (Exception exception) {
            return 0;
        }
        return 1;
    }

    public void schemaValidate(CLOB cLOB, String string) throws XMLParseException, SAXException, IOException, XSDException, SQLException, Exception {
        DOMParser dOMParser = (DOMParser)this.cache.get(string);
        if (dOMParser == null) {
            XSDBuilder xSDBuilder = new XSDBuilder();
            xSDBuilder.setEntityResolver(this.resolver);
            XMLSchema xMLSchema = null;
            try {
                xMLSchema = xSDBuilder.build(this.resolver.resolveEntity(null, string));
            }
            catch (Exception exception) {
                System.out.println("XSDBuilder Exception: " + exception.getMessage());
                throw exception;
            }
            dOMParser = new DOMParser();
            dOMParser.setXMLSchema((Object)xMLSchema);
            dOMParser.setValidationMode(3);
            dOMParser.setErrorStream((OutputStream)this.errors);
            this.cache.put(string, dOMParser);
        }
        this.errors.reset();
        dOMParser.reset();
        try {
            dOMParser.parse(new InputSource(cLOB.getCharacterStream()));
        }
        catch (XMLParseException xMLParseException) {
            xMLParseException.printStackTrace();
            System.out.println("ParserException: " + xMLParseException.getMessage());
            throw xMLParseException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("");
            System.out.println("NonParserException: " + exception.getMessage());
            throw exception;
        }
        dOMParser.reset();
    }

    public void schemaValidate(OracleClob oracleClob, String string) throws XMLParseException, SAXException, IOException, XSDException, SQLException, Exception {
        DOMParser dOMParser = (DOMParser)this.cache.get(string);
        if (dOMParser == null) {
            XSDBuilder xSDBuilder = new XSDBuilder();
            xSDBuilder.setEntityResolver(this.resolver);
            XMLSchema xMLSchema = null;
            try {
                xMLSchema = xSDBuilder.build(this.resolver.resolveEntity(null, string));
            }
            catch (Exception exception) {
                System.out.println("XSDBuilder Exception: " + exception.getMessage());
                throw exception;
            }
            dOMParser = new DOMParser();
            dOMParser.setXMLSchema((Object)xMLSchema);
            dOMParser.setValidationMode(3);
            dOMParser.setErrorStream((OutputStream)this.errors);
            this.cache.put(string, dOMParser);
        }
        this.errors.reset();
        dOMParser.reset();
        try {
            dOMParser.parse(new InputSource(oracleClob.getCharacterStream()));
        }
        catch (XMLParseException xMLParseException) {
            xMLParseException.printStackTrace();
            System.out.println("ParserException: " + xMLParseException.getMessage());
            throw xMLParseException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("");
            System.out.println("NonParserException: " + exception.getMessage());
            throw exception;
        }
        dOMParser.reset();
    }
}

