/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.sql.Struct;
import java.util.EnumSet;
import java.util.Vector;
import oracle.spatial.geometry.FastJGeometry;
import oracle.spatial.geometry.JGeometry;

public class SdoPointInPolygon {
    static final Vector<JGeometry> polygons = new Vector();

    public static int registerPolygon(Struct struct) {
        JGeometry jGeometry;
        try {
            jGeometry = JGeometry.loadJS((Struct)struct);
            jGeometry = new FastJGeometry(jGeometry, 0.0, EnumSet.of(FastJGeometry.FastOp.ANYINTERACT), false);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        for (int i = 0; i < polygons.size(); ++i) {
            if (polygons.get(i) != null) continue;
            polygons.set(i, jGeometry);
            return i;
        }
        polygons.add(jGeometry);
        return polygons.size() - 1;
    }

    public static void deregisterPolygon(int n) {
        polygons.set(n, null);
    }

    public static int isWithinPolygon(int n, double d, double d2) {
        JGeometry jGeometry = polygons.get(n);
        try {
            if (jGeometry.anyInteract(new JGeometry(d, d2, jGeometry.getSRID()), 0.0, "FALSE")) {
                return 1;
            }
            return 0;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    static {
        polygons.add(null);
    }
}

