/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;
import oracle.jdbc.LargeObjectAccessMode;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleConnection;
import oracle.spatial.geometry.DataException;
import oracle.spatial.geometry.ElementExtractor;
import oracle.spatial.geometry.J3D_Geometry;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.CLOB;
import oracle.sql.STRUCT;

public class KML2 {
    private int extrudeFlag = 0;
    private int tessellateFlag = 0;
    private String altitudeModeFlag = "relativeToGround";
    private String altitude;
    private String region;
    private String lod;
    private String latlonbox;
    private String schema;
    private String lookat;
    protected static Connection _conn;
    protected static String _srsNameSpace;
    protected static String _srsAlias;

    public static void setConnection(Connection connection) {
        _conn = connection;
    }

    public static void setsrsNameSpace(String string) {
        _srsNameSpace = string;
    }

    public static void setsrsAlias(String string) {
        _srsAlias = string;
    }

    protected void CCWOutputRectangle(int n, double[] dArray, int n2, StringBuffer stringBuffer) throws IOException {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (n == 2) {
            d = dArray[n2];
            d3 = dArray[n2 + 1];
            d2 = dArray[n2 + 2];
            d4 = dArray[n2 + 3];
            stringBuffer.append(d + "," + d3 + " " + d2 + "," + d3 + " " + d2 + "," + d4 + " " + d + "," + d4 + " " + d + "," + d3 + " ");
        } else if (n == 3) {
            d = dArray[n2];
            d3 = dArray[n2 + 1];
            d5 = dArray[n2 + 2];
            d2 = dArray[n2 + 3];
            d4 = dArray[n2 + 4];
            d6 = dArray[n2 + 5];
            stringBuffer.append(d + "," + d3 + "," + d5 + " " + d2 + "," + d3 + "," + d5 + " " + d2 + "," + d4 + "," + d5 + " " + d + "," + d4 + "," + d5 + " " + d + "," + d3 + "," + d5 + " ");
        }
    }

    protected void CWOutputRectangle(int n, double[] dArray, int n2, StringBuffer stringBuffer) throws IOException {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (n == 2) {
            d = dArray[n2];
            d3 = dArray[n2 + 1];
            d2 = dArray[n2 + 2];
            d4 = dArray[n2 + 3];
            stringBuffer.append(d + "," + d3 + " " + d + "," + d4 + " " + d2 + "," + d4 + " " + d2 + "," + d3 + " " + d + "," + d3 + " ");
        } else if (n == 3) {
            d = dArray[n2];
            d3 = dArray[n2 + 1];
            d5 = dArray[n2 + 2];
            d2 = dArray[n2 + 3];
            d4 = dArray[n2 + 4];
            d6 = dArray[n2 + 5];
            stringBuffer.append(d + "," + d3 + "," + d5 + " " + d + "," + d4 + "," + d5 + " " + d2 + "," + d4 + "," + d5 + " " + d2 + "," + d3 + "," + d5 + " " + d + "," + d3 + "," + d5 + " ");
        }
    }

    protected void outputCoordinates(int n, int n2, double[] dArray, int n3, StringBuffer stringBuffer) throws IOException {
        for (int i = 1; i <= n2; ++i) {
            stringBuffer.append(dArray[n3 + (i - 1) * n] + "," + dArray[n3 + (i - 1) * n + 1]);
            if (n == 3) {
                stringBuffer.append("," + dArray[n3 + (i - 1) * n + 2]);
            }
            stringBuffer.append(" ");
        }
    }

    protected boolean geometryHasArcs(JGeometry jGeometry, int n) {
        boolean bl = false;
        int[] nArray = jGeometry.getElemInfo();
        if (n != 3) {
            if (jGeometry.getElemInfo() == null || jGeometry.getOrdinatesArray() == null) {
                bl = false;
                return bl;
            }
            int n2 = jGeometry.getElemInfo().length / 3;
            for (int i = 0; i < n2 && !bl; ++i) {
                if (nArray[3 * i + 2] == 2 && nArray[3 * i + 1] % 10 > 1) {
                    bl = true;
                    continue;
                }
                if (nArray[3 * i + 1] % 10 == 3 && nArray[3 * i + 2] == 4) {
                    bl = true;
                    continue;
                }
                if (nArray[3 * i + 1] % 10 <= 3) continue;
                bl = true;
            }
        }
        return bl;
    }

    protected boolean geometryHasEtypeZero(JGeometry jGeometry) {
        boolean bl = false;
        int[] nArray = jGeometry.getElemInfo();
        if (jGeometry.getElemInfo() == null || jGeometry.getOrdinatesArray() == null) {
            bl = false;
            return bl;
        }
        int n = jGeometry.getElemInfo().length / 3;
        for (int i = 0; i < n && !bl; ++i) {
            if (nArray[3 * i + 1] % 10 != 0) continue;
            bl = true;
        }
        return bl;
    }

    protected void toKML(int n, JGeometry jGeometry, StringBuffer stringBuffer) throws SQLException, IOException, DataException, Exception {
        Object object;
        AutoCloseable autoCloseable;
        PreparedStatement preparedStatement;
        String string;
        double[] dArray;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        String string2 = "Unknown";
        int n4 = 0;
        int n5 = 0;
        String string3 = "<coordinates>";
        String string4 = "</coordinates>";
        String string5 = "<outerBoundaryIs>";
        String string6 = "</outerBoundaryIs>";
        String string7 = "<innerBoundaryIs>";
        String string8 = "</innerBoundaryIs>";
        String string9 = "<LinearRing>";
        String string10 = "</LinearRing>";
        int n6 = jGeometry.getType();
        int n7 = jGeometry.getSRID();
        n3 = jGeometry.getDimensions();
        int[] nArray = jGeometry.getElemInfo();
        if (nArray != null) {
            n2 = nArray.length / 3;
        }
        if ((dArray = jGeometry.getOrdinatesArray()) != null) {
            n5 = dArray.length / n3;
        }
        if (n3 == 0) {
            n3 = dArray.length % 2 == 0 ? 2 : 3;
        }
        if (jGeometry == null) {
            throw new DataException("NULL Geometry");
        }
        if (!(!this.geometryHasArcs(jGeometry, n3) || n6 == 3 && jGeometry.getElemInfo()[1] % 1000 == 3 && n3 == 2 || n6 == 3 && jGeometry.getElemInfo()[1] % 1000 == 5 && n3 == 2 || n6 == 2 && jGeometry.getElemInfo()[1] % 1000 == 2 && n3 == 2 || n6 == 2 && jGeometry.getElemInfo()[1] % 1000 == 4 && n3 == 2)) {
            throw new DataException("54554");
        }
        if (this.geometryHasEtypeZero(jGeometry)) {
            throw new DataException("Etype zero not supported in KML2.1");
        }
        if (jGeometry.isLRSGeometry()) {
            throw new DataException("LRS not supported in KML2.1");
        }
        String string11 = "<extrude>" + this.extrudeFlag + "</extrude><tessellate>" + this.tessellateFlag + "</tessellate><altitudeMode>" + this.altitudeModeFlag + "</altitudeMode>";
        if (n6 == 1) {
            string2 = "Point";
            if (nArray != null && nArray[2] > 1) {
                string2 = "MultiGeometry";
                n6 = 5;
            }
        } else if (n6 == 2) {
            string2 = "LineString";
        } else if (n6 == 3) {
            string2 = "Polygon";
            if (nArray[1] % 1000 == 6) {
                string2 = "MultiGeometry";
            }
        } else if (n6 == 4) {
            string2 = "MultiGeometry";
        } else if (n6 == 5) {
            string2 = "MultiGeometry";
        } else if (n6 == 6) {
            string2 = "MultiGeometry";
        } else if (n6 == 7) {
            string2 = "MultiGeometry";
        } else if (n6 == 8) {
            string2 = "MultiGeometry";
            if (nArray[1] % 1000 == 8) {
                string2 = "MultiGeometry";
            }
        } else if (n6 == 9) {
            string2 = "MultiGeometry";
        }
        if (n == 0) {
            if (n7 == 0) {
                stringBuffer.append("<" + string2 + ">");
            } else if (_srsNameSpace == null) {
                stringBuffer.append("<" + string2 + ">");
            } else {
                if (_conn == null) {
                    throw new DataException("KML Converter needs a valid connection and SrsNameSpace");
                }
                string = " select srsname   from MDSYS.SrsNameSpace_Table  where  SrsNameSpace = ? and sdo_srid = ? ";
                preparedStatement = _conn.prepareStatement(string);
                preparedStatement.setString(1, _srsNameSpace);
                preparedStatement.setInt(2, n7);
                autoCloseable = preparedStatement.executeQuery();
                if (!autoCloseable.next()) {
                    throw new DataException("KML has unregistered SrsNameSpace/SrsName");
                }
                object = autoCloseable.getString("srsname");
                stringBuffer.append("<" + string2 + ">");
            }
        }
        if (n6 == 1 && dArray == null) {
            if (n != 0) {
                stringBuffer.append("<Point>" + string11);
            } else {
                stringBuffer.append(string11);
            }
            double[] dArray2 = jGeometry.getPoint();
            if (dArray2 != null) {
                n3 = dArray2.length;
                stringBuffer.append(string3);
                this.outputCoordinates(n3, 1, dArray2, 0, stringBuffer);
                stringBuffer.append(string4 + "</" + string2 + ">");
            }
        }
        if (n6 == 1 && dArray != null) {
            if (n != 0) {
                stringBuffer.append("<Point>" + string11);
            } else {
                stringBuffer.append(string11);
            }
            stringBuffer.append(string3);
            this.outputCoordinates(n3, 1, dArray, 0, stringBuffer);
            stringBuffer.append(string4 + "</" + string2 + ">");
        } else if (n6 == 2 && nArray[1] % 1000 == 2 && n2 == 1 && dArray != null) {
            if (n != 0) {
                stringBuffer.append("<LineString>" + string11);
            } else {
                stringBuffer.append(string11);
            }
            stringBuffer.append(string3);
            this.outputCoordinates(n3, n5, dArray, 0, stringBuffer);
            stringBuffer.append(string4);
            stringBuffer.append("</" + string2 + ">");
        } else if (n6 == 3 && nArray[1] % 1000 == 3) {
            if (n != 0) {
                stringBuffer.append("<Polygon>" + string11);
            } else {
                stringBuffer.append(string11);
            }
            stringBuffer.append(string5);
            n5 = 3 >= nArray.length ? (dArray.length - nArray[0] + 1) / n3 : (nArray[3] - nArray[0]) / n3;
            n4 = 0;
            if (nArray[2] == 1 || nArray[2] == 3) {
                stringBuffer.append(string9 + string3);
                if (nArray[2] == 3) {
                    this.CCWOutputRectangle(n3, dArray, n4, stringBuffer);
                } else {
                    this.outputCoordinates(n3, n5, dArray, n4, stringBuffer);
                }
                stringBuffer.append(string4 + string10);
            } else if (nArray[2] == 4) {
                stringBuffer.append("<Circle><coordinates>");
                this.outputCoordinates(n3, n5, dArray, n4, stringBuffer);
                stringBuffer.append("</coordinates></Circle>");
            } else {
                throw new DataException("54539");
            }
            stringBuffer.append(string6);
            for (int i = 2; i <= n2; ++i) {
                stringBuffer.append(string7);
                n5 = i == n2 ? (dArray.length - nArray[3 * (i - 1)] + 1) / n3 : (nArray[3 * i] - nArray[3 * (i - 1)]) / n3;
                n4 = nArray[3 * (i - 1)] - 1;
                if (nArray[3 * (i - 1) + 2] == 1 || nArray[3 * (i - 1) + 2] == 3) {
                    stringBuffer.append(string9 + string3);
                    if (nArray[3 * (i - 1) + 2] == 3) {
                        this.CWOutputRectangle(n3, dArray, n4, stringBuffer);
                    } else {
                        this.outputCoordinates(n3, n5, dArray, n4, stringBuffer);
                    }
                    stringBuffer.append(string4 + string10);
                } else if (nArray[3 * (i - 1) + 2] == 4) {
                    stringBuffer.append("<Circle><coordinates>");
                    this.outputCoordinates(n3, n5, dArray, n4, stringBuffer);
                    stringBuffer.append("</coordinates></Circle>");
                } else {
                    throw new DataException("54539");
                }
                stringBuffer.append(string8);
            }
            stringBuffer.append("</" + string2 + ">");
        } else if (n6 == 3 && nArray[1] % 1000 == 6) {
            int n8;
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[jGeometry.getElemInfo().length];
            double[] dArray3 = new double[jGeometry.getOrdinatesArray().length];
            for (n8 = 0; n8 < jGeometry.getOrdinatesArray().length; ++n8) {
                dArray3[n8] = jGeometry.getOrdinatesArray()[n8];
            }
            for (n8 = 0; n8 < jGeometry.getElemInfo().length; ++n8) {
                nArray3[n8] = jGeometry.getElemInfo()[n8];
            }
            autoCloseable = new J3D_Geometry(3, 0, nArray3, dArray3);
            n8 = n;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            string = new ElementExtractor((J3D_Geometry)autoCloseable);
            nArray2[0] = 0;
            while ((object = string.nextElement(nArray2)) != null) {
                arrayList.add(object);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                int n9;
                object = (J3D_Geometry)arrayList.get(i);
                int[] nArray4 = new int[object.getElemInfo().length];
                double[] dArray4 = new double[object.getOrdinatesArray().length];
                for (n9 = 0; n9 < object.getOrdinatesArray().length; ++n9) {
                    dArray4[n9] = object.getOrdinatesArray()[n9];
                }
                for (n9 = 0; n9 < object.getElemInfo().length; ++n9) {
                    nArray4[n9] = object.getElemInfo()[n9];
                }
                preparedStatement = new JGeometry(3003, 0, nArray4, dArray4);
                this.toKML(++n, (JGeometry)preparedStatement, stringBuffer);
            }
            if (n8 == 0) {
                stringBuffer.append("</MultiGeometry>");
            }
        } else if (n6 == 4) {
            if (n3 == 2) {
                int n10;
                int n11 = 0;
                for (n10 = 0; n10 < n2; ++n10) {
                    int n12 = nArray[3 * n10 + 1];
                    if (n12 != 1003 && n12 != 1 && n12 != 2) continue;
                    ++n11;
                }
                if (n11 > 0) {
                    for (n10 = 1; n10 <= n11; ++n10) {
                        autoCloseable = _conn.prepareCall("{ ? = call mdsys.sdo_util.extract(?, ?)}");
                        autoCloseable.registerOutParameter(1, 2002, "MDSYS.SDO_GEOMETRY");
                        autoCloseable.setObject(2, JGeometry.storeJS((JGeometry)jGeometry, (Connection)_conn));
                        autoCloseable.setInt(3, n10);
                        autoCloseable.execute();
                        object = (Struct)autoCloseable.getObject(1);
                        JGeometry jGeometry2 = JGeometry.loadJS((Struct)object);
                        n = 0;
                        this.toKML(n, jGeometry2, stringBuffer);
                        autoCloseable.close();
                    }
                }
                stringBuffer.append("</" + string2 + ">");
            } else {
                int n13;
                int[] nArray5 = new int[1];
                int[] nArray6 = new int[jGeometry.getElemInfo().length];
                double[] dArray5 = new double[jGeometry.getOrdinatesArray().length];
                for (n13 = 0; n13 < jGeometry.getOrdinatesArray().length; ++n13) {
                    dArray5[n13] = jGeometry.getOrdinatesArray()[n13];
                }
                for (n13 = 0; n13 < jGeometry.getElemInfo().length; ++n13) {
                    nArray6[n13] = jGeometry.getElemInfo()[n13];
                }
                autoCloseable = new J3D_Geometry(4, 0, nArray6, dArray5);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                string = new ElementExtractor((J3D_Geometry)autoCloseable);
                nArray5[0] = 0;
                while ((object = string.nextElement(nArray5)) != null) {
                    if (nArray5[0] == 2) continue;
                    arrayList.add(object);
                }
                for (n13 = 0; n13 < arrayList.size(); ++n13) {
                    int n14;
                    J3D_Geometry j3D_Geometry = (J3D_Geometry)arrayList.get(n13);
                    int[] nArray7 = new int[j3D_Geometry.getElemInfo().length];
                    double[] dArray6 = new double[j3D_Geometry.getOrdinatesArray().length];
                    for (n14 = 0; n14 < j3D_Geometry.getOrdinatesArray().length; ++n14) {
                        dArray6[n14] = j3D_Geometry.getOrdinatesArray()[n14];
                    }
                    for (n14 = 0; n14 < j3D_Geometry.getElemInfo().length; ++n14) {
                        nArray7[n14] = j3D_Geometry.getElemInfo()[n14];
                    }
                    preparedStatement = new JGeometry(3000 + j3D_Geometry.getType(), 0, nArray7, dArray6);
                    n = 0;
                    this.toKML(n, (JGeometry)preparedStatement, stringBuffer);
                }
                stringBuffer.append("</MultiGeometry>");
            }
        } else if (n6 == 5) {
            if (n2 == 1 && nArray[2] > 1) {
                n5 = nArray[2];
            } else if (n2 > 1) {
                n5 = n2;
            }
            for (int i = 1; i <= n5; ++i) {
                stringBuffer.append("<Point>" + string11 + string3);
                n4 = n3 * (i - 1);
                this.outputCoordinates(n3, 1, dArray, n4, stringBuffer);
                stringBuffer.append(string4 + "</Point>");
            }
            stringBuffer.append("</" + string2 + ">");
        } else if (n6 == 6) {
            if (n3 == 2) {
                for (int i = 1; i <= n2; ++i) {
                    stringBuffer.append("<LineString>" + string11 + string3);
                    n5 = i == n2 ? (dArray.length - nArray[3 * (i - 1)] + 1) / n3 : (nArray[3 * i] - nArray[3 * (i - 1)]) / n3;
                    n4 = nArray[3 * (i - 1)] - 1;
                    this.outputCoordinates(n3, n5, dArray, n4, stringBuffer);
                    stringBuffer.append(string4 + "</LineString>");
                }
                stringBuffer.append("</" + string2 + ">");
            } else {
                int n15;
                int[] nArray8 = new int[1];
                int[] nArray9 = new int[jGeometry.getElemInfo().length];
                double[] dArray7 = new double[jGeometry.getOrdinatesArray().length];
                for (n15 = 0; n15 < jGeometry.getOrdinatesArray().length; ++n15) {
                    dArray7[n15] = jGeometry.getOrdinatesArray()[n15];
                }
                for (n15 = 0; n15 < jGeometry.getElemInfo().length; ++n15) {
                    nArray9[n15] = jGeometry.getElemInfo()[n15];
                }
                autoCloseable = new J3D_Geometry(6, 0, nArray9, dArray7);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                string = new ElementExtractor((J3D_Geometry)autoCloseable);
                nArray8[0] = 0;
                while ((object = string.nextElement(nArray8)) != null) {
                    if (nArray8[0] == 2) continue;
                    arrayList.add(object);
                }
                for (n15 = 0; n15 < arrayList.size(); ++n15) {
                    int n16;
                    J3D_Geometry j3D_Geometry = (J3D_Geometry)arrayList.get(n15);
                    int[] nArray10 = new int[j3D_Geometry.getElemInfo().length];
                    double[] dArray8 = new double[j3D_Geometry.getOrdinatesArray().length];
                    for (n16 = 0; n16 < j3D_Geometry.getOrdinatesArray().length; ++n16) {
                        dArray8[n16] = j3D_Geometry.getOrdinatesArray()[n16];
                    }
                    for (n16 = 0; n16 < j3D_Geometry.getElemInfo().length; ++n16) {
                        nArray10[n16] = j3D_Geometry.getElemInfo()[n16];
                    }
                    preparedStatement = new JGeometry(3000 + j3D_Geometry.getType(), 0, nArray10, dArray8);
                    this.toKML(++n, (JGeometry)preparedStatement, stringBuffer);
                }
                stringBuffer.append("</MultiGeometry>");
            }
        } else if (n6 == 7) {
            if (n3 == 2) {
                boolean bl2 = true;
                for (int i = 1; i <= n2; ++i) {
                    boolean bl3;
                    n5 = i == n2 ? (dArray.length - nArray[3 * (i - 1)] + 1) / n3 : (nArray[3 * i] - nArray[3 * (i - 1)]) / n3;
                    n4 = nArray[3 * (i - 1)] - 1;
                    boolean bl4 = bl3 = nArray[3 * (i - 1) + 2] == 3;
                    if (bl2) {
                        stringBuffer.append("<Polygon>" + string11 + string5 + string9 + string3);
                        if (bl3) {
                            this.CCWOutputRectangle(n3, dArray, n4, stringBuffer);
                        } else {
                            this.outputCoordinates(n3, n5, dArray, n4, stringBuffer);
                        }
                        stringBuffer.append(string4 + string10 + string6);
                    } else {
                        stringBuffer.append(string7 + string9 + string3);
                        if (bl3) {
                            this.CWOutputRectangle(n3, dArray, n4, stringBuffer);
                        } else {
                            this.outputCoordinates(n3, n5, dArray, n4, stringBuffer);
                        }
                        stringBuffer.append(string4 + string10 + string8);
                    }
                    if (i == n2) {
                        stringBuffer.append("</Polygon>");
                        continue;
                    }
                    if (nArray[3 * i + 1] == 2003) {
                        bl2 = false;
                        continue;
                    }
                    bl2 = true;
                    stringBuffer.append("</Polygon>");
                }
                stringBuffer.append("</" + string2 + ">");
            } else {
                int n17;
                int[] nArray11 = new int[1];
                int[] nArray12 = new int[jGeometry.getElemInfo().length];
                double[] dArray9 = new double[jGeometry.getOrdinatesArray().length];
                for (n17 = 0; n17 < jGeometry.getOrdinatesArray().length; ++n17) {
                    dArray9[n17] = jGeometry.getOrdinatesArray()[n17];
                }
                for (n17 = 0; n17 < jGeometry.getElemInfo().length; ++n17) {
                    nArray12[n17] = jGeometry.getElemInfo()[n17];
                }
                autoCloseable = new J3D_Geometry(7, 0, nArray12, dArray9);
                if (n != 0) {
                    stringBuffer.append("<MultiGeometry>");
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                string = new ElementExtractor((J3D_Geometry)autoCloseable);
                nArray11[0] = 0;
                while ((object = string.nextElement(nArray11)) != null) {
                    if (nArray11[0] == 2) continue;
                    arrayList.add(object);
                }
                for (n17 = 0; n17 < arrayList.size(); ++n17) {
                    int n18;
                    J3D_Geometry j3D_Geometry = (J3D_Geometry)arrayList.get(n17);
                    int[] nArray13 = new int[j3D_Geometry.getElemInfo().length];
                    double[] dArray10 = new double[j3D_Geometry.getOrdinatesArray().length];
                    for (n18 = 0; n18 < j3D_Geometry.getOrdinatesArray().length; ++n18) {
                        dArray10[n18] = j3D_Geometry.getOrdinatesArray()[n18];
                    }
                    for (n18 = 0; n18 < j3D_Geometry.getElemInfo().length; ++n18) {
                        nArray13[n18] = j3D_Geometry.getElemInfo()[n18];
                    }
                    preparedStatement = new JGeometry(3000 + j3D_Geometry.getType(), 0, nArray13, dArray10);
                    this.toKML(++n, (JGeometry)preparedStatement, stringBuffer);
                }
                stringBuffer.append("</MultiGeometry>");
            }
        } else if (n6 == 8 && nArray[1] % 1000 == 7) {
            int n19;
            J3D_Geometry j3D_Geometry;
            J3D_Geometry j3D_Geometry2;
            J3D_Geometry j3D_Geometry3;
            int n20;
            int[] nArray14 = new int[1];
            ArrayList<J3D_Geometry> arrayList = new ArrayList<J3D_Geometry>();
            int[] nArray15 = new int[jGeometry.getElemInfo().length];
            double[] dArray11 = new double[jGeometry.getOrdinatesArray().length];
            for (n20 = 0; n20 < jGeometry.getOrdinatesArray().length; ++n20) {
                dArray11[n20] = jGeometry.getOrdinatesArray()[n20];
            }
            for (n20 = 0; n20 < jGeometry.getElemInfo().length; ++n20) {
                nArray15[n20] = jGeometry.getElemInfo()[n20];
            }
            object = new J3D_Geometry(8, 0, nArray15, dArray11);
            n20 = n;
            ArrayList<J3D_Geometry> arrayList2 = new ArrayList<J3D_Geometry>();
            ArrayList<J3D_Geometry> arrayList3 = new ArrayList<J3D_Geometry>();
            string = new ElementExtractor((J3D_Geometry)object, 0, 2, 3);
            nArray14[0] = 0;
            while ((j3D_Geometry3 = string.nextElement(nArray14)) != null) {
                if (nArray14[0] == 2) continue;
                arrayList.add(j3D_Geometry3);
            }
            j3D_Geometry3 = (J3D_Geometry)arrayList.get(0);
            preparedStatement = new ElementExtractor(j3D_Geometry3, 0, 1, 3);
            nArray14[0] = 0;
            while ((j3D_Geometry2 = preparedStatement.nextElement(nArray14)) != null) {
                if (nArray14[0] == 2) {
                    arrayList2.add(j3D_Geometry2);
                    continue;
                }
                arrayList3.add(j3D_Geometry2);
            }
            J3D_Geometry j3D_Geometry4 = (J3D_Geometry)arrayList3.get(0);
            autoCloseable = new ElementExtractor(j3D_Geometry4, 0, 0, 3);
            ArrayList<J3D_Geometry> arrayList4 = new ArrayList<J3D_Geometry>();
            nArray14[0] = 0;
            while ((j3D_Geometry = autoCloseable.nextElement(nArray14)) != null) {
                if (nArray14[0] == 2) continue;
                arrayList4.add(j3D_Geometry);
            }
            for (n19 = 0; n19 < arrayList4.size(); ++n19) {
                j3D_Geometry = (J3D_Geometry)arrayList4.get(n19);
                stringBuffer.append("<Polygon>" + string11 + "<outerBoundaryIs><LinearRing>");
                stringBuffer.append("<coordinates>");
                this.outputCoordinates(3, j3D_Geometry.getOrdinatesArray().length / 3, j3D_Geometry.getOrdinatesArray(), 0, stringBuffer);
                stringBuffer.append("</coordinates>");
                stringBuffer.append("</LinearRing></outerBoundaryIs></Polygon>");
            }
            for (n19 = 0; n19 < arrayList2.size(); ++n19) {
                J3D_Geometry j3D_Geometry5 = (J3D_Geometry)arrayList2.get(n19);
                autoCloseable = new ElementExtractor(j3D_Geometry5, 0, 0, 3);
                arrayList4 = new ArrayList();
                nArray14[0] = 0;
                while ((j3D_Geometry = autoCloseable.nextElement(nArray14)) != null) {
                    if (nArray14[0] != 2) continue;
                    arrayList4.add(j3D_Geometry);
                }
                for (int i = 0; i < arrayList4.size(); ++i) {
                    j3D_Geometry = (J3D_Geometry)arrayList4.get(i);
                    stringBuffer.append("<Polygon>" + string11 + "<outerBoundaryIs><LinearRing>");
                    stringBuffer.append("<coordinates>");
                    this.outputCoordinates(3, j3D_Geometry.getOrdinatesArray().length / 3, j3D_Geometry.getOrdinatesArray(), 0, stringBuffer);
                    stringBuffer.append("</coordinates>");
                    stringBuffer.append("</LinearRing></outerBoundaryIs></Polygon>");
                }
            }
            if (n20 == 0) {
                stringBuffer.append("</MultiGeometry>");
            }
        } else if (n6 == 8 && nArray[1] % 1000 == 8) {
            int n21;
            int[] nArray16 = new int[1];
            int[] nArray17 = new int[jGeometry.getElemInfo().length];
            double[] dArray12 = new double[jGeometry.getOrdinatesArray().length];
            for (n21 = 0; n21 < jGeometry.getOrdinatesArray().length; ++n21) {
                dArray12[n21] = jGeometry.getOrdinatesArray()[n21];
            }
            for (n21 = 0; n21 < jGeometry.getElemInfo().length; ++n21) {
                nArray17[n21] = jGeometry.getElemInfo()[n21];
            }
            autoCloseable = new J3D_Geometry(8, 0, nArray17, dArray12);
            n21 = n;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            string = new ElementExtractor((J3D_Geometry)autoCloseable);
            nArray16[0] = 0;
            while ((object = string.nextElement(nArray16)) != null) {
                if (nArray16[0] == 2) continue;
                arrayList.add(object);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                int n22;
                object = (J3D_Geometry)arrayList.get(i);
                int[] nArray18 = new int[object.getElemInfo().length];
                double[] dArray13 = new double[object.getOrdinatesArray().length];
                for (n22 = 0; n22 < object.getOrdinatesArray().length; ++n22) {
                    dArray13[n22] = object.getOrdinatesArray()[n22];
                }
                for (n22 = 0; n22 < object.getElemInfo().length; ++n22) {
                    nArray18[n22] = object.getElemInfo()[n22];
                }
                preparedStatement = new JGeometry(3008, 0, nArray18, dArray13);
                this.toKML(++n, (JGeometry)preparedStatement, stringBuffer);
            }
            if (n21 == 0) {
                stringBuffer.append("</MultiGeometry>");
            }
        } else if (n6 == 9) {
            int n23;
            int[] nArray19 = new int[1];
            ArrayList arrayList = new ArrayList();
            int[] nArray20 = new int[jGeometry.getElemInfo().length];
            double[] dArray14 = new double[jGeometry.getOrdinatesArray().length];
            for (n23 = 0; n23 < jGeometry.getOrdinatesArray().length; ++n23) {
                dArray14[n23] = jGeometry.getOrdinatesArray()[n23];
            }
            for (n23 = 0; n23 < jGeometry.getElemInfo().length; ++n23) {
                nArray20[n23] = jGeometry.getElemInfo()[n23];
            }
            autoCloseable = new J3D_Geometry(9, 0, nArray20, dArray14);
            if (n != 0) {
                stringBuffer.append("<MultiGeometry>");
            }
            ArrayList<Object> arrayList5 = new ArrayList<Object>();
            string = new ElementExtractor((J3D_Geometry)autoCloseable);
            nArray19[0] = 0;
            while ((object = string.nextElement(nArray19)) != null) {
                if (nArray19[0] == 2) continue;
                arrayList5.add(object);
            }
            for (n23 = 0; n23 < arrayList5.size(); ++n23) {
                int n24;
                J3D_Geometry j3D_Geometry = (J3D_Geometry)arrayList5.get(n23);
                int[] nArray21 = new int[j3D_Geometry.getElemInfo().length];
                double[] dArray15 = new double[j3D_Geometry.getOrdinatesArray().length];
                for (n24 = 0; n24 < j3D_Geometry.getOrdinatesArray().length; ++n24) {
                    dArray15[n24] = j3D_Geometry.getOrdinatesArray()[n24];
                }
                for (n24 = 0; n24 < j3D_Geometry.getElemInfo().length; ++n24) {
                    nArray21[n24] = j3D_Geometry.getElemInfo()[n24];
                }
                preparedStatement = new JGeometry(3000 + j3D_Geometry.getType(), 0, nArray21, dArray15);
                this.toKML(++n, (JGeometry)preparedStatement, stringBuffer);
            }
            stringBuffer.append("</MultiGeometry>");
        }
    }

    public static CLOB to_KMLGeometryCLOB(STRUCT sTRUCT, String string, String string2) throws SQLException, IOException, Exception {
        KML2.setsrsNameSpace(string);
        KML2.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            KML2.setConnection(connection);
        }
        CLOB cLOB = CLOB.createTemporary((Connection)((OracleConnection)_conn), (boolean)true, (int)10);
        cLOB.open(1);
        String string3 = KML2.to_KMLGeometry(sTRUCT);
        cLOB.setString(1L, string3.toString());
        cLOB.close();
        KML2.setsrsNameSpace(null);
        KML2.setsrsAlias(null);
        return cLOB;
    }

    public static CLOB to_KMLGeometryCLOB(Struct struct, String string, String string2) throws SQLException, IOException, Exception {
        KML2.setsrsNameSpace(string);
        KML2.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            KML2.setConnection(connection);
        }
        CLOB cLOB = CLOB.createTemporary((Connection)((OracleConnection)_conn), (boolean)true, (int)10);
        cLOB.open(1);
        String string3 = KML2.to_KMLGeometry(struct);
        cLOB.setString(1L, string3.toString());
        cLOB.close();
        KML2.setsrsNameSpace(null);
        KML2.setsrsAlias(null);
        return cLOB;
    }

    public static String to_KMLGeometry(STRUCT sTRUCT, String string, String string2) throws SQLException, IOException, Exception {
        KML2.setsrsNameSpace(string);
        KML2.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            KML2.setConnection(connection);
        }
        String string3 = KML2.to_KMLGeometry(sTRUCT);
        KML2.setsrsNameSpace(null);
        KML2.setsrsAlias(null);
        return string3;
    }

    public static String to_KMLGeometry(Struct struct, String string, String string2) throws SQLException, IOException, Exception {
        KML2.setsrsNameSpace(string);
        KML2.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            KML2.setConnection(connection);
        }
        String string3 = KML2.to_KMLGeometry(struct);
        KML2.setsrsNameSpace(null);
        KML2.setsrsAlias(null);
        return string3;
    }

    public static String to_KMLGeometry(STRUCT sTRUCT) throws SQLException, IOException {
        if (sTRUCT == null) {
            return null;
        }
        if (_conn == null) {
            throw new RuntimeException("database connection is null.");
        }
        JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
        return KML2.to_KMLGeometry(jGeometry);
    }

    public static String to_KMLGeometry(Struct struct) throws SQLException, IOException {
        if (struct == null) {
            return null;
        }
        if (_conn == null) {
            throw new RuntimeException("database connection is null.");
        }
        JGeometry jGeometry = JGeometry.loadJS((Struct)struct);
        return KML2.to_KMLGeometry(jGeometry);
    }

    public static CLOB to_KMLGeometryCLOB(STRUCT sTRUCT) throws SQLException, IOException, Exception {
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            KML2.setConnection(connection);
        }
        CLOB cLOB = CLOB.createTemporary((Connection)((OracleConnection)_conn), (boolean)true, (int)10);
        cLOB.open(1);
        String string = KML2.to_KMLGeometry(sTRUCT);
        if (string != null) {
            cLOB.setString(1L, string.toString());
            cLOB.close();
            return cLOB;
        }
        cLOB.close();
        return null;
    }

    public static CLOB to_KMLGeometryCLOB(Struct struct) throws SQLException, IOException, Exception {
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            KML2.setConnection(connection);
        }
        CLOB cLOB = CLOB.createTemporary((Connection)((OracleConnection)_conn), (boolean)true, (int)10);
        cLOB.open(1);
        String string = KML2.to_KMLGeometry(struct);
        if (string != null) {
            cLOB.setString(1L, string.toString());
            cLOB.close();
            return cLOB;
        }
        cLOB.close();
        return null;
    }

    public static String to_KMLGeometry(JGeometry jGeometry) throws SQLException, IOException {
        KML2 kML2 = new KML2();
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            kML2.toKML(n, jGeometry, stringBuffer);
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static OracleClob to_KMLGeometryCLOBJS(Struct struct) throws SQLException, IOException, Exception {
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            KML2.setConnection(connection);
        }
        OracleClob oracleClob = (OracleClob)_conn.createClob();
        oracleClob.open(LargeObjectAccessMode.MODE_READWRITE);
        String string = KML2.to_KMLGeometry(struct);
        if (string != null) {
            oracleClob.setString(1L, string.toString());
            oracleClob.close();
            return oracleClob;
        }
        oracleClob.close();
        return null;
    }

    public static OracleClob to_KMLGeometryCLOBJS(Struct struct, String string, String string2) throws SQLException, IOException, Exception {
        KML2.setsrsNameSpace(string);
        KML2.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            KML2.setConnection(connection);
        }
        OracleClob oracleClob = (OracleClob)_conn.createClob();
        oracleClob.open(LargeObjectAccessMode.MODE_READWRITE);
        String string3 = KML2.to_KMLGeometry(struct);
        oracleClob.setString(1L, string3.toString());
        oracleClob.close();
        KML2.setsrsNameSpace(null);
        KML2.setsrsAlias(null);
        return oracleClob;
    }

    static {
        _srsAlias = "Non-SDO";
    }
}

