/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.spatial.geometry.DataException;
import oracle.spatial.geometry.JGeometry;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

public class KML {
    protected static Connection _conn;
    protected static String _srsNameSpace;
    protected static final Set kmlTypes;

    public static void setConnection(Connection connection) {
        _conn = connection;
    }

    public static void setsrsNameSpace(String string) {
        _srsNameSpace = string;
    }

    public static String getNameSpace() {
        return _srsNameSpace;
    }

    private static final double[] getOrdinatesFromNode(Node node) {
        Node node2 = KML.getFirst(node, new String[]{"coordinates"});
        String string = node2.getNodeName();
        if (KML.normalize(string).equalsIgnoreCase("coordinates")) {
            return KML.parseCoordinates(node2.getFirstChild().getNodeValue(), ", \n\t\r\f");
        }
        return new double[0];
    }

    private static final double[] parseCoordinates(String string, String string2) {
        Vector vector = new Vector();
        KML.addCoords(vector, string);
        double[] dArray = new double[vector.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.parseDouble((String)vector.get(i));
        }
        return dArray;
    }

    private static final int getSRIDFromNode(Node node) throws DataException, Exception {
        XMLElement xMLElement = (XMLElement)node;
        String string = xMLElement.getAttribute("srsName");
        int n = 0;
        String string2 = ((XMLElement)node).getAttribute("srsName");
        String string3 = KML.normalize(string2);
        String string4 = null;
        try {
            string4 = string2.substring(0, string2.indexOf(":"));
        }
        catch (Exception exception) {
            n = 0;
        }
        if (string4 == null) {
            return n;
        }
        if (string4.equalsIgnoreCase("SDO") || string4.equalsIgnoreCase("EPSG")) {
            try {
                n = Integer.parseInt(string3);
            }
            catch (Exception exception) {
                n = 0;
            }
        } else {
            if (_conn == null || _srsNameSpace == null) {
                throw new DataException("KML Converter needs a valid connection and SrsNameSpace" + _srsNameSpace);
            }
            String string5 = " select sdo_srid   from MDSYS.SrsNameSpace_Table  where  SrsNameSpace = ? and SrsName = ? ";
            PreparedStatement preparedStatement = _conn.prepareStatement(string5);
            preparedStatement.setString(1, _srsNameSpace);
            preparedStatement.setString(2, string3);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new DataException("KML has unregistered SrsNameSpace/SrsName");
            }
            n = resultSet.getInt("sdo_srid");
        }
        return n;
    }

    private static final int guessDimensionality(Node node) {
        Node node2 = KML.getFirst(node, new String[]{"coordinates"});
        String string = KML.normalize(node2.getNodeName());
        if (KML.normalize(string).equalsIgnoreCase("coordinates")) {
            Object object;
            int n;
            Object object2;
            if (node2.hasAttributes()) {
                object2 = node2.getAttributes();
                for (n = 0; n < object2.getLength(); ++n) {
                    object = object2.item(n);
                    if (!object.getNodeName().equalsIgnoreCase("srsDimension")) continue;
                    return Integer.parseInt(object.getNodeValue());
                }
            }
            if ((n = ((String)(object2 = node2.getFirstChild().getNodeValue().trim())).indexOf(" ")) == -1) {
                n = ((String)object2).length();
            }
            object = ((String)object2).substring(0, n);
            int n2 = 0;
            for (int i = 0; i < ((String)object).length(); ++i) {
                if (((String)object).charAt(i) != ',') continue;
                ++n2;
            }
            return ++n2;
        }
        return 0;
    }

    public static JGeometry fromNodeToPoint(Node node) throws DataException, Exception {
        int n = 0;
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return null;
        }
        n = KML.getSRIDFromNode(node);
        double[] dArray = KML.getOrdinatesFromNode(node);
        if (dArray.length == 2) {
            return new JGeometry(dArray[0], dArray[1], n);
        }
        if (dArray.length == 3) {
            return new JGeometry(dArray[0], dArray[1], dArray[2], n);
        }
        return null;
    }

    public static JGeometry fromNodeToCurve(Node node) throws DataException, Exception {
        int n = KML.getSRIDFromNode(node);
        int n2 = KML.guessDimensionality(node);
        double[] dArray = KML.getOrdinatesFromNode(node);
        return JGeometry.createLinearLineString((double[])dArray, (int)n2, (int)n);
    }

    public static JGeometry fromNodeToPolygon(Node node) throws DataException, Exception {
        int n = KML.getSRIDFromNode(node);
        int n2 = KML.guessDimensionality(KML.getFirst(node, new String[]{"outerBoundaryIs", "LinearRing"}));
        Vector vector = KML.getAll(node, new String[]{"innerBoundaryIs", "LinearRing"});
        Object[] objectArray = new Object[vector.size() + 1];
        objectArray[0] = KML.getOrdinatesFromNode(KML.getFirst(node, new String[]{"outerBoundaryIs", "LinearRing"}));
        for (int i = 0; i < vector.size(); ++i) {
            double[] dArray = KML.getOrdinatesFromNode((Node)vector.get(i));
            objectArray[i + 1] = dArray;
        }
        return JGeometry.createLinearPolygon((Object[])objectArray, (int)n2, (int)n);
    }

    public static JGeometry fromNodeToGeometry(Node node) throws DataException, Exception {
        String string = KML.normalize(node.getNodeName()).toUpperCase();
        if (string.equals("POINT")) {
            return KML.fromNodeToPoint(node);
        }
        if (string.equals("LINESTRING")) {
            return KML.fromNodeToCurve(node);
        }
        if (string.equals("POLYGON")) {
            return KML.fromNodeToPolygon(node);
        }
        if (string.equals("MULTIGEOMETRY")) {
            return KML.fromNodeToGeometryCollection(node);
        }
        if (string.equals("LINEARRING")) {
            return KML.fromNodeToLinearRing(node);
        }
        throw new DataException("KML Geometry type " + node.getNodeName() + " not supported.");
    }

    public static JGeometry fromNodeToGeometryCollection(Node node) throws DataException, Exception {
        Object object;
        Object object2;
        int n;
        int n2 = 0;
        Vector<JGeometry> vector = new Vector<JGeometry>();
        int n3 = 0;
        int n4 = 0;
        Vector vector2 = KML.getGeometry(node, new String[]{"Point", "LineString", "Polygon"});
        for (n = 0; n < vector2.size(); ++n) {
            object2 = (Node)vector2.get(n);
            object = null;
            for (object = object2; object != null && !kmlTypes.contains(KML.normalize(object.getNodeName().toUpperCase())); object = object.getNextSibling()) {
            }
            if (object == null) continue;
            JGeometry jGeometry = KML.fromNodeToGeometry((Node)object);
            vector.add(jGeometry);
            if (jGeometry.getPoint() != null) {
                n3 += 3;
                n4 += jGeometry.getPoint().length;
                continue;
            }
            n3 += jGeometry.getElemInfo().length;
            n4 += jGeometry.getOrdinatesArray().length;
        }
        n = KML.getSRIDFromNode(node);
        object2 = new int[n3];
        object = new double[n4];
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            int n7;
            JGeometry jGeometry = (JGeometry)vector.get(i);
            n2 = jGeometry.getDimensions();
            int[] nArray = jGeometry.getElemInfo();
            double[] dArray = jGeometry.getOrdinatesArray();
            if (jGeometry.getPoint() != null) {
                object2[n5 + 0] = n6 + 1;
                object2[n5 + 1] = true;
                object2[n5 + 2] = true;
                n5 += 3;
                for (n7 = 0; n7 < jGeometry.getPoint().length; ++n7) {
                    object[n6 + n7] = jGeometry.getPoint()[n7];
                }
                n6 += jGeometry.getPoint().length;
                continue;
            }
            for (n7 = 0; n7 < nArray.length; n7 += 3) {
                object2[n5 + n7 + 0] = nArray[n7 + 0] + n6;
                object2[n5 + n7 + 1] = nArray[n7 + 1];
                object2[n5 + n7 + 2] = nArray[n7 + 2];
            }
            n5 += nArray.length;
            for (n7 = 0; n7 < dArray.length; ++n7) {
                object[n6 + n7] = dArray[n7];
            }
            n6 += dArray.length;
        }
        if (n2 == 0) {
            throw new DataException("54555");
        }
        return new JGeometry(n2 * 1000 + 4, n, (int[])object2, (double[])object);
    }

    public static JGeometry fromNodeToLinearRing(Node node) throws DataException, Exception {
        Node node2 = KML.getFirst(node, new String[]{"coordinates"});
        int n = KML.guessDimensionality(node);
        Vector<String> vector = new Vector<String>();
        if (node2 == null) {
            double[] dArray = KML.getOrdinatesFromNode(node);
            for (int i = 0; i < dArray.length; ++i) {
                vector.add(Double.toString(dArray[i]));
            }
        } else {
            KML.addCoords(vector, node2.getFirstChild().getNodeValue());
        }
        int n2 = KML.getSRIDFromNode(node);
        int[] nArray = new int[]{1, 2, 1};
        double[] dArray = new double[vector.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.parseDouble((String)vector.get(i));
        }
        if (n == 2 && dArray.length < 8 || n == 3 && dArray.length < 12) {
            throw new DataException("13343");
        }
        return new JGeometry(n * 1000 + 2, n2, nArray, dArray);
    }

    protected static void addCoords(Vector vector, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.replace(',', ' '));
        while (stringTokenizer.hasMoreElements()) {
            vector.add(stringTokenizer.nextElement());
        }
    }

    protected static Vector getAll(Node node, String[] stringArray) {
        Vector vector = new Vector();
        KML.getAll(node, stringArray, 0, vector);
        return vector;
    }

    protected static void getAll(Node node, String[] stringArray, int n, Vector vector) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (!KML.normalize(node2.getNodeName()).equalsIgnoreCase(stringArray[n])) continue;
            if (n + 1 == stringArray.length) {
                vector.add(node2);
                continue;
            }
            KML.getAll(node2, stringArray, n + 1, vector);
        }
    }

    protected static Node getFirst(Node node, String[] stringArray) {
        return KML.getFirst(node, stringArray, 0);
    }

    protected static Node getFirst(Node node, String[] stringArray, int n) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (!KML.normalize(node2.getNodeName()).equalsIgnoreCase(stringArray[n])) continue;
            if (n + 1 == stringArray.length) {
                return node2;
            }
            Node node3 = KML.getFirst(node2, stringArray, n + 1);
            if (node3 == null) continue;
            return node3;
        }
        return null;
    }

    protected static String normalize(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(":") >= 0) {
            return string.substring(string.indexOf(":") + 1);
        }
        return string;
    }

    public static Vector getGeometry(Node node, String[] stringArray) {
        Vector vector = new Vector();
        KML.getGeometry(node, stringArray, vector);
        return vector;
    }

    public static void getGeometry(Node node, String[] stringArray, Vector vector) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            String string = new String(node2.getNodeName());
            if (KML.match(string, stringArray)) {
                vector.add(node2);
                continue;
            }
            KML.getGeometry(node2, stringArray, vector);
        }
    }

    private static boolean match(String string, String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    static {
        _srsNameSpace = "Test";
        kmlTypes = new HashSet(5);
        kmlTypes.add("POINT");
        kmlTypes.add("LINESTRING");
        kmlTypes.add("POLYGON");
        kmlTypes.add("MULTIGEOMETRY");
        kmlTypes.add("LINEARRING");
    }
}

