/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.spatial.geometry.DataException;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.GML3g;
import oracle.spatial.util.Logger;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GML {
    private static final String GML2_CS_ATTRIBUTE = "cs";
    private static final String GML2_CS_ATTRIBUTE_DEFAULT_VALUE = ",";
    private static final String GML2_TS_ATTRIBUTE = "ts";
    private static final String GML2_TS_ATTRIBUTE_DEFAULT_VALUE = " ";
    protected static Connection _conn;
    protected static String _srsNameSpace;
    private static Logger logger;
    protected static final Set gmlTypes;

    public static void setConnection(Connection connection) {
        _conn = connection;
    }

    public static void setsrsNameSpace(String string) {
        _srsNameSpace = string;
    }

    public static String getNameSpace() {
        return _srsNameSpace;
    }

    private static final double[] getOrdinatesFromNode(Node node) {
        String string;
        Node node2 = GML.getFirst(node, new String[]{"coordinates"});
        if (node2 == null) {
            node2 = GML.getFirst(node, new String[]{"coord"});
        }
        if (GML.normalize(string = node2.getNodeName()).equalsIgnoreCase("coordinates")) {
            return GML.parseCoordinates(node2.getFirstChild().getNodeValue(), ", \n\t\r\f");
        }
        if (GML.normalize(string).equalsIgnoreCase("coord")) {
            return GML.parseCoordinates(node.getChildNodes());
        }
        return new double[0];
    }

    private static final double[] parseCoordinates(NodeList nodeList) {
        int n = nodeList.getLength();
        XMLElement xMLElement = (XMLElement)nodeList.item(0);
        int n2 = xMLElement.getChildNodes().getLength();
        double[] dArray = new double[n * n2];
        try {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                xMLElement = (XMLElement)nodeList.item(i);
                NodeList nodeList2 = xMLElement.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    XMLElement xMLElement2 = (XMLElement)nodeList2.item(j);
                    dArray[i * n2 + j] = Double.parseDouble(xMLElement2.getFirstChild().getNodeValue().trim());
                }
            }
        }
        catch (Exception exception) {
            return new double[0];
        }
        return dArray;
    }

    private static final double[] parseCoordinates(String string, String string2) {
        Vector vector = new Vector();
        GML.addCoords(vector, string);
        double[] dArray = new double[vector.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.parseDouble((String)vector.get(i));
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int getSRIDFromNode(Node node) throws DataException, Exception {
        int n = 0;
        String string = GML.getAttributeOrDefault(node, "srsName", null);
        String string2 = GML.normalize(string);
        String string3 = null;
        try {
            string3 = string.substring(0, string.indexOf(":"));
        }
        catch (Exception exception) {
            n = 0;
        }
        if (string3 == null) {
            return n;
        }
        if (string3.equalsIgnoreCase("SDO") || string3.equalsIgnoreCase("EPSG") || string3.equalsIgnoreCase("URN")) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                try {
                    String string4 = string2.substring(string2.indexOf("EPSG"));
                    string4 = string4.substring(string4.lastIndexOf(58) + 1);
                    n = Integer.parseInt(string4);
                }
                catch (Exception exception2) {
                    n = 0;
                }
            }
        } else {
            if (_conn == null || _srsNameSpace == null) {
                throw new DataException("GML Converter needs a valid connection and SrsNameSpace" + _srsNameSpace);
            }
            String string5 = " select sdo_srid   from MDSYS.SrsNameSpace_Table  where  SrsNameSpace = ? and SrsName = ? ";
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = _conn.prepareStatement(string5);
                preparedStatement.setString(1, _srsNameSpace);
                preparedStatement.setString(2, string2);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) {
                    throw new DataException("GML has unregistered SrsNameSpace/SrsName");
                }
                n = resultSet.getInt("sdo_srid");
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        return n;
    }

    private static Node getAttribute(Node node, String string, boolean bl) {
        if (node == null || string == null || string.length() == 0) {
            return null;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (bl) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                if (!string.equalsIgnoreCase(node2.getNodeName())) continue;
                return node2;
            }
            return null;
        }
        return namedNodeMap.getNamedItem(string);
    }

    private static final String getAttributeOrDefault(Node node, String string, String string2) {
        String string3 = null;
        Node node2 = null;
        node2 = GML.getAttribute(node, string, true);
        if (node2 != null) {
            string3 = node2.getNodeValue().trim();
        }
        if (string3 == null || string3.length() == 0) {
            string3 = string2;
        }
        return string3;
    }

    private static final int guessDimensionality(Node node) {
        String string;
        Node node2 = GML.getFirst(node, new String[]{"coordinates"});
        if (node2 == null) {
            node2 = GML.getFirst(node, new String[]{"coord"});
        }
        if (GML.normalize(string = GML.normalize(node2.getNodeName())).equalsIgnoreCase("coordinates")) {
            String string2 = GML.getAttributeOrDefault(node2, GML2_TS_ATTRIBUTE, GML2_TS_ATTRIBUTE_DEFAULT_VALUE);
            String string3 = GML.getAttributeOrDefault(node2, GML2_CS_ATTRIBUTE, GML2_CS_ATTRIBUTE_DEFAULT_VALUE);
            String string4 = node2.getFirstChild().getNodeValue().trim();
            string4 = string4.replaceAll("\n", GML2_TS_ATTRIBUTE_DEFAULT_VALUE);
            int n = (string4 = string4.replaceAll("\t", GML2_TS_ATTRIBUTE_DEFAULT_VALUE)).indexOf(string2);
            if (n == -1) {
                n = string4.length();
            }
            String string5 = string4.substring(0, n);
            int n2 = 0;
            for (int i = 0; i < string5.length(); ++i) {
                if (string5.charAt(i) != string3.charAt(0)) continue;
                ++n2;
            }
            return ++n2;
        }
        if (GML.normalize(string).equalsIgnoreCase("coord")) {
            NodeList nodeList = node2.getChildNodes();
            return nodeList.getLength();
        }
        return 0;
    }

    public static JGeometry fromNodeToPoint(Node node) throws DataException, Exception {
        int n = 0;
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return null;
        }
        n = GML.getSRIDFromNode(node);
        double[] dArray = GML.getOrdinatesFromNode(node);
        if (dArray.length == 2) {
            return new JGeometry(dArray[0], dArray[1], n);
        }
        if (dArray.length == 3) {
            return new JGeometry(dArray[0], dArray[1], dArray[2], n);
        }
        return null;
    }

    public static final JGeometry fromNodeToEnvelope(Node node) throws DataException, Exception {
        int n = GML.getSRIDFromNode(node);
        double[] dArray = GML.getOrdinatesFromNode(node);
        return new JGeometry(Math.min(dArray[0], dArray[2]), Math.min(dArray[1], dArray[3]), Math.max(dArray[0], dArray[2]), Math.max(dArray[1], dArray[3]), n);
    }

    public static JGeometry fromNodeToLineString(Node node) throws DataException, Exception {
        int n = GML.getSRIDFromNode(node);
        int n2 = GML.guessDimensionality(node);
        double[] dArray = GML.getOrdinatesFromNode(node);
        return JGeometry.createLinearLineString((double[])dArray, (int)n2, (int)n);
    }

    public static JGeometry fromNodeToPolygon(Node node) throws DataException, Exception {
        int n = GML.getSRIDFromNode(node);
        int n2 = GML.guessDimensionality(GML.getFirst(node, new String[]{"outerBoundaryIS", "LinearRing"}));
        Vector vector = GML.getAll(node, new String[]{"innerBoundaryIS", "LinearRing"});
        Object[] objectArray = new Object[vector.size() + 1];
        objectArray[0] = GML.getOrdinatesFromNode(GML.getFirst(node, new String[]{"outerBoundaryIS", "LinearRing"}));
        for (int i = 0; i < vector.size(); ++i) {
            double[] dArray = GML.getOrdinatesFromNode((Node)vector.get(i));
            objectArray[i + 1] = dArray;
        }
        return JGeometry.createLinearPolygon((Object[])objectArray, (int)n2, (int)n);
    }

    public static JGeometry fromNodeToSurface(Node node) throws DataException, Exception {
        int n = GML.getSRIDFromNode(node);
        int n2 = GML.guessDimensionality(GML.getFirst(node, new String[]{"outerBoundaryIS", "LinearRing"}));
        Vector vector = GML.getAll(node, new String[]{"innerBoundaryIS", "LinearRing"});
        Object[] objectArray = new Object[vector.size() + 1];
        objectArray[0] = GML.getOrdinatesFromNode(GML.getFirst(node, new String[]{"outerBoundaryIS", "LinearRing"}));
        for (int i = 0; i < vector.size(); ++i) {
            double[] dArray = GML.getOrdinatesFromNode((Node)vector.get(i));
            objectArray[i + 1] = dArray;
        }
        return JGeometry.createLinearPolygon((Object[])objectArray, (int)n2, (int)n);
    }

    public static JGeometry fromNodeToMultiLineString(Node node) throws DataException, Exception {
        int n = GML.getSRIDFromNode(node);
        int n2 = GML.guessDimensionality(GML.getFirst(node, new String[]{"lineStringMember", "LineString"}));
        Vector vector = GML.getAll(node, new String[]{"lineStringMember", "LineString"});
        Object[] objectArray = new Object[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            double[] dArray = GML.getOrdinatesFromNode((Node)vector.get(i));
            objectArray[i] = dArray;
        }
        return JGeometry.createLinearMultiLineString((Object[])objectArray, (int)n2, (int)n);
    }

    public static JGeometry fromNodeToMultiPoint(Node node) throws DataException, Exception {
        int n = GML.getSRIDFromNode(node);
        int n2 = GML.guessDimensionality(GML.getFirst(node, new String[]{"pointMember", "Point"}));
        Vector vector = GML.getAll(node, new String[]{"pointMember", "Point"});
        Object[] objectArray = new Object[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            double[] dArray = GML.getOrdinatesFromNode((Node)vector.get(i));
            objectArray[i] = dArray;
        }
        return JGeometry.createMultiPoint((Object[])objectArray, (int)n2, (int)n);
    }

    public static JGeometry fromNodeToGeometry(Node node) throws DataException, Exception {
        String string = GML.normalize(node.getNodeName());
        if (string.equals("Point")) {
            return GML.fromNodeToPoint(node);
        }
        if (string.equals("LineString")) {
            return GML.fromNodeToLineString(node);
        }
        if (string.equals("Polygon")) {
            return GML.fromNodeToPolygon(node);
        }
        if (string.equals("Surface")) {
            return GML.fromNodeToSurface(node);
        }
        if (string.equals("MultiPoint")) {
            return GML.fromNodeToMultiPoint(node);
        }
        if (string.equals("MultiLineString")) {
            return GML.fromNodeToMultiLineString(node);
        }
        if (string.equals("Box")) {
            return GML.fromNodeToEnvelope(node);
        }
        if (string.equals("LinearRing")) {
            return GML.fromNodeToLinearRing(node);
        }
        if (string.equals("MultiPolygon")) {
            return GML.fromNodeToMultiPolygon(node);
        }
        if (string.equals("MultiGeometry")) {
            return GML.fromNodeToGeometryCollection(node);
        }
        throw new DataException("GML Geometry type " + node.getNodeName() + " not supported.");
    }

    public static JGeometry fromNodeToGeometry(Node node, int n) throws DataException, Exception {
        JGeometry jGeometry = GML.fromNodeToGeometry(node);
        if (n == 0) {
            return jGeometry;
        }
        if (n == 1) {
            int n2 = GML3g.reverseAxisOrder(n, jGeometry.getSRID(), _conn);
            if (n2 == 1) {
                jGeometry = GML3g.switchXYOrdinates(jGeometry);
            }
            return jGeometry;
        }
        if (n == 2) {
            jGeometry = GML3g.switchXYOrdinates(jGeometry);
            return jGeometry;
        }
        throw new Exception("Wrong value for (GML2) coordOrder parameter: please choose among [0,1,2]");
    }

    public static JGeometry fromNodeToGeometryCollection(Node node) throws DataException, Exception {
        Object object;
        Object object2;
        int n;
        Vector<JGeometry> vector = new Vector<JGeometry>();
        int n2 = 0;
        int n3 = 0;
        Vector vector2 = GML.getAll(node, new String[]{"geometryMember"});
        for (n = 0; n < vector2.size(); ++n) {
            object2 = (Node)vector2.get(n);
            object = null;
            for (object = (Object)object2.getFirstChild(); object != null && !gmlTypes.contains(GML.normalize(object.getNodeName().toUpperCase())); object = object.getNextSibling()) {
            }
            if (object == null) continue;
            JGeometry jGeometry = GML.fromNodeToGeometry((Node)object);
            vector.add(jGeometry);
            if (jGeometry.getPoint() != null) {
                n2 += 3;
                n3 += jGeometry.getPoint().length;
                continue;
            }
            n2 += jGeometry.getElemInfo().length;
            n3 += jGeometry.getOrdinatesArray().length;
        }
        n = GML.getSRIDFromNode(node);
        object2 = new int[n2];
        object = new double[n3];
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            int n6;
            JGeometry jGeometry = (JGeometry)vector.get(i);
            int[] nArray = jGeometry.getElemInfo();
            double[] dArray = jGeometry.getOrdinatesArray();
            if (jGeometry.getPoint() != null) {
                object2[n4 + 0] = n5 + 1;
                object2[n4 + 1] = true;
                object2[n4 + 2] = true;
                n4 += 3;
                for (n6 = 0; n6 < jGeometry.getPoint().length; ++n6) {
                    object[n5 + n6] = jGeometry.getPoint()[n6];
                }
                n5 += jGeometry.getPoint().length;
                continue;
            }
            for (n6 = 0; n6 < nArray.length; n6 += 3) {
                object2[n4 + n6 + 0] = nArray[n6 + 0] + n5;
                object2[n4 + n6 + 1] = nArray[n6 + 1];
                object2[n4 + n6 + 2] = nArray[n6 + 2];
            }
            n4 += nArray.length;
            for (n6 = 0; n6 < dArray.length; ++n6) {
                object[n5 + n6] = dArray[n6];
            }
            n5 += dArray.length;
        }
        return new JGeometry(2004, n, (int[])object2, (double[])object);
    }

    public static JGeometry fromNodeToLinearRing(Node node) throws DataException, Exception {
        Node node2 = GML.getFirst(node, new String[]{"coordinates"});
        Vector vector = new Vector();
        GML.addCoords(vector, node2.getFirstChild().getNodeValue());
        int n = GML.getSRIDFromNode(node);
        int[] nArray = new int[]{1, 2, 1};
        double[] dArray = new double[vector.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.parseDouble((String)vector.get(i));
        }
        return new JGeometry(2002, n, nArray, dArray);
    }

    public static JGeometry fromNodeToMultiPolygon(Node node) throws DataException, Exception {
        Object object;
        int n;
        Vector vector = GML.getAll(node, new String[]{"polygonMember", "Polygon"});
        Vector<String> vector2 = new Vector<String>();
        Vector vector3 = new Vector();
        for (n = 0; n < vector.size(); ++n) {
            int n2;
            object = (Node)vector.get(n);
            Vector vector4 = GML.getAll((Node)object, new String[]{"innerBoundaryIs", "LinearRing", "coordinates"});
            Vector vector5 = GML.getAll((Node)object, new String[]{"outerBoundaryIs", "LinearRing", "coordinates"});
            for (n2 = 0; n2 < vector5.size(); ++n2) {
                vector2.add("" + (vector3.size() + 1));
                vector2.add("1003");
                vector2.add("1");
                GML.addCoords(vector3, ((Node)vector5.get(n2)).getFirstChild().getNodeValue());
            }
            for (n2 = 0; n2 < vector4.size(); ++n2) {
                vector2.add("" + (vector3.size() + 1));
                vector2.add("2003");
                vector2.add("1");
                GML.addCoords(vector3, ((Node)vector4.get(n2)).getFirstChild().getNodeValue());
            }
        }
        n = GML.getSRIDFromNode(node);
        object = new int[vector2.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = Integer.parseInt((String)vector2.get(i));
        }
        double[] dArray = new double[vector3.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.parseDouble((String)vector3.get(i));
        }
        return new JGeometry(2007, n, (int[])object, dArray);
    }

    protected static void addCoords(Vector vector, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.replace(',', ' '));
        while (stringTokenizer.hasMoreElements()) {
            vector.add(stringTokenizer.nextElement());
        }
    }

    public static Vector getAll(Node node, String[] stringArray) {
        Vector vector = new Vector();
        GML.getAll(node, stringArray, 0, vector);
        return vector;
    }

    public static void getAll(Node node, String[] stringArray, int n, Vector vector) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (!GML.normalize(node2.getNodeName()).equalsIgnoreCase(stringArray[n])) continue;
            if (n + 1 == stringArray.length) {
                vector.add(node2);
                continue;
            }
            GML.getAll(node2, stringArray, n + 1, vector);
        }
    }

    protected static Node getFirst(Node node, String[] stringArray) {
        return GML.getFirst(node, stringArray, 0);
    }

    protected static Node getFirst(Node node, String[] stringArray, int n) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (!GML.normalize(node2.getNodeName()).equalsIgnoreCase(stringArray[n])) continue;
            if (n + 1 == stringArray.length) {
                return node2;
            }
            Node node3 = GML.getFirst(node2, stringArray, n + 1);
            if (node3 == null) continue;
            return node3;
        }
        return null;
    }

    protected static String normalize(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(":") >= 0) {
            return string.substring(string.indexOf(":") + 1);
        }
        return string;
    }

    static {
        _srsNameSpace = "Test";
        logger = Logger.getLogger("oracle.spatial.util.GML");
        gmlTypes = new HashSet(9);
        gmlTypes.add("POINT");
        gmlTypes.add("LINESTRING");
        gmlTypes.add("POLYGON");
        gmlTypes.add("MULTIPOINT");
        gmlTypes.add("MULTILINESTRING");
        gmlTypes.add("BOX");
        gmlTypes.add("LINEARRING");
        gmlTypes.add("MULTIPOLYGON");
        gmlTypes.add("MULTIGEOMETRY");
    }
}

