/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Scanner;
import java.util.Vector;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleStatement;
import oracle.sql.CLOB;

public class CustomCrsExport {
    public static void main(String[] stringArray) throws SQLException {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        Scanner scanner;
        Vector<Long> vector = new Vector();
        if (stringArray.length != 6) {
            scanner = new Scanner(System.in);
            System.out.println("Source instance (jdbc:oracle:thin:@//machine:port/service):");
            System.out.print("  Connect string: ");
            string6 = scanner.nextLine();
            System.out.print("  User name:      ");
            string5 = scanner.nextLine();
            System.out.print("  Password:       ");
            string4 = scanner.nextLine();
            System.out.println("Target instance (jdbc:oracle:thin:@//machine:port/service):");
            System.out.print("  Connect string: ");
            string3 = scanner.nextLine();
            System.out.print("  User name:      ");
            string2 = scanner.nextLine();
            System.out.print("  Password:       ");
            string = scanner.nextLine();
        } else {
            string6 = stringArray[0];
            string5 = stringArray[1];
            string4 = stringArray[2];
            string3 = stringArray[3];
            string2 = stringArray[4];
            string = stringArray[5];
        }
        scanner = (OracleConnection)DriverManager.getConnection(string6, string5, string4);
        OracleConnection oracleConnection = (OracleConnection)DriverManager.getConnection(string3, string2, string);
        oracleConnection.setAutoCommit(false);
        scanner.setDefaultRowPrefetch(1000);
        oracleConnection.setDefaultRowPrefetch(1000);
        OracleStatement oracleStatement = (OracleStatement)scanner.createStatement();
        OracleStatement oracleStatement2 = (OracleStatement)oracleConnection.createStatement();
        oracleStatement2.executeUpdate("alter table sdo_datums disable constraint DATUM_FOREIGN_LEGACY");
        oracleStatement2.executeUpdate("alter table sdo_coord_ops disable constraint COORD_OPERATION_FOREIGN_SOURCE");
        oracleStatement2.executeUpdate("alter table sdo_coord_ops disable constraint COORD_OPERATION_FOREIGN_TARGET");
        oracleStatement2.executeUpdate("alter trigger MDSYS.SDO_COORD_OP_METHODS_TRIGGER disable");
        oracleStatement2.executeUpdate("alter table SDO_COORD_REF_SYS disable constraint COORD_REF_SYS_FOREIGN_GEOG");
        oracleStatement2.executeUpdate("alter table SDO_COORD_REF_SYS disable constraint COORD_REF_SYS_FOREIGN_VERT");
        long l = System.currentTimeMillis();
        vector = CustomCrsExport.getListToBeCopied("select uom_id from sdo_units_of_measure order by uom_id", oracleStatement, oracleStatement2);
        String string7 = CustomCrsExport.getSampleSubset(vector);
        System.out.printf("UOM IDs to be copied:          %6d... ", vector.size());
        CustomCrsExport.copyUomList(vector, (OracleConnection)scanner, oracleConnection);
        long l2 = System.currentTimeMillis();
        System.out.printf("%5.1f s ... %s\n", (double)(l2 - l) / 1000.0, string7);
        vector = CustomCrsExport.getListToBeCopied("select ellipsoid_id from sdo_ellipsoids order by ellipsoid_id", oracleStatement, oracleStatement2);
        string7 = CustomCrsExport.getSampleSubset(vector);
        System.out.printf("Ellipsoid IDs to be copied:    %6d... ", vector.size());
        CustomCrsExport.copyEllipsoidList(vector, (OracleConnection)scanner, oracleConnection);
        long l3 = System.currentTimeMillis();
        System.out.printf("%5.1f s ... %s\n", (double)(l3 - l2) / 1000.0, string7);
        vector = CustomCrsExport.getListToBeCopied("select prime_meridian_id from sdo_prime_meridians order by prime_meridian_id", oracleStatement, oracleStatement2);
        string7 = CustomCrsExport.getSampleSubset(vector);
        System.out.printf("PM IDs to be copied:           %6d... ", vector.size());
        CustomCrsExport.copyPMList(vector, (OracleConnection)scanner, oracleConnection);
        long l4 = System.currentTimeMillis();
        System.out.printf("%5.1f s ... %s\n", (double)(l4 - l3) / 1000.0, string7);
        vector = CustomCrsExport.getListToBeCopied("select datum_id from sdo_datums order by datum_id", oracleStatement, oracleStatement2);
        string7 = CustomCrsExport.getSampleSubset(vector);
        System.out.printf("Datum IDs to be copied:        %6d... ", vector.size());
        CustomCrsExport.copyDatumList(vector, (OracleConnection)scanner, oracleConnection);
        long l5 = System.currentTimeMillis();
        System.out.printf("%5.1f s ... %s\n", (double)(l5 - l4) / 1000.0, string7);
        vector = CustomCrsExport.getListToBeCopied("select coord_sys_id from sdo_coord_sys order by coord_sys_id", oracleStatement, oracleStatement2);
        string7 = CustomCrsExport.getSampleSubset(vector);
        System.out.printf("CS s to be copied:             %6d... ", vector.size());
        CustomCrsExport.copyCSList(vector, (OracleConnection)scanner, oracleConnection);
        long l6 = System.currentTimeMillis();
        System.out.printf("%5.1f s ... %s\n", (double)(l6 - l5) / 1000.0, string7);
        vector = CustomCrsExport.getListToBeCopied("select coord_op_method_id from sdo_coord_op_methods order by coord_op_method_id", oracleStatement, oracleStatement2);
        string7 = CustomCrsExport.getSampleSubset(vector);
        System.out.printf("Coord Op Methods to be copied: %6d... ", vector.size());
        CustomCrsExport.copyOpMethodList(vector, (OracleConnection)scanner, oracleConnection);
        long l7 = System.currentTimeMillis();
        System.out.printf("%5.1f s ... %s\n", (double)(l7 - l6) / 1000.0, string7);
        vector = CustomCrsExport.getListToBeCopied("select parameter_id from sdo_coord_op_params order by parameter_id", oracleStatement, oracleStatement2);
        string7 = CustomCrsExport.getSampleSubset(vector);
        System.out.printf("Coord Op Params to be copied:  %6d... ", vector.size());
        CustomCrsExport.copyParamList(vector, (OracleConnection)scanner, oracleConnection);
        long l8 = System.currentTimeMillis();
        System.out.printf("%5.1f s ... %s\n", (double)(l8 - l7) / 1000.0, string7);
        vector = CustomCrsExport.getListToBeCopied("select coord_op_id from sdo_coord_ops order by coord_op_id", oracleStatement, oracleStatement2);
        string7 = CustomCrsExport.getSampleSubset(vector);
        System.out.printf("Coord Ops to be copied:        %6d... ", vector.size());
        CustomCrsExport.copyOpList(vector, (OracleConnection)scanner, oracleConnection);
        long l9 = System.currentTimeMillis();
        System.out.printf("%5.1f s ... %s\n", (double)(l9 - l8) / 1000.0, string7);
        Vector<Long> vector2 = new Vector<Long>();
        vector = CustomCrsExport.getListToBeCopied("select unique coord_op_id from sdo_coord_op_param_vals order by coord_op_id", oracleStatement, oracleStatement2);
        string7 = CustomCrsExport.getSampleSubset(vector);
        System.out.printf("Coord Vals to be copied:       %6d... ", vector.size());
        CustomCrsExport.copyOpValList(vector, (OracleConnection)scanner, oracleConnection, vector2);
        long l10 = System.currentTimeMillis();
        System.out.printf("%5.1f s ... %s (Ops with matrices: %s)\n", (double)(l10 - l9) / 1000.0, string7, vector2.toString());
        vector = CustomCrsExport.getListToBeCopied("select srid from sdo_coord_ref_sys order by srid", oracleStatement, oracleStatement2);
        string7 = CustomCrsExport.getSampleSubset(vector);
        System.out.printf("SRIDs to be copied:            %6d... ", vector.size());
        CustomCrsExport.copySRIDList((Vector)vector.clone(), (OracleConnection)scanner, oracleConnection);
        CustomCrsExport.copySRIDList2(vector, (OracleConnection)scanner, oracleConnection);
        long l11 = System.currentTimeMillis();
        System.out.printf("%5.1f s ... %s\n", (double)(l11 - l10) / 1000.0, string7);
        oracleStatement2.executeUpdate("insert into MDSYS.sdo_crs_geographic_plus_height (\n  select srid from MDSYS.sdo_coord_ref_sys where coord_ref_sys_kind = 'GEOGRAPHIC3D'\n  minus\n  select srid from MDSYS.sdo_crs_geographic_plus_height)");
        oracleStatement2.executeUpdate("insert into MDSYS.sdo_crs_geographic_plus_height (\n  select\n    cmpd.srid\n  from\n    MDSYS.sdo_coord_ref_sys cmpd,\n    MDSYS.sdo_coord_ref_sys horiz\n  where\n    cmpd.coord_ref_sys_kind = 'COMPOUND' and\n    horiz.srid = cmpd.cmpd_horiz_srid and\n    horiz.coord_ref_sys_kind = 'GEOGRAPHIC2D'\n  minus\n  select srid from MDSYS.sdo_crs_geographic_plus_height)");
        oracleStatement2.executeUpdate("alter table SDO_COORD_REF_SYS enable constraint COORD_REF_SYS_FOREIGN_VERT");
        oracleStatement2.executeUpdate("alter table SDO_COORD_REF_SYS enable constraint COORD_REF_SYS_FOREIGN_GEOG");
        oracleStatement2.executeUpdate("alter table sdo_datums enable constraint DATUM_FOREIGN_LEGACY");
        oracleStatement2.executeUpdate("alter table sdo_coord_ops enable constraint COORD_OPERATION_FOREIGN_SOURCE");
        oracleStatement2.executeUpdate("alter table sdo_coord_ops enable constraint COORD_OPERATION_FOREIGN_TARGET");
        oracleStatement2.executeUpdate("alter trigger MDSYS.SDO_COORD_OP_METHODS_TRIGGER enable");
        oracleConnection.commit();
        oracleStatement.close();
        oracleStatement2.close();
        oracleConnection.close();
        scanner.close();
        System.out.println("Export from " + string6 + " to " + string3 + " finished.");
    }

    private static String getSampleSubset(Vector<Long> vector) {
        if (vector.size() <= 10) {
            return vector.toString();
        }
        return "[" + vector.get(0) + ", " + vector.get(1) + ", " + vector.get(2) + ", " + vector.get(3) + ", " + vector.get(4) + ", " + vector.get(5) + ", " + vector.get(6) + ", " + vector.get(7) + ", " + vector.get(8) + ", " + vector.get(9) + ", ...]";
    }

    private static void copyUomList(Vector<Long> vector, OracleConnection oracleConnection, OracleConnection oracleConnection2) throws SQLException {
        String string = "select\n  UOM_ID,\n  UNIT_OF_MEAS_NAME,\n  SHORT_NAME,\n  LEGACY_UNIT_NAME,\n  UNIT_OF_MEAS_TYPE,\n  TARGET_UOM_ID,\n  FACTOR_B,\n  FACTOR_C,\n  INFORMATION_SOURCE,\n  DATA_SOURCE,\n  IS_LEGACY,\n  LEGACY_CODE\nfrom\n  sdo_units_of_measure\norder by\n  uom_id";
        String string2 = "insert into sdo_units_of_measure(\n  UOM_ID,\n  UNIT_OF_MEAS_NAME,\n  SHORT_NAME,\n  LEGACY_UNIT_NAME,\n  UNIT_OF_MEAS_TYPE,\n  TARGET_UOM_ID,\n  FACTOR_B,\n  FACTOR_C,\n  INFORMATION_SOURCE,\n  DATA_SOURCE,\n  IS_LEGACY,\n  LEGACY_CODE)\nvalues (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        OracleStatement oracleStatement = (OracleStatement)oracleConnection.createStatement();
        OracleResultSet oracleResultSet = (OracleResultSet)oracleStatement.executeQuery(string);
        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)oracleConnection2.prepareStatement(string2);
        while (oracleResultSet.next() && vector.size() > 0) {
            long l = oracleResultSet.getLong(1);
            if (l != vector.get(0)) continue;
            vector.remove(0);
            oraclePreparedStatement.setLong(1, l);
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(1, 2);
            }
            oraclePreparedStatement.setString(2, oracleResultSet.getString(2));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(2, 12);
            }
            oraclePreparedStatement.setString(3, oracleResultSet.getString(3));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(3, 12);
            }
            oraclePreparedStatement.setString(4, oracleResultSet.getString(4));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(4, 12);
            }
            oraclePreparedStatement.setString(5, oracleResultSet.getString(5));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(5, 12);
            }
            oraclePreparedStatement.setLong(6, oracleResultSet.getLong(6));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(6, 2);
            }
            oraclePreparedStatement.setDouble(7, oracleResultSet.getDouble(7));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(7, 2);
            }
            oraclePreparedStatement.setDouble(8, oracleResultSet.getDouble(8));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(8, 2);
            }
            oraclePreparedStatement.setString(9, oracleResultSet.getString(9));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(9, 12);
            }
            oraclePreparedStatement.setString(10, oracleResultSet.getString(10));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(10, 12);
            }
            oraclePreparedStatement.setString(11, oracleResultSet.getString(11));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(11, 12);
            }
            oraclePreparedStatement.setString(12, oracleResultSet.getString(12));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(12, 12);
            }
            oraclePreparedStatement.addBatch();
        }
        oraclePreparedStatement.executeBatch();
        oracleResultSet.close();
        oracleStatement.close();
        oraclePreparedStatement.close();
    }

    private static void copyEllipsoidList(Vector<Long> vector, OracleConnection oracleConnection, OracleConnection oracleConnection2) throws SQLException {
        String string = "select\n  ELLIPSOID_ID,\n  ELLIPSOID_NAME,\n  SEMI_MAJOR_AXIS,\n  UOM_ID,\n  INV_FLATTENING,\n  SEMI_MINOR_AXIS,\n  INFORMATION_SOURCE,\n  DATA_SOURCE,\n  IS_LEGACY,\n  LEGACY_CODE\nfrom\n  sdo_ellipsoids\norder by\n  ellipsoid_id";
        String string2 = "insert into sdo_ellipsoids(\n  ELLIPSOID_ID,\n  ELLIPSOID_NAME,\n  SEMI_MAJOR_AXIS,\n  UOM_ID,\n  INV_FLATTENING,\n  SEMI_MINOR_AXIS,\n  INFORMATION_SOURCE,\n  DATA_SOURCE,\n  IS_LEGACY,\n  LEGACY_CODE)\nvalues (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        OracleStatement oracleStatement = (OracleStatement)oracleConnection.createStatement();
        OracleResultSet oracleResultSet = (OracleResultSet)oracleStatement.executeQuery(string);
        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)oracleConnection2.prepareStatement(string2);
        while (oracleResultSet.next() && vector.size() > 0) {
            long l = oracleResultSet.getLong(1);
            if (l != vector.get(0)) continue;
            vector.remove(0);
            oraclePreparedStatement.setLong(1, l);
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(1, 2);
            }
            oraclePreparedStatement.setString(2, oracleResultSet.getString(2));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(2, 12);
            }
            oraclePreparedStatement.setDouble(3, oracleResultSet.getDouble(3));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(3, 2);
            }
            oraclePreparedStatement.setLong(4, oracleResultSet.getLong(4));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(4, 2);
            }
            oraclePreparedStatement.setDouble(5, oracleResultSet.getDouble(5));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(5, 2);
            }
            oraclePreparedStatement.setDouble(6, oracleResultSet.getDouble(6));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(6, 2);
            }
            oraclePreparedStatement.setString(7, oracleResultSet.getString(7));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(7, 12);
            }
            oraclePreparedStatement.setString(8, oracleResultSet.getString(8));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(8, 12);
            }
            oraclePreparedStatement.setString(9, oracleResultSet.getString(9));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(9, 12);
            }
            oraclePreparedStatement.setString(10, oracleResultSet.getString(10));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(10, 12);
            }
            oraclePreparedStatement.addBatch();
        }
        oraclePreparedStatement.executeBatch();
        oracleResultSet.close();
        oracleStatement.close();
        oraclePreparedStatement.close();
    }

    private static void copyPMList(Vector<Long> vector, OracleConnection oracleConnection, OracleConnection oracleConnection2) throws SQLException {
        String string = "select\n  PRIME_MERIDIAN_ID,\n  PRIME_MERIDIAN_NAME,\n  GREENWICH_LONGITUDE,\n  UOM_ID,\n  INFORMATION_SOURCE,\n  DATA_SOURCE\nfrom\n  sdo_prime_meridians\norder by\n  prime_meridian_id";
        String string2 = "insert into sdo_prime_meridians(\n  PRIME_MERIDIAN_ID,\n  PRIME_MERIDIAN_NAME,\n  GREENWICH_LONGITUDE,\n  UOM_ID,\n  INFORMATION_SOURCE,\n  DATA_SOURCE)\nvalues (?, ?, ?, ?, ?, ?)";
        OracleStatement oracleStatement = (OracleStatement)oracleConnection.createStatement();
        OracleResultSet oracleResultSet = (OracleResultSet)oracleStatement.executeQuery(string);
        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)oracleConnection2.prepareStatement(string2);
        while (oracleResultSet.next() && vector.size() > 0) {
            long l = oracleResultSet.getLong(1);
            if (l != vector.get(0)) continue;
            vector.remove(0);
            oraclePreparedStatement.setLong(1, l);
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(1, 2);
            }
            oraclePreparedStatement.setString(2, oracleResultSet.getString(2));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(2, 12);
            }
            oraclePreparedStatement.setDouble(3, oracleResultSet.getDouble(3));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(3, 2);
            }
            oraclePreparedStatement.setLong(4, oracleResultSet.getLong(4));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(4, 2);
            }
            oraclePreparedStatement.setString(5, oracleResultSet.getString(5));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(5, 12);
            }
            oraclePreparedStatement.setString(6, oracleResultSet.getString(6));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(6, 12);
            }
            oraclePreparedStatement.addBatch();
        }
        oraclePreparedStatement.executeBatch();
        oracleResultSet.close();
        oracleStatement.close();
        oraclePreparedStatement.close();
    }

    private static void copyDatumList(Vector<Long> vector, OracleConnection oracleConnection, OracleConnection oracleConnection2) throws SQLException {
        String string = "select\n  DATUM_ID,\n  DATUM_NAME,\n  DATUM_TYPE,\n  ELLIPSOID_ID,\n  PRIME_MERIDIAN_ID,\n  INFORMATION_SOURCE,\n  DATA_SOURCE,\n  SHIFT_X,\n  SHIFT_Y,\n  SHIFT_Z,\n  ROTATE_X,\n  ROTATE_Y,\n  ROTATE_Z,\n  SCALE_ADJUST,\n  IS_LEGACY,\n  LEGACY_CODE\nfrom\n  sdo_datums\norder by\n  datum_id";
        String string2 = "insert into sdo_datums(\n  DATUM_ID,\n  DATUM_NAME,\n  DATUM_TYPE,\n  ELLIPSOID_ID,\n  PRIME_MERIDIAN_ID,\n  INFORMATION_SOURCE,\n  DATA_SOURCE,\n  SHIFT_X,\n  SHIFT_Y,\n  SHIFT_Z,\n  ROTATE_X,\n  ROTATE_Y,\n  ROTATE_Z,\n  SCALE_ADJUST,\n  IS_LEGACY,\n  LEGACY_CODE)\nvalues (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        OracleStatement oracleStatement = (OracleStatement)oracleConnection.createStatement();
        OracleResultSet oracleResultSet = (OracleResultSet)oracleStatement.executeQuery(string);
        OracleStatement oracleStatement2 = (OracleStatement)oracleConnection2.createStatement();
        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)oracleConnection2.prepareStatement(string2);
        while (oracleResultSet.next() && vector.size() > 0) {
            long l = oracleResultSet.getLong(1);
            if (l != vector.get(0)) continue;
            vector.remove(0);
            oraclePreparedStatement.setLong(1, l);
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(1, 2);
            }
            oraclePreparedStatement.setString(2, oracleResultSet.getString(2));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(2, 12);
            }
            oraclePreparedStatement.setString(3, oracleResultSet.getString(3));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(3, 12);
            }
            oraclePreparedStatement.setLong(4, oracleResultSet.getLong(4));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(4, 2);
            }
            oraclePreparedStatement.setLong(5, oracleResultSet.getLong(5));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(5, 2);
            }
            oraclePreparedStatement.setString(6, oracleResultSet.getString(6));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(6, 12);
            }
            oraclePreparedStatement.setString(7, oracleResultSet.getString(7));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(7, 12);
            }
            oraclePreparedStatement.setDouble(8, oracleResultSet.getDouble(8));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(8, 2);
            }
            oraclePreparedStatement.setDouble(9, oracleResultSet.getDouble(9));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(9, 2);
            }
            oraclePreparedStatement.setDouble(10, oracleResultSet.getDouble(10));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(10, 2);
            }
            oraclePreparedStatement.setDouble(11, oracleResultSet.getDouble(11));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(11, 2);
            }
            oraclePreparedStatement.setDouble(12, oracleResultSet.getDouble(12));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(12, 2);
            }
            oraclePreparedStatement.setDouble(13, oracleResultSet.getDouble(13));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(13, 2);
            }
            oraclePreparedStatement.setDouble(14, oracleResultSet.getDouble(14));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(14, 2);
            }
            oraclePreparedStatement.setString(15, oracleResultSet.getString(15));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(15, 12);
            }
            oraclePreparedStatement.setLong(16, oracleResultSet.getLong(16));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(16, 2);
            }
            try {
                oraclePreparedStatement.addBatch();
            }
            catch (Exception exception) {
                System.out.println("Inserting datum " + l + " failed, due to " + exception.getMessage());
            }
        }
        oraclePreparedStatement.executeBatch();
        oracleResultSet.close();
        oracleStatement.close();
        oraclePreparedStatement.close();
        oracleStatement2.close();
    }

    private static void copyCSList(Vector<Long> vector, OracleConnection oracleConnection, OracleConnection oracleConnection2) throws SQLException {
        String string = "select\n  COORD_SYS_ID,\n  COORD_SYS_NAME,\n  COORD_SYS_TYPE,\n  DIMENSION,\n  INFORMATION_SOURCE,\n  DATA_SOURCE\nfrom\n  sdo_coord_sys\norder by\n  coord_sys_id";
        String string2 = "insert into sdo_coord_sys(\n  COORD_SYS_ID,\n  COORD_SYS_NAME,\n  COORD_SYS_TYPE,\n  DIMENSION,\n  INFORMATION_SOURCE,\n  DATA_SOURCE)\nvalues (?, ?, ?, ?, ?, ?)";
        OracleStatement oracleStatement = (OracleStatement)oracleConnection.createStatement();
        OracleResultSet oracleResultSet = (OracleResultSet)oracleStatement.executeQuery(string);
        OracleStatement oracleStatement2 = (OracleStatement)oracleConnection2.createStatement();
        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)oracleConnection2.prepareStatement(string2);
        while (oracleResultSet.next() && vector.size() > 0) {
            long l = oracleResultSet.getLong(1);
            if (l != vector.get(0)) continue;
            vector.remove(0);
            oraclePreparedStatement.setLong(1, l);
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(1, 2);
            }
            oraclePreparedStatement.setString(2, oracleResultSet.getString(2));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(2, 12);
            }
            oraclePreparedStatement.setString(3, oracleResultSet.getString(3));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(3, 12);
            }
            oraclePreparedStatement.setLong(4, oracleResultSet.getLong(4));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(4, 2);
            }
            oraclePreparedStatement.setString(5, oracleResultSet.getString(5));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(5, 12);
            }
            oraclePreparedStatement.setString(6, oracleResultSet.getString(6));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(6, 12);
            }
            try {
                oraclePreparedStatement.addBatch();
            }
            catch (Exception exception) {
                System.out.println("Inserting CS " + l + " failed, due to " + exception.getMessage());
            }
        }
        oraclePreparedStatement.executeBatch();
        oracleResultSet.close();
        oracleStatement.close();
        oraclePreparedStatement.close();
        oracleStatement2.close();
    }

    private static void copyOpMethodList(Vector<Long> vector, OracleConnection oracleConnection, OracleConnection oracleConnection2) throws SQLException {
        String string = "select\n  COORD_OP_METHOD_ID,\n  COORD_OP_METHOD_NAME,\n  LEGACY_NAME,\n  REVERSE_OP,\n  INFORMATION_SOURCE,\n  DATA_SOURCE,\n  IS_IMPLEMENTED_FORWARD,\n  IS_IMPLEMENTED_REVERSE\nfrom\n  sdo_coord_op_methods\norder by\n  coord_op_method_id";
        String string2 = "insert into sdo_coord_op_methods(\n  COORD_OP_METHOD_ID,\n  COORD_OP_METHOD_NAME,\n  LEGACY_NAME,\n  REVERSE_OP,\n  INFORMATION_SOURCE,\n  DATA_SOURCE,\n  IS_IMPLEMENTED_FORWARD,\n  IS_IMPLEMENTED_REVERSE)\nvalues (?, ?, ?, ?, ?, ?, ?, ?)";
        OracleStatement oracleStatement = (OracleStatement)oracleConnection.createStatement();
        OracleResultSet oracleResultSet = (OracleResultSet)oracleStatement.executeQuery(string);
        OracleStatement oracleStatement2 = (OracleStatement)oracleConnection2.createStatement();
        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)oracleConnection2.prepareStatement(string2);
        while (oracleResultSet.next() && vector.size() > 0) {
            long l = oracleResultSet.getLong(1);
            if (l != vector.get(0)) continue;
            vector.remove(0);
            oraclePreparedStatement.setLong(1, l);
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(1, 2);
            }
            oraclePreparedStatement.setString(2, oracleResultSet.getString(2));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(2, 12);
            }
            oraclePreparedStatement.setString(3, oracleResultSet.getString(3));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(3, 12);
            }
            oraclePreparedStatement.setLong(4, oracleResultSet.getLong(4));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(4, 2);
            }
            oraclePreparedStatement.setString(5, oracleResultSet.getString(5));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(5, 12);
            }
            oraclePreparedStatement.setString(6, oracleResultSet.getString(6));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(6, 12);
            }
            oraclePreparedStatement.setLong(7, 0L);
            oraclePreparedStatement.setLong(8, 0L);
            try {
                oraclePreparedStatement.addBatch();
            }
            catch (Exception exception) {
                System.out.println("Inserting Op Method " + l + " failed, due to " + exception.getMessage());
            }
        }
        oraclePreparedStatement.executeBatch();
        oracleResultSet.close();
        oracleStatement.close();
        oraclePreparedStatement.close();
        oracleStatement2.close();
    }

    private static void copyOpList(Vector<Long> vector, OracleConnection oracleConnection, OracleConnection oracleConnection2) throws SQLException {
        String string = "select\n  COORD_OP_ID,\n  COORD_OP_NAME,\n  COORD_OP_TYPE,\n  SOURCE_SRID,\n  TARGET_SRID,\n  COORD_TFM_VERSION,\n  COORD_OP_VARIANT,\n  COORD_OP_METHOD_ID,\n  UOM_ID_SOURCE_OFFSETS,\n  UOM_ID_TARGET_OFFSETS,\n  INFORMATION_SOURCE,\n  DATA_SOURCE,\n  SHOW_OPERATION,\n  IS_LEGACY,\n  LEGACY_CODE,\n  REVERSE_OP,\n  IS_IMPLEMENTED_FORWARD,\n  IS_IMPLEMENTED_REVERSE\nfrom\n  sdo_coord_ops\norder by\n  coord_op_id";
        String string2 = "insert into sdo_coord_ops(\n  COORD_OP_ID,\n  COORD_OP_NAME,\n  COORD_OP_TYPE,\n  SOURCE_SRID,\n  TARGET_SRID,\n  COORD_TFM_VERSION,\n  COORD_OP_VARIANT,\n  COORD_OP_METHOD_ID,\n  UOM_ID_SOURCE_OFFSETS,\n  UOM_ID_TARGET_OFFSETS,\n  INFORMATION_SOURCE,\n  DATA_SOURCE,\n  SHOW_OPERATION,\n  IS_LEGACY,\n  LEGACY_CODE,\n  REVERSE_OP,\n  IS_IMPLEMENTED_FORWARD,\n  IS_IMPLEMENTED_REVERSE)\nvalues (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        OracleStatement oracleStatement = (OracleStatement)oracleConnection.createStatement();
        OracleResultSet oracleResultSet = (OracleResultSet)oracleStatement.executeQuery(string);
        OracleStatement oracleStatement2 = (OracleStatement)oracleConnection2.createStatement();
        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)oracleConnection2.prepareStatement(string2);
        while (oracleResultSet.next() && vector.size() > 0) {
            long l = oracleResultSet.getLong(1);
            if (l != vector.get(0)) continue;
            vector.remove(0);
            oraclePreparedStatement.setLong(1, l);
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(1, 2);
            }
            oraclePreparedStatement.setString(2, oracleResultSet.getString(2));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(2, 12);
            }
            oraclePreparedStatement.setString(3, oracleResultSet.getString(3));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(3, 12);
            }
            oraclePreparedStatement.setLong(4, oracleResultSet.getLong(4));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(4, 2);
            }
            oraclePreparedStatement.setLong(5, oracleResultSet.getLong(5));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(5, 2);
            }
            oraclePreparedStatement.setString(6, oracleResultSet.getString(6));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(6, 12);
            }
            oraclePreparedStatement.setLong(7, oracleResultSet.getLong(7));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(7, 2);
            }
            oraclePreparedStatement.setLong(8, oracleResultSet.getLong(8));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(8, 2);
            }
            oraclePreparedStatement.setLong(9, oracleResultSet.getLong(9));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(9, 2);
            }
            oraclePreparedStatement.setLong(10, oracleResultSet.getLong(10));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(10, 2);
            }
            oraclePreparedStatement.setString(11, oracleResultSet.getString(11));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(11, 12);
            }
            oraclePreparedStatement.setString(12, oracleResultSet.getString(12));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(12, 12);
            }
            oraclePreparedStatement.setLong(13, oracleResultSet.getLong(13));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(13, 2);
            }
            oraclePreparedStatement.setString(14, oracleResultSet.getString(14));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(14, 12);
            }
            oraclePreparedStatement.setLong(15, oracleResultSet.getLong(15));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(15, 2);
            }
            oraclePreparedStatement.setLong(16, oracleResultSet.getLong(16));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(16, 2);
            }
            oraclePreparedStatement.setLong(17, oracleResultSet.getLong(17));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(17, 2);
            }
            oraclePreparedStatement.setLong(18, oracleResultSet.getLong(18));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(18, 2);
            }
            try {
                oraclePreparedStatement.addBatch();
            }
            catch (Exception exception) {
                System.out.println("Inserting op " + l + " failed, due to " + exception.getMessage());
            }
        }
        oraclePreparedStatement.executeBatch();
        oracleResultSet.close();
        oracleStatement.close();
        oraclePreparedStatement.close();
        oracleStatement2.close();
    }

    private static void copyOpValList(Vector<Long> vector, OracleConnection oracleConnection, OracleConnection oracleConnection2, Vector<Long> vector2) throws SQLException {
        String string = "select\n  COORD_OP_ID,\n  COORD_OP_METHOD_ID,\n  PARAMETER_ID,\n  PARAMETER_VALUE,\n  PARAM_VALUE_FILE_REF,\n  PARAM_VALUE_FILE,\n  PARAM_VALUE_XML,\n  UOM_ID\nfrom\n  sdo_coord_op_param_vals\norder by\n  coord_op_id,  parameter_id";
        String string2 = "insert into sdo_coord_op_param_vals(\n  COORD_OP_ID,\n  COORD_OP_METHOD_ID,\n  PARAMETER_ID,\n  PARAMETER_VALUE,\n  PARAM_VALUE_FILE_REF,\n  PARAM_VALUE_FILE,\n  PARAM_VALUE_XML,\n  UOM_ID)\nvalues (?, ?, ?, ?, ?, ?, NULL, ?)";
        OracleStatement oracleStatement = (OracleStatement)oracleConnection.createStatement();
        OracleResultSet oracleResultSet = (OracleResultSet)oracleStatement.executeQuery(string);
        OracleStatement oracleStatement2 = (OracleStatement)oracleConnection2.createStatement();
        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)oracleConnection2.prepareStatement(string2);
        while (oracleResultSet.next() && vector.size() > 0) {
            long l = oracleResultSet.getLong(1);
            if (vector.get(0) < l) {
                vector.remove(0);
            }
            if (l != vector.get(0)) continue;
            oraclePreparedStatement.setLong(1, l);
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(1, 2);
            }
            oraclePreparedStatement.setLong(2, oracleResultSet.getLong(2));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(2, 2);
            }
            oraclePreparedStatement.setLong(3, oracleResultSet.getLong(3));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(3, 2);
            }
            oraclePreparedStatement.setDouble(4, oracleResultSet.getDouble(4));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(4, 2);
            }
            oraclePreparedStatement.setString(5, oracleResultSet.getString(5));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(5, 12);
            }
            if (oracleResultSet.getString(6) != null || oracleResultSet.getString(7) != null) {
                vector2.add(l);
            }
            if (oracleResultSet.getString(6) != null) {
                try {
                    CLOB cLOB = (CLOB)oracleResultSet.getClob(6);
                    InputStream inputStream = cLOB.getAsciiStream();
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 0x100000);
                    CLOB cLOB2 = CLOB.createTemporary((Connection)oracleConnection2, (boolean)true, (int)10);
                    cLOB2.open(1);
                    OutputStream outputStream = cLOB2.setAsciiStream(0L);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, 0x100000);
                    while (bufferedInputStream.available() > 0) {
                        bufferedOutputStream.write(bufferedInputStream.read());
                    }
                    bufferedOutputStream.close();
                    outputStream.close();
                    bufferedInputStream.close();
                    inputStream.close();
                    oraclePreparedStatement.setClob(6, (Clob)cLOB2);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            } else {
                oraclePreparedStatement.setNull(6, 2005);
            }
            oraclePreparedStatement.setLong(7, oracleResultSet.getLong(8));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(7, 2);
            }
            try {
                oraclePreparedStatement.addBatch();
            }
            catch (Exception exception) {
                System.out.println("Inserting op " + l + " param vals failed, due to " + exception.getMessage());
            }
        }
        oraclePreparedStatement.executeBatch();
        oracleResultSet.close();
        oracleStatement.close();
        oraclePreparedStatement.close();
        oracleStatement2.close();
    }

    private static void copyParamList(Vector<Long> vector, OracleConnection oracleConnection, OracleConnection oracleConnection2) throws SQLException {
        String string = "select\n  PARAMETER_ID,\n  PARAMETER_NAME,\n  INFORMATION_SOURCE,\n  DATA_SOURCE,\n  UNIT_OF_MEAS_TYPE\nfrom\n  sdo_coord_op_params\norder by\n  parameter_id";
        String string2 = "insert into sdo_coord_op_params(\n  PARAMETER_ID,\n  PARAMETER_NAME,\n  INFORMATION_SOURCE,\n  DATA_SOURCE,\n  UNIT_OF_MEAS_TYPE)\nvalues (?, ?, ?, ?, ?)";
        OracleStatement oracleStatement = (OracleStatement)oracleConnection.createStatement();
        OracleResultSet oracleResultSet = (OracleResultSet)oracleStatement.executeQuery(string);
        OracleStatement oracleStatement2 = (OracleStatement)oracleConnection2.createStatement();
        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)oracleConnection2.prepareStatement(string2);
        while (oracleResultSet.next() && vector.size() > 0) {
            long l = oracleResultSet.getLong(1);
            if (l != vector.get(0)) continue;
            vector.remove(0);
            oraclePreparedStatement.setLong(1, l);
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(1, 2);
            }
            oraclePreparedStatement.setString(2, oracleResultSet.getString(2));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(2, 12);
            }
            oraclePreparedStatement.setString(3, oracleResultSet.getString(3));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(3, 12);
            }
            oraclePreparedStatement.setString(4, oracleResultSet.getString(4));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(4, 12);
            }
            oraclePreparedStatement.setString(5, oracleResultSet.getString(5));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(5, 12);
            }
            try {
                oraclePreparedStatement.addBatch();
            }
            catch (Exception exception) {
                System.out.println("Inserting op " + l + " param vals failed, due to " + exception.getMessage());
            }
        }
        oraclePreparedStatement.executeBatch();
        oracleResultSet.close();
        oracleStatement.close();
        oraclePreparedStatement.close();
        oracleStatement2.close();
    }

    private static void copySRIDList(Vector<Long> vector, OracleConnection oracleConnection, OracleConnection oracleConnection2) throws SQLException {
        String string = "select\n  SRID,\n  COORD_REF_SYS_NAME,\n  COORD_REF_SYS_KIND,\n  COORD_SYS_ID,\n  DATUM_ID,\n  GEOG_CRS_DATUM_ID,\n  SOURCE_GEOG_SRID,\n  PROJECTION_CONV_ID,\n  CMPD_HORIZ_SRID,\n  CMPD_VERT_SRID,\n  INFORMATION_SOURCE,\n  DATA_SOURCE,\n  IS_LEGACY,\n  LEGACY_CODE,\n  LEGACY_WKTEXT,\n  LEGACY_CS_BOUNDS,\n  IS_VALID,\n  SUPPORTS_SDO_GEOMETRY\nfrom\n  sdo_coord_ref_sys\norder by\n  srid";
        String string2 = "insert into sdo_coord_ref_sys(\n  SRID,\n  COORD_REF_SYS_NAME,\n  COORD_REF_SYS_KIND,\n  COORD_SYS_ID,\n  DATUM_ID,\n  GEOG_CRS_DATUM_ID,\n  SOURCE_GEOG_SRID,\n  PROJECTION_CONV_ID,\n  CMPD_HORIZ_SRID,\n  CMPD_VERT_SRID,\n  INFORMATION_SOURCE,\n  DATA_SOURCE,\n  IS_LEGACY,\n  LEGACY_CODE,\n  LEGACY_WKTEXT,\n  LEGACY_CS_BOUNDS,\n  IS_VALID,\n  SUPPORTS_SDO_GEOMETRY)\nvalues (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, null, ?, ?)";
        OracleStatement oracleStatement = (OracleStatement)oracleConnection.createStatement();
        OracleResultSet oracleResultSet = (OracleResultSet)oracleStatement.executeQuery(string);
        OracleStatement oracleStatement2 = (OracleStatement)oracleConnection2.createStatement();
        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)oracleConnection2.prepareStatement(string2);
        while (oracleResultSet.next() && vector.size() > 0) {
            long l = oracleResultSet.getLong(1);
            if (l != vector.get(0)) continue;
            vector.remove(0);
            oraclePreparedStatement.setLong(1, l);
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(1, 2);
            }
            oraclePreparedStatement.setString(2, oracleResultSet.getString(2));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(2, 12);
            }
            oraclePreparedStatement.setString(3, oracleResultSet.getString(3));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(3, 12);
            }
            oraclePreparedStatement.setLong(4, oracleResultSet.getLong(4));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(4, 2);
            }
            oraclePreparedStatement.setLong(5, oracleResultSet.getLong(5));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(5, 2);
            }
            oraclePreparedStatement.setLong(6, oracleResultSet.getLong(6));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(6, 2);
            }
            oraclePreparedStatement.setLong(7, oracleResultSet.getLong(7));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(7, 2);
            }
            oraclePreparedStatement.setLong(8, oracleResultSet.getLong(8));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(8, 2);
            }
            oraclePreparedStatement.setLong(9, oracleResultSet.getLong(9));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(9, 2);
            }
            oraclePreparedStatement.setLong(10, oracleResultSet.getLong(10));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(10, 2);
            }
            oraclePreparedStatement.setString(11, oracleResultSet.getString(11));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(11, 12);
            }
            oraclePreparedStatement.setString(12, oracleResultSet.getString(12));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(12, 12);
            }
            oraclePreparedStatement.setString(13, oracleResultSet.getString(13));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(13, 12);
            }
            oraclePreparedStatement.setLong(14, oracleResultSet.getLong(14));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(14, 2);
            }
            oraclePreparedStatement.setString(15, oracleResultSet.getString(15));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(15, 12);
            }
            oraclePreparedStatement.setString(16, oracleResultSet.getString(17));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(16, 12);
            }
            oraclePreparedStatement.setString(17, oracleResultSet.getString(18));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(17, 12);
            }
            try {
                oraclePreparedStatement.addBatch();
            }
            catch (Exception exception) {
                System.out.println("Inserting SRID (SDO_COORD_REF_SYS) " + l + " failed, due to " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        oraclePreparedStatement.executeBatch();
        oracleResultSet.close();
        oracleStatement.close();
        oraclePreparedStatement.close();
        oracleStatement2.close();
    }

    private static void copySRIDList2(Vector<Long> vector, OracleConnection oracleConnection, OracleConnection oracleConnection2) throws SQLException {
        String string = "select\n  SRID,\n  CS_NAME,\n  AUTH_SRID,\n  AUTH_NAME,\n  WKTEXT,\n  CS_BOUNDS,\n  WKTEXT3D\nfrom\n  sdo_cs_srs\norder by\n  srid";
        String string2 = "insert into sdo_cs_srs(\n  SRID,\n  CS_NAME,\n  AUTH_SRID,\n  AUTH_NAME,\n  WKTEXT,\n  CS_BOUNDS,\n  WKTEXT3D)\nvalues (?, ?, ?, ?, ?, NULL, ?)";
        OracleStatement oracleStatement = (OracleStatement)oracleConnection.createStatement();
        OracleResultSet oracleResultSet = (OracleResultSet)oracleStatement.executeQuery(string);
        OracleStatement oracleStatement2 = (OracleStatement)oracleConnection2.createStatement();
        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)oracleConnection2.prepareStatement(string2);
        while (oracleResultSet.next() && vector.size() > 0) {
            long l = oracleResultSet.getLong(1);
            if (l != vector.get(0)) continue;
            vector.remove(0);
            oraclePreparedStatement.setLong(1, l);
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(1, 2);
            }
            oraclePreparedStatement.setString(2, oracleResultSet.getString(2));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(2, 12);
            }
            oraclePreparedStatement.setLong(3, oracleResultSet.getLong(3));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(3, 2);
            }
            oraclePreparedStatement.setString(4, oracleResultSet.getString(4));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(4, 12);
            }
            oraclePreparedStatement.setString(5, oracleResultSet.getString(5));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(5, 12);
            }
            oraclePreparedStatement.setString(6, oracleResultSet.getString(7));
            if (oracleResultSet.wasNull()) {
                oraclePreparedStatement.setNull(6, 12);
            }
            try {
                oraclePreparedStatement.addBatch();
            }
            catch (Exception exception) {
                System.out.println("Inserting SRID (CS_SRS) " + l + " failed, due to " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        oraclePreparedStatement.executeBatch();
        oracleResultSet.close();
        oracleStatement.close();
        oraclePreparedStatement.close();
        oracleStatement2.close();
    }

    private static Vector<Long> getListToBeCopied(String string, OracleStatement oracleStatement, OracleStatement oracleStatement2) throws SQLException {
        Vector<Long> vector = new Vector<Long>();
        OracleResultSet oracleResultSet = (OracleResultSet)oracleStatement.executeQuery(string);
        while (oracleResultSet.next()) {
            vector.add(oracleResultSet.getLong(1));
        }
        oracleResultSet.close();
        oracleResultSet = (OracleResultSet)oracleStatement2.executeQuery(string);
        int n = 0;
        while (oracleResultSet.next()) {
            long l = oracleResultSet.getLong(1);
            while (n < vector.size() && vector.get(n) < l) {
                ++n;
            }
            if (n >= vector.size() || vector.get(n) != l) continue;
            vector.remove(n);
        }
        oracleResultSet.close();
        return vector;
    }
}

