/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.jshell;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import oracle.pg.jshell.ArgumentHandler;
import oracle.pg.jshell.GraphServerTokenProvider;
import oracle.pg.rdbms.internal.onprem.GraphRealmClient;
import oracle.pg.rdbms.internal.onprem.GraphServerClient;
import oracle.pgx.api.Analyst;
import oracle.pgx.api.Pgx;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.ServerInstance;
import oracle.pgx.api.admin.StartupLogging;
import oracle.pgx.common.UserContext;
import oracle.pgx.common.util.AuthCertUtils;
import oracle.pgx.common.util.AuthConsole;
import oracle.pgx.common.util.SystemUtils;
import oracle.pgx.common.util.Versions;
import oracle.pgx.config.ClientConfig;
import oracle.pgx.jshell.Arguments;
import oracle.pgx.jshell.Shell;
import oracle.pgx.realm.client.RealmClient;
import oracle.pgx.vfs.VirtualFile;
import oracle.pgx.vfs.VirtualFileManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    public static final String DATABASE_PASSWORD_ALIAS = "DatabasePassword";
    private static final String ESC = "\u001b";
    private static final String RED = "31";
    private static final String BLACK = "0";
    private static final String BOLD = "1";
    private static final String RESET = "0";
    private static final String RED_COMMAND = "\u001b[31m";
    private static final String BOLD_COMMAND = "\u001b[0;1m";
    private static final String RESET_COMMAND = "\u001b[0m";
    static final String PRODUCT_VERSION_LOCATION = "classpath:/META-INF/product_version.properties";
    static final String DISTRIBUTION_PROPERTY_KEY = "distribution";
    static final String VERSION_PROPERTY_KEY = "version";
    static final String STARTUP_LOG_ITEMS_KEY = "startup_log_items";

    public static ServerInstance createInstance(Arguments arguments) throws ExecutionException, InterruptedException, IOException {
        ArgumentHandler converter = new ArgumentHandler(arguments, AuthCertUtils.getSystemConsole(), new GraphServerTokenProvider());
        ClientConfig clientConfig = converter.buildClientConfig();
        String token = clientConfig.getAccessToken();
        ServerInstance instance = null;
        Cookie cookie = converter.getStickyCookie();
        if (token != null) {
            GraphServerClient client = new GraphServerClient((HttpClient)HttpClients.createDefault());
            GraphRealmClient realmClient = new GraphRealmClient(client, clientConfig.getBaseUrl(), token, 1800, cookie);
            instance = Pgx.getInstance((ClientConfig)clientConfig, (RealmClient)realmClient);
        } else {
            instance = Pgx.getInstance((ClientConfig)clientConfig);
        }
        if (instance.isEmbeddedInstance() && !instance.isEngineRunning()) {
            if (arguments.pgxConf != null) {
                try (FileInputStream is = new FileInputStream(arguments.pgxConf);){
                    instance.startEngine((InputStream)is);
                }
            } else {
                instance.startEngine();
            }
        }
        return instance;
    }

    public static PgxSession createSession(ServerInstance instance, Arguments arguments) throws ExecutionException, InterruptedException {
        PgxSession session = instance.createSession("pgxShell", arguments.idleTimeoutSecs, arguments.taskTimeoutSecs, TimeUnit.SECONDS);
        String secretStore = arguments.secretStore;
        if (secretStore != null) {
            try {
                char[] password = AuthCertUtils.checkJksKeystorePassword((String)secretStore, (AuthConsole)AuthCertUtils.getSystemConsole(), (boolean)true);
                session.registerKeystore(secretStore, password);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new ExecutionException("cannot open secret store", e);
            }
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (session != null) {
                session.close();
            }
        }));
        return session;
    }

    public static Analyst createAnalyst(PgxSession session) {
        return session.createAnalyst();
    }

    public static void printVersionBanner(ServerInstance instance) {
        Properties properties = Utils.getProductVersion();
        String productDistribution = properties.getProperty(DISTRIBUTION_PROPERTY_KEY);
        String productVersion = properties.getProperty(VERSION_PROPERTY_KEY);
        String startupItems = properties.getProperty(STARTUP_LOG_ITEMS_KEY);
        System.out.println(Utils.red(productDistribution + " Shell ") + productVersion);
        if (instance != null && StringUtils.isNotBlank((CharSequence)startupItems)) {
            String versionInfo = null;
            String shellVersion = Versions.getVersionOf(Shell.class);
            try {
                versionInfo = StartupLogging.createVersionInfoString(Utils::red, (String)shellVersion, (ServerInstance)instance);
                System.out.println(versionInfo);
            }
            catch (Exception e) {
                LOG.warn("Could not retrieve version info from server", (Throwable)e);
            }
        }
    }

    static Properties getProductVersion() {
        Properties properties = new Properties();
        try {
            VirtualFile virtualFile = VirtualFileManagerFactory.getInstance().resolve(PRODUCT_VERSION_LOCATION, UserContext.UNAUTHENTICATED_USER_CONTEXT);
            Utils.readPropertiesFromFile(virtualFile, properties);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    private static void readPropertiesFromFile(VirtualFile virtualFile, Properties properties) throws IOException {
        if (virtualFile.exists()) {
            try (InputStream inputStream = virtualFile.getInputStream();){
                properties.load(inputStream);
            }
        }
    }

    public static void printHelpInfo() {
        System.out.println("For an introduction type: " + Utils.bold("/help intro"));
    }

    public static void printAvailableVariables() {
        String instance = Utils.bold("instance");
        String session = Utils.bold("session");
        String analyst = Utils.bold("analyst");
        System.out.println("Variables " + instance + ", " + session + ", and " + analyst + " ready to use.");
    }

    public static String red(String text) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return text;
        }
        return RED_COMMAND + text + RESET_COMMAND;
    }

    public static String bold(String text) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return text;
        }
        return BOLD_COMMAND + text + RESET_COMMAND;
    }

    public static String[] splitArgs(String args) {
        String[] argsArray = args.length() == 0 ? new String[]{} : args.split("\\s+");
        return argsArray;
    }
}

