/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import oracle.pg.common.SimpleLog;
import oracle.pg.rdbms.DataChange;
import oracle.pg.rdbms.OraclePropertyGraph;

public final class VertexChange
extends DataChange {
    protected static final SimpleLog LOG = SimpleLog.getLog(VertexChange.class);
    private final String vertexLabel;

    private VertexChange(DataChange.ChangeAction changeAction, Long elementId, String propertyKey, Object value, Long startScn, Long endScn, String xId, String vertexLabel) {
        super(changeAction, elementId, propertyKey, value, startScn, endScn, xId);
        this.vertexLabel = vertexLabel;
    }

    public static VertexChange getInstance(DataChange.ChangeAction changeAction, Long elementId, String propertyKey, Object value, Long startScn, Long endScn, String xId) {
        return VertexChange.getInstance(changeAction, elementId, propertyKey, value, startScn, endScn, xId, "vertex");
    }

    public static VertexChange getInstance(DataChange.ChangeAction changeAction, Long elementId, String propertyKey, Object value, Long startScn, Long endScn, String xId, String vertexLabel) {
        return new VertexChange(changeAction, elementId, propertyKey, value, startScn, endScn, xId, vertexLabel);
    }

    public String getVertexLabel() {
        return this.vertexLabel;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.changeAction == DataChange.ChangeAction.ADD) {
            sb.append("[I]");
        } else if (this.changeAction == DataChange.ChangeAction.REMOVE) {
            sb.append("[D]");
        } else {
            sb.append("[U]");
        }
        sb.append(" SSCN=").append(VertexChange.pad(this.startScn, 12, ' ')).append(" ESCN=").append(VertexChange.pad(this.endScn, 12, ' ')).append(" XID=").append(VertexChange.pad(this.xId, 24, ' ')).append(" VID=").append(VertexChange.pad(this.elementId, 24, ' ')).append(" Key=").append(this.propertyKey).append(" Value=").append(OraclePropertyGraph.getStringForObj((Object)this.value));
        return sb.toString();
    }
}

