/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

interface RdbmsPropertyGraphConstants {
    public static final String UNEXPECTED_COLUMN_TYPE_ERROR = "Encountered unexpected column type when constructing PGQL result";
    public static final String GRANT_ACCESS_STMT = "begin   mdsys.opg_apis.grant_access(?,?,?,?); end; ";
    public static final String REVOKE_ACCESS_STMT = "begin   mdsys.opg_apis.revoke_access(?,?,?,?); end; ";
    public static final String CREATE_PG_TABLES_NO_SHARDING_STMT_STR = "begin opg_apis.create_pg(graph_owner => ?, graph_name => ?, dop => ?, num_hash_ptns => ?, tbs => ?, options => ?); end;";
    public static final String CREATE_PG_TABLES_SHARDING_STMT_STR = "begin opg_apis.create_pg(graph_owner => ?, graph_name => ?, dop => ?, num_hash_ptns => ?, tbs => ?, tbs_set => ?, options => ?); end;";
    public static final String GET_INTERNAL_ID_STMT_STR = "\n declare r number; \n begin \n   select sys_op_combined_hash(:1)/4 into r from dual ; \n   :2 := r; \n end;";
    public static final String CREATE_PROPERTY_NAMES_ARRAY_TYPE = "CREATE OR REPLACE TYPE pnames_array AS TABLE OF NVARCHAR2(3100);";
    public static final String CREATE_PROPERTY_T_ARRAY_TYPE = "CREATE OR REPLACE TYPE ptypes_array AS TABLE OF NUMBER;";
    public static final String CREATE_PROPERTY_V_ARRAY_TYPE = "CREATE OR REPLACE TYPE p_strvalues_array AS TABLE OF NVARCHAR2(15000);";
    public static final String CREATE_PROPERTY_VN_ARRAY_TYPE = "CREATE OR REPLACE TYPE p_numvalues_array AS TABLE OF NUMBER;";
    public static final String ADD_VERTEX_STMT_STR = "\n declare towner varchar2(128); vowner varchar2(128); vertextab varchar2(128); vvertextab varchar2(128);\n         s number; vl nvarchar2(3100); df nvarchar2(3100); nf nvarchar2(3100); vs nvarchar2(15000);\n         vts date; vte date; pn_array pnames_array; pt_array ptypes_array; pv_array p_strvalues_array;\n         pvn_array p_numvalues_array; vl_str nvarchar2(200); vl_val_str nvarchar2(200); \n         vt timestamp(6) with time zone; populate_vl number; t number; vn number;  k nvarchar2(3100);\n         sql_stmt varchar2(32000); \n begin \n   towner   := :1; \n   vertextab := :2; \n   populate_vl := :3; \n   s   := :4; \n   vl  := :5; \n   nf  := :6; \n   df  := :7; \n   vts := :8; \n   vte := :9; \n   pn_array := :10; \n   pt_array := :11; \n   pv_array := :12; \n   pvn_array := :13; \n   vl_str := ''; \n   vl_val_str := ''; \n   if (populate_vl = 1) then \n     vl_str := 'vl,'; \n     vl_val_str := ':vl,'; \n   end if; \n   vvertextab := sys.dbms_assert.enquote_name(sys.dbms_assert.qualified_sql_name(vertextab));\n   vowner := sys.dbms_assert.enquote_name(sys.dbms_assert.qualified_sql_name(towner));\n   sql_stmt := 'delete from ' || vowner || '.' || vvertextab || ' where vid = :s '; \n   execute immediate sql_stmt using s; \n     begin \n       if pn_array is NULL or pn_array is empty then \n         sql_stmt := 'insert into ' || vowner || '.' || vvertextab || \n                          ' (vid, ' || vl_str || ' k, t, v, vn, vt, vts, vte)  \n                           values(:s, ' || vl_val_str || ''' '', null, null, null, null, :vts, :vte)';\n         if (populate_vl = 1) then \n           execute immediate sql_stmt using s, vl, vts, vte; \n         else \n           execute immediate sql_stmt using s, vts, vte; \n         end if;\n       else \n         for i in pn_array.FIRST .. pn_array.LAST\n           loop \n             t := pt_array(i);\n             if (t = 5) then \n               vt := to_timestamp_tz(pv_array(i), 'YYYY-MM-DD\"T\"HH24:MI:SS.FF3TZR'); \n             else \n               vt := null; \n             end if; \n             vn := pvn_array(i); \n             k  := pn_array(i); \n             case when t in (2,3,4,7,8,9) then vs:= to_char(vn, nf); \n               when t in (5) then \n                 vs:= to_char(vt, df); \n               else vs:= pv_array(i);\n             end case; \n             if (t >= 1) then \n               sql_stmt := 'insert into ' || vowner || '.' || vvertextab || \n                          ' (vid, ' || vl_str || ' k, t, v, vn, vt, vts, vte)  \n                           values(:s, ' || vl_val_str || ' nvl(:k, '' ''), :t, :vs, :vn, \n                                  :vt, :vts, :vte)';\n               if (populate_vl = 1) then \n                 execute immediate sql_stmt using s, vl, k, t, vs, vn, vt, vts, vte; \n               else \n                 execute immediate sql_stmt using s, k, t, vs, vn, vt, vts, vte; \n               end if;\n             end if;\n           end loop;\n       end if; \n     exception \n       when others then -- need to detect unique key violation \n         raise; \n     end;\n end;";
    public static final String ADD_EDGE_STMT_STR = "\n declare towner varchar2(128); vowner varchar2(128); edgetab varchar2(128); vedgetab varchar2(128);\n         s number; svid number; dvid number; el nvarchar2(3100); df nvarchar2(3100); nf nvarchar2(3100); \n         vts date; vte date; pn_array pnames_array; pt_array ptypes_array; pv_array p_strvalues_array;\n         pvn_array p_numvalues_array; vt timestamp(6) with time zone; t number; \n         vn number; k nvarchar2(3100); sql_stmt varchar2(32000); vs nvarchar2(15000);\n begin \n   towner   := :1; \n   edgetab := :2; \n   s   := :4; \n   svid := :5; \n   dvid := :6; \n   el  := :7; \n   nf  := :8; \n   df  := :9; \n   vts := :10; \n   vte := :11; \n   pn_array := :12; \n   pt_array := :13; \n   pv_array := :14; \n   pvn_array := :16; \n   vedgetab := sys.dbms_assert.enquote_name(sys.dbms_assert.qualified_sql_name(edgetab));\n   vowner := sys.dbms_assert.enquote_name(sys.dbms_assert.qualified_sql_name(towner));\n   sql_stmt := 'delete from ' || vowner || '.' || vedgetab || ' where eid = :s '; \n   execute immediate sql_stmt using s; \n     begin \n       if pn_array is NULL or pn_array is empty then \n         sql_stmt := 'insert into ' || vowner || '.' || vedgetab || \n                          ' (eid, SVID, DVID, EL, k, vts, vte)  \n                           values(:s, :svid, :dvid, :el, '' '', :vts, :vte)';\n         execute immediate sql_stmt using s, svid, dvid, el, vts, vte; \n       else \n         for i in pn_array.FIRST .. pn_array.LAST\n           loop \n             t := pt_array(i);\n             if (t = 5) then \n               vt := to_timestamp_tz(pv_array(i), 'YYYY-MM-DD\"T\"HH24:MI:SS.FF3TZR'); \n             else \n               vt := null; \n             end if; \n             vn := pvn_array(i); \n             k  := pn_array(i); \n             case when t in (2,3,4,7,8,9) then vs:= to_char(vn, nf); \n               when t in (5) then \n                 vs:= to_char(vt, df); \n               else vs:= pv_array(i);\n             end case; \n             if (t >= 1) then \n               sql_stmt := 'insert into ' || vowner || '.' || vedgetab || \n                          ' (eid, SVID, DVID, EL, k, t, v, vn, vt, vts, vte)  \n                           values(:s, :svid, :dvid, :el, nvl(:k, '' ''), :t, :vs, :vn, \n                                  :vt, :vts, :vte)';\n               execute immediate sql_stmt using s, svid, dvid, el, k, t, vs, vn, vt, vts, vte; \n             end if;\n           end loop;\n       end if; \n     exception \n       when others then -- need to detect unique key violation \n         raise; \n     end;\n end;";
    public static final String READ_VERTICES_PROJECTED_VARS_ALL = "vid,vl,k,t,v,vn,";
    public static final String READ_VERTICES_PROJECTED_VARS_NO_VL = "vid,k,t,v,vn,";
    public static final String DEFAULT_NUMBER_FORMAT = "TM9";
    public static final String DEFAULT_TIME_FORMAT = "SYYYY-MM-DD\"T\"HH24:MI:SS.FF9TZH:TZM";
    public static final String DEFAULT_TIME_DB_FORMAT = "YYYY-MM-DD'T'HH24:MI:SS.FF3TZR";
    public static final String DROP_PG_STMT_STR = "begin opg_apis.drop_pg(:1); end;";
    public static final String EXIST_PG_STMT_STR = "select table_name from all_tables where table_name = ? or table_name = ? or table_name = ? or table_name = ? or table_name = ? ";
    public static final String VERTEX_TABLE_SUFFIX = "VT$";
    public static final String EDGE_TABLE_SUFFIX = "GE$";
    public static final String SKELETON_TABLE_SUFFIX = "GT$";
    public static final String TEXT_INDEX_TABLE_SUFFIX = "IT$";
    public static final String SNAPSHOT_TABLE_SUFFIX = "SS$";
    public static final String VERTEX_DISTINCT_TABLE_SUFFIX = "VD$";
}

